/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.os.Build;
import android.util.Log;
import com.tencent.tinker.loader.shareutil.ShareFileLockHelper;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class TinkerDexOptimizer {
    private static final String TAG = "Tinker.ParallelDex";
    private static final String INTERPRET_LOCK_FILE_NAME = "interpret.lock";

    public static boolean optimizeAll(Collection<File> dexFiles, File optimizedDir, ResultCallback cb) {
        return TinkerDexOptimizer.optimizeAll(dexFiles, optimizedDir, false, null, cb);
    }

    public static boolean optimizeAll(Collection<File> dexFiles, File optimizedDir, boolean useInterpretMode, String targetISA, ResultCallback cb) {
        ArrayList<File> sortList = new ArrayList<File>(dexFiles);
        Collections.sort(sortList, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                long diffSize = lhs.length() - rhs.length();
                if (diffSize > 0L) {
                    return 1;
                }
                if (diffSize == 0L) {
                    return 0;
                }
                return -1;
            }
        });
        Collections.reverse(sortList);
        for (File dexFile : sortList) {
            OptimizeWorker worker = new OptimizeWorker(dexFile, optimizedDir, useInterpretMode, targetISA, cb);
            if (worker.run()) continue;
            return false;
        }
        return true;
    }

    private static class StreamConsumer {
        static final Executor STREAM_CONSUMER = Executors.newSingleThreadExecutor();

        private StreamConsumer() {
        }

        static void consumeInputStream(final InputStream is) {
            STREAM_CONSUMER.execute(new Runnable(){

                @Override
                public void run() {
                    if (is == null) {
                        return;
                    }
                    byte[] buffer = new byte[256];
                    try {
                        while (is.read(buffer) > 0) {
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    private static class OptimizeWorker {
        private static String targetISA = null;
        private final File dexFile;
        private final File optimizedDir;
        private final boolean useInterpretMode;
        private final ResultCallback callback;

        OptimizeWorker(File dexFile, File optimizedDir, boolean useInterpretMode, String targetISA, ResultCallback cb) {
            this.dexFile = dexFile;
            this.optimizedDir = optimizedDir;
            this.useInterpretMode = useInterpretMode;
            this.callback = cb;
            OptimizeWorker.targetISA = targetISA;
        }

        public boolean run() {
            block7: {
                try {
                    if (!SharePatchFileUtil.isLegalFile(this.dexFile) && this.callback != null) {
                        this.callback.onFailed(this.dexFile, this.optimizedDir, new IOException("dex file " + this.dexFile.getAbsolutePath() + " is not exist!"));
                        return false;
                    }
                    if (this.callback != null) {
                        this.callback.onStart(this.dexFile, this.optimizedDir);
                    }
                    String optimizedPath = SharePatchFileUtil.optimizedPathFor(this.dexFile, this.optimizedDir);
                    if (this.useInterpretMode) {
                        this.interpretDex2Oat(this.dexFile.getAbsolutePath(), optimizedPath);
                    } else {
                        DexFile.loadDex((String)this.dexFile.getAbsolutePath(), (String)optimizedPath, (int)0);
                    }
                    if (this.callback != null) {
                        this.callback.onSuccess(this.dexFile, this.optimizedDir, new File(optimizedPath));
                    }
                }
                catch (Throwable e) {
                    Log.e((String)TinkerDexOptimizer.TAG, (String)("Failed to optimize dex: " + this.dexFile.getAbsolutePath()), (Throwable)e);
                    if (this.callback == null) break block7;
                    this.callback.onFailed(this.dexFile, this.optimizedDir, e);
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void interpretDex2Oat(String dexFilePath, String oatFilePath) throws IOException {
            File oatFile = new File(oatFilePath);
            if (!oatFile.exists()) {
                oatFile.getParentFile().mkdirs();
            }
            File lockFile = new File(oatFile.getParentFile(), TinkerDexOptimizer.INTERPRET_LOCK_FILE_NAME);
            ShareFileLockHelper fileLock = null;
            try {
                fileLock = ShareFileLockHelper.getFileLock(lockFile);
                ArrayList<String> commandAndParams = new ArrayList<String>();
                commandAndParams.add("dex2oat");
                if (Build.VERSION.SDK_INT >= 24) {
                    commandAndParams.add("--runtime-arg");
                    commandAndParams.add("-classpath");
                    commandAndParams.add("--runtime-arg");
                    commandAndParams.add("&");
                }
                commandAndParams.add("--dex-file=" + dexFilePath);
                commandAndParams.add("--oat-file=" + oatFilePath);
                commandAndParams.add("--instruction-set=" + targetISA);
                if (Build.VERSION.SDK_INT > 25) {
                    commandAndParams.add("--compiler-filter=quicken");
                } else {
                    commandAndParams.add("--compiler-filter=interpret-only");
                }
                ProcessBuilder pb = new ProcessBuilder(commandAndParams);
                pb.redirectErrorStream(true);
                Process dex2oatProcess = pb.start();
                StreamConsumer.consumeInputStream(dex2oatProcess.getInputStream());
                StreamConsumer.consumeInputStream(dex2oatProcess.getErrorStream());
                try {
                    int ret = dex2oatProcess.waitFor();
                    if (ret != 0) {
                        throw new IOException("dex2oat works unsuccessfully, exit code: " + ret);
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException("dex2oat is interrupted, msg: " + e.getMessage(), e);
                }
            }
            finally {
                try {
                    if (fileLock != null) {
                        fileLock.close();
                    }
                }
                catch (IOException e) {
                    Log.w((String)TinkerDexOptimizer.TAG, (String)"release interpret Lock error", (Throwable)e);
                }
            }
        }
    }

    public static interface ResultCallback {
        public void onStart(File var1, File var2);

        public void onSuccess(File var1, File var2, File var3);

        public void onFailed(File var1, File var2, Throwable var3);
    }
}

