/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.content.Intent;
import android.util.Log;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.shareutil.ShareArkHotDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TinkerArkHotLoader {
    private static final String TAG = "Tinker.ArkHotLoader";
    private static final String ARK_MEAT_FILE = "assets/arkHot_meta.txt";
    private static final String ARKHOT_PATH = "arkHot";
    private static HashSet<ShareArkHotDiffPatchInfo> arkHotApkInfo = new HashSet();
    private static boolean isArkHotRuning = ShareTinkerInternals.isArkHotRuning();

    private TinkerArkHotLoader() {
    }

    @TargetApi(value=14)
    public static boolean loadTinkerArkHot(TinkerApplication application, String directory, Intent intentResult) {
        if (arkHotApkInfo.isEmpty()) {
            Log.w((String)TAG, (String)"there is no apk to load");
            return true;
        }
        PathClassLoader classLoader = (PathClassLoader)TinkerArkHotLoader.class.getClassLoader();
        if (classLoader == null) {
            Log.e((String)TAG, (String)"classloader is null");
            ShareIntentUtil.setIntentReturnCode(intentResult, -12);
            return false;
        }
        Log.i((String)TAG, (String)("classloader: " + classLoader.toString()));
        String apkPath = directory + "/" + ARKHOT_PATH + "/";
        ArrayList<File> legalFiles = new ArrayList<File>();
        if (isArkHotRuning && !arkHotApkInfo.isEmpty()) {
            File classNFile = null;
            classNFile = new File(apkPath + "patch.apk");
            legalFiles.add(classNFile);
        }
        try {
            SystemClassLoaderAdder.installApk(classLoader, legalFiles);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"install dexes failed");
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -14);
            return false;
        }
        return true;
    }

    public static boolean checkComplete(String directory, ShareSecurityCheck securityCheck, Intent intentResult) {
        String apkDirectory;
        File dexDir;
        String meta = securityCheck.getMetaContentMap().get(ARK_MEAT_FILE);
        if (meta == null) {
            return true;
        }
        arkHotApkInfo.clear();
        ArrayList<ShareArkHotDiffPatchInfo> allDexInfo = new ArrayList<ShareArkHotDiffPatchInfo>();
        ShareArkHotDiffPatchInfo.parseDiffPatchInfo(meta, allDexInfo);
        if (allDexInfo.isEmpty()) {
            return true;
        }
        HashMap<String, String> apks = new HashMap<String, String>(1);
        for (ShareArkHotDiffPatchInfo info : allDexInfo) {
            if (!ShareArkHotDiffPatchInfo.checkDiffPatchInfo(info)) {
                intentResult.putExtra("intent_patch_package_patch_check", -3);
                ShareIntentUtil.setIntentReturnCode(intentResult, -8);
                return false;
            }
            if (!isArkHotRuning || !"patch.apk".equals(info.name)) continue;
            arkHotApkInfo.add(info);
        }
        if (isArkHotRuning && !arkHotApkInfo.isEmpty()) {
            apks.put("patch.apk", "");
        }
        if (!(dexDir = new File(apkDirectory = directory + "/" + ARKHOT_PATH + "/")).exists() || !dexDir.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -9);
            return false;
        }
        for (String name : apks.keySet()) {
            File apkFile = new File(apkDirectory + name);
            if (SharePatchFileUtil.isLegalFile(apkFile)) continue;
            try {
                intentResult.putExtra("intent_patch_missing_dex_path", apkFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ShareIntentUtil.setIntentReturnCode(intentResult, -10);
            return false;
        }
        intentResult.putExtra("intent_patch_dexes_path", apks);
        return true;
    }
}

