/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug.interceptor;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.IInterface;
import android.util.Log;
import com.tencent.tinker.loader.hotplug.interceptor.Interceptor;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class ServiceBinderInterceptor
extends Interceptor<IBinder> {
    private static final String TAG = "Tinker.SvcBndrIntrcptr";
    private final Context mBaseContext;
    private final String mServiceName;
    private final BinderInvocationHandler mBinderInvocationHandler;
    private static Class<?> sServiceManagerClazz = null;
    private static Field sSCacheField = null;
    private static Method sGetServiceMethod = null;

    public ServiceBinderInterceptor(Context context, String serviceName, BinderInvocationHandler binderInvocationHandler) {
        while (context != null && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        this.mBaseContext = context;
        this.mServiceName = serviceName;
        this.mBinderInvocationHandler = binderInvocationHandler;
    }

    @Override
    protected IBinder fetchTarget() throws Throwable {
        return (IBinder)sGetServiceMethod.invoke(null, this.mServiceName);
    }

    @Override
    protected IBinder decorate(IBinder target) throws Throwable {
        if (target == null) {
            throw new IllegalStateException("target is null.");
        }
        if (Interceptor.ITinkerHotplugProxy.class.isAssignableFrom(target.getClass())) {
            return target;
        }
        return (IBinder)ServiceBinderInterceptor.createProxy(ServiceBinderInterceptor.getAllInterfacesThroughDeriveChain(target.getClass()), new FakeClientBinderHandler(target, this.mBinderInvocationHandler));
    }

    @Override
    protected void inject(IBinder decorated) throws Throwable {
        Map sCache = (Map)sSCacheField.get(null);
        sCache.put(this.mServiceName, decorated);
        if ("activity".equals(this.mServiceName)) {
            ServiceBinderInterceptor.fixAMSBinderCache(decorated);
        } else if ("package".equals(this.mServiceName)) {
            ServiceBinderInterceptor.fixPMSBinderCache(this.mBaseContext, decorated);
        }
    }

    private static void fixAMSBinderCache(IBinder fakeBinder) throws Throwable {
        Object singletonObj = null;
        try {
            Class<?> amsNativeClazz = Class.forName("android.app.ActivityManagerNative");
            Field gDefaultField = ShareReflectUtil.findField(amsNativeClazz, "gDefault");
            singletonObj = gDefaultField.get(null);
        }
        catch (Throwable thr) {
            Class<?> amClazz = Class.forName("android.app.ActivityManager");
            Field iActivityManagerSingletonField = ShareReflectUtil.findField(amClazz, "IActivityManagerSingleton");
            singletonObj = iActivityManagerSingletonField.get(null);
        }
        Field mInstanceField = ShareReflectUtil.findField(singletonObj, "mInstance");
        IInterface originalInterface = (IInterface)mInstanceField.get(singletonObj);
        if (originalInterface == null || Interceptor.ITinkerHotplugProxy.class.isAssignableFrom(originalInterface.getClass())) {
            return;
        }
        IInterface fakeInterface = fakeBinder.queryLocalInterface(fakeBinder.getInterfaceDescriptor());
        if (fakeInterface == null || !Interceptor.ITinkerHotplugProxy.class.isAssignableFrom(fakeInterface.getClass())) {
            throw new IllegalStateException("fakeBinder does not return fakeInterface, binder: " + fakeBinder + ", itf: " + fakeInterface);
        }
        mInstanceField.set(singletonObj, fakeInterface);
    }

    private static void fixPMSBinderCache(Context context, IBinder fakeBinder) throws Throwable {
        PackageManager pm;
        Class<?> applicationPackageManagerClazz;
        Field mPMField;
        IInterface originalInterface2;
        Class<?> activityThreadClazz = Class.forName("android.app.ActivityThread");
        Field sPackageManagerField = ShareReflectUtil.findField(activityThreadClazz, "sPackageManager");
        IInterface originalInterface = (IInterface)sPackageManagerField.get(null);
        if (originalInterface != null && !Interceptor.ITinkerHotplugProxy.class.isAssignableFrom(originalInterface.getClass())) {
            IInterface fakeInterface = fakeBinder.queryLocalInterface(fakeBinder.getInterfaceDescriptor());
            if (fakeInterface == null || !Interceptor.ITinkerHotplugProxy.class.isAssignableFrom(fakeInterface.getClass())) {
                throw new IllegalStateException("fakeBinder does not return fakeInterface, binder: " + fakeBinder + ", itf: " + fakeInterface);
            }
            sPackageManagerField.set(null, fakeInterface);
        }
        if ((originalInterface2 = (IInterface)(mPMField = ShareReflectUtil.findField(applicationPackageManagerClazz = Class.forName("android.app.ApplicationPackageManager"), "mPM")).get(pm = context.getPackageManager())) != null && !Interceptor.ITinkerHotplugProxy.class.isAssignableFrom(originalInterface2.getClass())) {
            IInterface fakeInterface = fakeBinder.queryLocalInterface(fakeBinder.getInterfaceDescriptor());
            if (fakeInterface == null || !Interceptor.ITinkerHotplugProxy.class.isAssignableFrom(fakeInterface.getClass())) {
                throw new IllegalStateException("fakeBinder does not return fakeInterface, binder: " + fakeBinder + ", itf: " + fakeInterface);
            }
            mPMField.set(pm, fakeInterface);
        }
    }

    private static <T> T createProxy(Class<?>[] itfs, InvocationHandler handler) {
        Class[] mergedItfs = new Class[itfs.length + 1];
        System.arraycopy(itfs, 0, mergedItfs, 0, itfs.length);
        mergedItfs[itfs.length] = Interceptor.ITinkerHotplugProxy.class;
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
            return (T)Proxy.newProxyInstance(cl, mergedItfs, handler);
        }
        catch (Throwable thr) {
            final HashSet<ClassLoader> uniqueCls = new HashSet<ClassLoader>(4);
            for (Class itf : mergedItfs) {
                uniqueCls.add(itf.getClassLoader());
            }
            cl = uniqueCls.size() == 1 ? (ClassLoader)uniqueCls.iterator().next() : new ClassLoader(){

                @Override
                protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
                    Class<?> res = null;
                    for (ClassLoader cl : uniqueCls) {
                        try {
                            res = cl.loadClass(className);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (res == null) continue;
                        return res;
                    }
                    throw new ClassNotFoundException("cannot find class: " + className);
                }
            };
            try {
                return (T)Proxy.newProxyInstance(cl, mergedItfs, handler);
            }
            catch (Throwable thr2) {
                throw new RuntimeException("cl: " + cl, thr);
            }
        }
    }

    private static Class<?>[] getAllInterfacesThroughDeriveChain(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        HashSet itfs = new HashSet(10);
        while (!Object.class.equals(clazz)) {
            itfs.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return itfs.toArray(new Class[itfs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<ServiceBinderInterceptor> clazz = ServiceBinderInterceptor.class;
        synchronized (ServiceBinderInterceptor.class) {
            if (sServiceManagerClazz == null) {
                try {
                    sServiceManagerClazz = Class.forName("android.os.ServiceManager");
                    sSCacheField = ShareReflectUtil.findField(sServiceManagerClazz, "sCache");
                    sGetServiceMethod = ShareReflectUtil.findMethod(sServiceManagerClazz, "getService", String.class);
                }
                catch (Throwable thr) {
                    Log.e((String)TAG, (String)"unexpected exception.", (Throwable)thr);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class FakeInterfaceHandler
    implements InvocationHandler {
        private final BinderInvocationHandler mBinderInvocationHandler;
        private final IBinder mOriginalClientBinder;
        private final IInterface mOriginalInterface;

        FakeInterfaceHandler(IInterface originalInterface, IBinder originalClientBinder, BinderInvocationHandler binderInvocationHandler) {
            this.mOriginalInterface = originalInterface;
            this.mOriginalClientBinder = originalClientBinder;
            this.mBinderInvocationHandler = binderInvocationHandler;
        }

        @Override
        public Object invoke(Object fakeIInterface, Method method, Object[] args) throws Throwable {
            if ("asBinder".equals(method.getName())) {
                return this.mOriginalClientBinder;
            }
            return this.mBinderInvocationHandler.invoke(this.mOriginalInterface, method, args);
        }
    }

    private static class FakeClientBinderHandler
    implements InvocationHandler {
        private final BinderInvocationHandler mBinderInvocationHandler;
        private final IBinder mOriginalClientBinder;

        FakeClientBinderHandler(IBinder originalClientBinder, BinderInvocationHandler binderInvocationHandler) {
            this.mOriginalClientBinder = originalClientBinder;
            this.mBinderInvocationHandler = binderInvocationHandler;
        }

        @Override
        public Object invoke(Object fakeClientBinder, Method method, Object[] args) throws Throwable {
            if ("queryLocalInterface".equals(method.getName())) {
                String itfName = this.mOriginalClientBinder.getInterfaceDescriptor();
                String stubClassName = null;
                stubClassName = itfName.equals("android.app.IActivityManager") ? "android.app.ActivityManagerNative" : itfName + "$Stub";
                Class<?> stubClazz = Class.forName(stubClassName);
                Method asInterfaceMethod = ShareReflectUtil.findMethod(stubClazz, "asInterface", IBinder.class);
                IInterface originalInterface = (IInterface)asInterfaceMethod.invoke(null, this.mOriginalClientBinder);
                FakeInterfaceHandler fakeInterfaceHandler = new FakeInterfaceHandler(originalInterface, (IBinder)fakeClientBinder, this.mBinderInvocationHandler);
                return ServiceBinderInterceptor.createProxy(ServiceBinderInterceptor.getAllInterfacesThroughDeriveChain(originalInterface.getClass()), fakeInterfaceHandler);
            }
            return method.invoke((Object)this.mOriginalClientBinder, args);
        }
    }

    public static interface BinderInvocationHandler {
        public Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;
    }
}

