/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.reflect.Field;

public final class AppInfoChangedBlocker {
    private static final String TAG = "Tinker.AppInfoChangedBlocker";

    public static boolean tryStart(Application app) {
        if (Build.VERSION.SDK_INT < 26) {
            Log.i((String)TAG, (String)"tryStart: SDK_INT is less than 26, skip rest logic.");
            return true;
        }
        try {
            Log.i((String)TAG, (String)"tryStart called.");
            AppInfoChangedBlocker.interceptHandler(AppInfoChangedBlocker.fetchMHObject((Context)app));
            Log.i((String)TAG, (String)"tryStart done.");
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"AppInfoChangedBlocker start failed, simply ignore.", (Throwable)e);
            return false;
        }
    }

    private static Handler fetchMHObject(Context context) throws Exception {
        Object activityThread = ShareReflectUtil.getActivityThread(context, null);
        Field mHField = ShareReflectUtil.findField(activityThread, "mH");
        return (Handler)mHField.get(activityThread);
    }

    private static void interceptHandler(Handler mH) throws Exception {
        Field mCallbackField = ShareReflectUtil.findField(Handler.class, "mCallback");
        Handler.Callback originCallback = (Handler.Callback)mCallbackField.get(mH);
        if (!(originCallback instanceof HackerCallback)) {
            HackerCallback hackerCallback = new HackerCallback(originCallback, mH.getClass());
            mCallbackField.set(mH, hackerCallback);
        } else {
            Log.w((String)TAG, (String)"Already intercepted, skip rest logic.");
        }
    }

    private static class HackerCallback
    implements Handler.Callback {
        private final int APPLICATION_INFO_CHANGED;
        private Handler.Callback origin;

        HackerCallback(Handler.Callback ori, Class $H) {
            int appInfoChanged;
            this.origin = ori;
            try {
                appInfoChanged = ShareReflectUtil.findField($H, "APPLICATION_INFO_CHANGED").getInt(null);
            }
            catch (Throwable e) {
                appInfoChanged = 156;
            }
            this.APPLICATION_INFO_CHANGED = appInfoChanged;
        }

        public boolean handleMessage(Message msg) {
            boolean consume = false;
            if (this.hackMessage(msg)) {
                consume = true;
            } else if (this.origin != null) {
                consume = this.origin.handleMessage(msg);
            }
            return consume;
        }

        private boolean hackMessage(Message msg) {
            if (msg.what == this.APPLICATION_INFO_CHANGED) {
                Process.killProcess((int)Process.myPid());
                return true;
            }
            return false;
        }
    }
}

