/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;

public class ShareFileLockHelper
implements Closeable {
    public static final int MAX_LOCK_ATTEMPTS = 3;
    public static final int LOCK_WAIT_EACH_TIME = 10;
    private static final String TAG = "Tinker.FileLockHelper";
    private final FileOutputStream outputStream;
    private final FileLock fileLock;

    private ShareFileLockHelper(File lockFile) throws IOException {
        this.outputStream = new FileOutputStream(lockFile);
        int numAttempts = 0;
        FileLock localFileLock = null;
        Exception saveException = null;
        while (numAttempts < 3) {
            ++numAttempts;
            try {
                boolean isGetLockSuccess;
                localFileLock = this.outputStream.getChannel().lock();
                boolean bl = isGetLockSuccess = localFileLock != null;
                if (isGetLockSuccess) {
                    break;
                }
            }
            catch (Exception e) {
                saveException = e;
                Log.e((String)TAG, (String)"getInfoLock Thread failed time:10");
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception ignore) {
                Log.e((String)TAG, (String)"getInfoLock Thread sleep exception", (Throwable)ignore);
            }
        }
        if (localFileLock == null) {
            throw new IOException("Tinker Exception:FileLockHelper lock file failed: " + lockFile.getAbsolutePath(), saveException);
        }
        this.fileLock = localFileLock;
    }

    public static ShareFileLockHelper getFileLock(File lockFile) throws IOException {
        return new ShareFileLockHelper(lockFile);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
        }
        finally {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }
}

