/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import java.util.ArrayList;

public class ShareArkHotDiffPatchInfo {
    public String path;
    public String name;
    public String patchMd5;

    public ShareArkHotDiffPatchInfo(String path, String name, String md5) {
        this.name = name;
        this.patchMd5 = md5;
        this.path = path;
    }

    public static void parseDiffPatchInfo(String meta, ArrayList<ShareArkHotDiffPatchInfo> diffList) {
        String[] lines;
        if (meta == null || diffList == null) {
            return;
        }
        for (String line : lines = meta.split("\n")) {
            String[] kv;
            if (line == null || line.length() <= 0 || (kv = line.split(",", 4)) == null || kv.length < 3) continue;
            String name = kv[0].trim();
            String path = kv[1].trim();
            String md5 = kv[2].trim();
            ShareArkHotDiffPatchInfo arkDiffInfo = new ShareArkHotDiffPatchInfo(path, name, md5);
            diffList.add(arkDiffInfo);
        }
    }

    public static boolean checkDiffPatchInfo(ShareArkHotDiffPatchInfo info) {
        if (info == null) {
            return false;
        }
        String name = info.name;
        String md5 = info.patchMd5;
        return name != null && name.length() > 0 && md5 != null && md5.length() == 32;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(",");
        sb.append(this.path);
        sb.append(",");
        sb.append(this.patchMd5);
        return sb.toString();
    }
}

