/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug.interceptor;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.tinker.loader.hotplug.interceptor.InterceptFailedException;

public abstract class Interceptor<T_TARGET> {
    private static final String TAG = "Tinker.Interceptor";
    private T_TARGET mTarget = null;
    private volatile boolean mInstalled = false;

    @Nullable
    protected abstract T_TARGET fetchTarget() throws Throwable;

    @NonNull
    protected T_TARGET decorate(@Nullable T_TARGET target) throws Throwable {
        return target;
    }

    protected abstract void inject(@Nullable T_TARGET var1) throws Throwable;

    public synchronized void install() throws InterceptFailedException {
        try {
            T_TARGET target = this.fetchTarget();
            this.mTarget = target;
            T_TARGET decorated = this.decorate(target);
            if (decorated != target) {
                this.inject(decorated);
            } else {
                Log.w((String)TAG, (String)("target: " + target + " was already hooked."));
            }
            this.mInstalled = true;
        }
        catch (Throwable thr) {
            this.mTarget = null;
            throw new InterceptFailedException(thr);
        }
    }

    public synchronized void uninstall() throws InterceptFailedException {
        if (this.mInstalled) {
            try {
                this.inject(this.mTarget);
                this.mTarget = null;
                this.mInstalled = false;
            }
            catch (Throwable thr) {
                throw new InterceptFailedException(thr);
            }
        }
    }

    protected static interface ITinkerHotplugProxy {
    }
}

