/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug.interceptor;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.tinker.loader.hotplug.interceptor.Interceptor;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.reflect.Field;

public class HandlerMessageInterceptor
extends Interceptor<Handler.Callback> {
    private final Handler mTarget;
    private final MessageHandler mMessageHandler;
    private static Field sMCallbackField = null;

    public HandlerMessageInterceptor(Handler target, MessageHandler messageHandler) {
        this.mTarget = target;
        this.mMessageHandler = messageHandler;
    }

    @Override
    @Nullable
    protected Handler.Callback fetchTarget() throws Throwable {
        return (Handler.Callback)sMCallbackField.get(this.mTarget);
    }

    @Override
    @NonNull
    protected Handler.Callback decorate(@Nullable Handler.Callback callback) throws Throwable {
        if (callback != null && Interceptor.ITinkerHotplugProxy.class.isAssignableFrom(callback.getClass())) {
            return callback;
        }
        return new CallbackWrapper(this.mMessageHandler, callback);
    }

    @Override
    protected void inject(@Nullable Handler.Callback decorated) throws Throwable {
        sMCallbackField.set(this.mTarget, decorated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<HandlerMessageInterceptor> clazz = HandlerMessageInterceptor.class;
        synchronized (HandlerMessageInterceptor.class) {
            if (sMCallbackField == null) {
                try {
                    sMCallbackField = ShareReflectUtil.findField(Handler.class, "mCallback");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class CallbackWrapper
    implements Handler.Callback,
    Interceptor.ITinkerHotplugProxy {
        private final MessageHandler mMessageHandler;
        private final Handler.Callback mOrigCallback;
        private volatile boolean mIsInHandleMethod;

        CallbackWrapper(MessageHandler messageHandler, Handler.Callback origCallback) {
            this.mMessageHandler = messageHandler;
            this.mOrigCallback = origCallback;
            this.mIsInHandleMethod = false;
        }

        public boolean handleMessage(Message message) {
            boolean result = false;
            if (this.mIsInHandleMethod) {
                return result;
            }
            this.mIsInHandleMethod = true;
            if (this.mMessageHandler.handleMessage(message)) {
                result = true;
            } else if (this.mOrigCallback != null) {
                result = this.mOrigCallback.handleMessage(message);
            }
            this.mIsInHandleMethod = false;
            return result;
        }
    }

    public static interface MessageHandler {
        public boolean handleMessage(Message var1);
    }
}

