/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.SuppressLint;
import androidx.annotation.Keep;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;

@SuppressLint(value={"NewApi"})
public final class TinkerClassLoader
extends BaseDexClassLoader {
    private final ClassLoader mOriginAppClassLoader;

    TinkerClassLoader(String dexPath, File optimizedDir, String libraryPath, ClassLoader originAppClassLoader) {
        super(dexPath, optimizedDir, libraryPath, ClassLoader.getSystemClassLoader());
        this.mOriginAppClassLoader = originAppClassLoader;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = super.findClass(name);
        }
        catch (ClassNotFoundException ignored) {
            cl = null;
        }
        if (cl != null) {
            return cl;
        }
        return this.mOriginAppClassLoader.loadClass(name);
    }

    public URL getResource(String name) {
        URL resource = Object.class.getClassLoader().getResource(name);
        if (resource != null) {
            return resource;
        }
        resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        return this.mOriginAppClassLoader.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[]{Object.class.getClassLoader().getResources(name), this.findResources(name), this.mOriginAppClassLoader.getResources(name)};
        return new CompoundEnumeration<URL>(resources);
    }

    @Keep
    class CompoundEnumeration<E>
    implements Enumeration<E> {
        private Enumeration<E>[] enums;
        private int index = 0;

        public CompoundEnumeration(Enumeration<E>[] enums) {
            this.enums = enums;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public E nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

