/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.TinkerResourcePatcher;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareResPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;

public class TinkerResourceLoader {
    protected static final String RESOURCE_META_FILE = "assets/res_meta.txt";
    protected static final String RESOURCE_FILE = "resources.apk";
    protected static final String RESOURCE_PATH = "res";
    private static final String TAG = "Tinker.ResourceLoader";
    private static ShareResPatchInfo resPatchInfo = new ShareResPatchInfo();

    private TinkerResourceLoader() {
    }

    public static boolean loadTinkerResources(TinkerApplication application, String directory, Intent intentResult) {
        if (resPatchInfo == null || TinkerResourceLoader.resPatchInfo.resArscMd5 == null) {
            return true;
        }
        String resourceString = directory + "/" + RESOURCE_PATH + "/" + RESOURCE_FILE;
        File resourceFile = new File(resourceString);
        long start = System.currentTimeMillis();
        if (application.isTinkerLoadVerifyFlag()) {
            if (!SharePatchFileUtil.checkResourceArscMd5(resourceFile, TinkerResourceLoader.resPatchInfo.resArscMd5)) {
                Log.e((String)TAG, (String)("Failed to load resource file, path: " + resourceFile.getPath() + ", expect md5: " + TinkerResourceLoader.resPatchInfo.resArscMd5));
                ShareIntentUtil.setIntentReturnCode(intentResult, -24);
                return false;
            }
            Log.i((String)TAG, (String)("verify resource file:" + resourceFile.getPath() + " md5, use time: " + (System.currentTimeMillis() - start)));
        }
        try {
            TinkerResourcePatcher.monkeyPatchExistingResources((Context)application, resourceString);
            Log.i((String)TAG, (String)("monkeyPatchExistingResources resource file:" + resourceString + ", use time: " + (System.currentTimeMillis() - start)));
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"install resources failed");
            try {
                SystemClassLoaderAdder.uninstallPatchDex(application.getClassLoader());
            }
            catch (Throwable throwable) {
                Log.e((String)TAG, (String)"uninstallPatchDex failed", (Throwable)e);
            }
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -23);
            return false;
        }
        ResourceStateMonitor.tryStart(application);
        return true;
    }

    public static boolean checkComplete(Context context, String directory, ShareSecurityCheck securityCheck, Intent intentResult) {
        String meta = securityCheck.getMetaContentMap().get(RESOURCE_META_FILE);
        if (meta == null) {
            return true;
        }
        ShareResPatchInfo.parseResPatchInfoFirstLine(meta, resPatchInfo);
        if (TinkerResourceLoader.resPatchInfo.resArscMd5 == null) {
            return true;
        }
        if (!ShareResPatchInfo.checkResPatchInfo(resPatchInfo)) {
            intentResult.putExtra("intent_patch_package_patch_check", -8);
            ShareIntentUtil.setIntentReturnCode(intentResult, -8);
            return false;
        }
        String resourcePath = directory + "/" + RESOURCE_PATH + "/";
        File resourceDir = new File(resourcePath);
        if (!resourceDir.exists() || !resourceDir.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -21);
            return false;
        }
        File resourceFile = new File(resourcePath + RESOURCE_FILE);
        if (!SharePatchFileUtil.isLegalFile(resourceFile)) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -22);
            return false;
        }
        try {
            TinkerResourcePatcher.isResourceCanPatch(context);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"resource hook check failed.", (Throwable)e);
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -23);
            return false;
        }
        return true;
    }

    private static class ResourceStateMonitor {
        private static boolean started = false;

        private ResourceStateMonitor() {
        }

        static void tryStart(Application app) {
            if (Build.VERSION.SDK_INT < 26 || started) {
                return;
            }
            try {
                ResourceStateMonitor.interceptHandler(ResourceStateMonitor.fetchMHObject((Context)app));
                started = true;
            }
            catch (Throwable e) {
                Log.e((String)TinkerResourceLoader.TAG, (String)"ResourceStateMonitor start failed, simply ignore.", (Throwable)e);
            }
        }

        private static Handler fetchMHObject(Context context) throws Exception {
            Object activityThread = ShareReflectUtil.getActivityThread(context, null);
            Field mHField = ShareReflectUtil.findField(activityThread, "mH");
            return (Handler)mHField.get(activityThread);
        }

        private static void interceptHandler(Handler mH) throws Exception {
            Field mCallbackField = ShareReflectUtil.findField(Handler.class, "mCallback");
            Handler.Callback originCallback = (Handler.Callback)mCallbackField.get(mH);
            HackerCallback hackerCallback = new HackerCallback(originCallback, mH.getClass());
            mCallbackField.set(mH, hackerCallback);
        }

        private static class HackerCallback
        implements Handler.Callback {
            private final int APPLICATION_INFO_CHANGED;
            private Handler.Callback origin;

            HackerCallback(Handler.Callback ori, Class $H) {
                int appInfoChanged;
                this.origin = ori;
                try {
                    appInfoChanged = ShareReflectUtil.findField($H, "APPLICATION_INFO_CHANGED").getInt(null);
                }
                catch (Throwable e) {
                    appInfoChanged = 156;
                }
                this.APPLICATION_INFO_CHANGED = appInfoChanged;
            }

            public boolean handleMessage(Message msg) {
                boolean consume = false;
                if (this.hackMessage(msg)) {
                    consume = true;
                } else if (this.origin != null) {
                    consume = this.origin.handleMessage(msg);
                }
                return consume;
            }

            private boolean hackMessage(Message msg) {
                if (msg.what == this.APPLICATION_INFO_CHANGED) {
                    Process.killProcess((int)Process.myPid());
                    return true;
                }
                return false;
            }
        }
    }
}

