/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.support.annotation.Keep;
import dalvik.system.PathClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;

@Keep
public class TinkerDelegateLastClassLoader
extends PathClassLoader {
    public TinkerDelegateLastClassLoader(String dexPath, String librarySearchPath, ClassLoader parent) {
        super(dexPath, librarySearchPath, parent);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class cl = this.findLoadedClass(name);
        if (cl != null) {
            return cl;
        }
        try {
            return Object.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassNotFoundException fromSuper = null;
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                fromSuper = ex;
                try {
                    return this.getParent().loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    throw fromSuper;
                }
            }
        }
    }

    public URL getResource(String name) {
        URL resource = Object.class.getClassLoader().getResource(name);
        if (resource != null) {
            return resource;
        }
        resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        ClassLoader cl = this.getParent();
        return cl == null ? null : cl.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[]{Object.class.getClassLoader().getResources(name), this.findResources(name), this.getParent() == null ? null : this.getParent().getResources(name)};
        return new CompoundEnumeration<URL>(resources);
    }

    @Keep
    class CompoundEnumeration<E>
    implements Enumeration<E> {
        private Enumeration<E>[] enums;
        private int index = 0;

        public CompoundEnumeration(Enumeration<E>[] enums) {
            this.enums = enums;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public E nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

