/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import com.tencent.tinker.loader.app.TinkerApplication;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

final class NewClassLoaderInjector {
    public static ClassLoader inject(Application app, ClassLoader oldClassLoader) throws Throwable {
        DispatchClassLoader dispatchClassLoader = new DispatchClassLoader(app.getClass().getName(), oldClassLoader);
        ClassLoader newClassLoader = NewClassLoaderInjector.createNewClassLoader((Context)app, oldClassLoader, dispatchClassLoader, new String[0]);
        dispatchClassLoader.setNewClassLoader(newClassLoader);
        NewClassLoaderInjector.doInject(app, newClassLoader);
        return newClassLoader;
    }

    public static void triggerDex2Oat(Context context, String dexPath) throws Throwable {
        ClassLoader appClassLoader = TinkerApplication.class.getClassLoader();
        ClassLoader triggerClassLoader = NewClassLoaderInjector.createNewClassLoader(context, appClassLoader, null, dexPath);
    }

    private static ClassLoader createNewClassLoader(Context context, ClassLoader oldClassLoader, ClassLoader dispatchClassLoader, String ... patchDexPaths) throws Throwable {
        boolean hasPatchDexPaths;
        Field pathListField = NewClassLoaderInjector.findField(BaseDexClassLoader.class, "pathList");
        Object oldPathList = pathListField.get(oldClassLoader);
        Field dexElementsField = NewClassLoaderInjector.findField(oldPathList.getClass(), "dexElements");
        Object[] oldDexElements = (Object[])dexElementsField.get(oldPathList);
        Field dexFileField = NewClassLoaderInjector.findField(oldDexElements.getClass().getComponentType(), "dexFile");
        StringBuilder dexPathBuilder = new StringBuilder();
        boolean bl = hasPatchDexPaths = patchDexPaths != null && patchDexPaths.length > 0;
        if (hasPatchDexPaths) {
            for (int i = 0; i < patchDexPaths.length; ++i) {
                if (i > 0) {
                    dexPathBuilder.append(File.pathSeparator);
                }
                dexPathBuilder.append(patchDexPaths[i]);
            }
        }
        String packageName = context.getPackageName();
        boolean isFirstItem = dexPathBuilder.length() == 0;
        for (Object oldDexElement : oldDexElements) {
            Object dexPath = null;
            DexFile dexFile = (DexFile)dexFileField.get(oldDexElement);
            if (dexFile != null) {
                dexPath = dexFile.getName();
            }
            if (dexPath == null || ((String)dexPath).isEmpty() || !((String)dexPath).contains("/" + packageName)) continue;
            if (isFirstItem) {
                isFirstItem = false;
            } else {
                dexPathBuilder.append(File.pathSeparator);
            }
            dexPathBuilder.append((String)dexPath);
        }
        String combinedDexPath = dexPathBuilder.toString();
        Field nativeLibraryDirectoriesField = NewClassLoaderInjector.findField(oldPathList.getClass(), "nativeLibraryDirectories");
        List<File> oldNativeLibraryDirectories = null;
        oldNativeLibraryDirectories = nativeLibraryDirectoriesField.getType().isArray() ? Arrays.asList((File[])nativeLibraryDirectoriesField.get(oldPathList)) : (List<File>)nativeLibraryDirectoriesField.get(oldPathList);
        StringBuilder libraryPathBuilder = new StringBuilder();
        isFirstItem = true;
        for (File libDir : oldNativeLibraryDirectories) {
            if (libDir == null) continue;
            if (isFirstItem) {
                isFirstItem = false;
            } else {
                libraryPathBuilder.append(File.pathSeparator);
            }
            libraryPathBuilder.append(libDir.getAbsolutePath());
        }
        String combinedLibraryPath = libraryPathBuilder.toString();
        PathClassLoader result = new PathClassLoader(combinedDexPath, combinedLibraryPath, oldClassLoader.getParent());
        if (!hasPatchDexPaths) {
            NewClassLoaderInjector.findField(oldPathList.getClass(), "definingContext").set(oldPathList, result);
            NewClassLoaderInjector.findField(ClassLoader.class, "parent").set(result, dispatchClassLoader);
        }
        return result;
    }

    private static void doInject(Application app, ClassLoader classLoader) throws Throwable {
        Thread.currentThread().setContextClassLoader(classLoader);
        Context baseContext = (Context)NewClassLoaderInjector.findField(app.getClass(), "mBase").get(app);
        Object basePackageInfo = NewClassLoaderInjector.findField(baseContext.getClass(), "mPackageInfo").get(baseContext);
        NewClassLoaderInjector.findField(basePackageInfo.getClass(), "mClassLoader").set(basePackageInfo, classLoader);
        if (Build.VERSION.SDK_INT < 27) {
            Resources res = app.getResources();
            try {
                NewClassLoaderInjector.findField(res.getClass(), "mClassLoader").set(res, classLoader);
                Object drawableInflater = NewClassLoaderInjector.findField(res.getClass(), "mDrawableInflater").get(res);
                if (drawableInflater != null) {
                    NewClassLoaderInjector.findField(drawableInflater.getClass(), "mClassLoader").set(drawableInflater, classLoader);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Field findField(Class<?> clazz, String name) throws Throwable {
        Class<?> currClazz = clazz;
        while (true) {
            try {
                Field result = currClazz.getDeclaredField(name);
                result.setAccessible(true);
                return result;
            }
            catch (Throwable ignored) {
                if (currClazz == Object.class) {
                    throw new NoSuchFieldException("Cannot find field " + name + " in class " + clazz.getName() + " and its super classes.");
                }
                currClazz = currClazz.getSuperclass();
                continue;
            }
            break;
        }
    }

    private NewClassLoaderInjector() {
        throw new UnsupportedOperationException();
    }

    private static final class DispatchClassLoader
    extends ClassLoader {
        private final String mApplicationClassName;
        private final ClassLoader mOldClassLoader;
        private ClassLoader mNewClassLoader;
        private final ThreadLocal<Boolean> mCallFindClassOfLeafDirectly = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };

        DispatchClassLoader(String applicationClassName, ClassLoader oldClassLoader) {
            super(ClassLoader.getSystemClassLoader());
            this.mApplicationClassName = applicationClassName;
            this.mOldClassLoader = oldClassLoader;
        }

        void setNewClassLoader(ClassLoader classLoader) {
            this.mNewClassLoader = classLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (this.mCallFindClassOfLeafDirectly.get().booleanValue()) {
                return null;
            }
            if (name.equals(this.mApplicationClassName)) {
                return this.findClass(this.mOldClassLoader, name);
            }
            if (name.startsWith("com.tencent.tinker.loader.") && !name.equals("com.tencent.tinker.loader.TinkerTestDexLoad")) {
                return this.findClass(this.mOldClassLoader, name);
            }
            if (name.startsWith("org.apache.commons.codec.") || name.startsWith("org.apache.commons.logging.") || name.startsWith("org.apache.http.")) {
                return this.findClass(this.mOldClassLoader, name);
            }
            try {
                return this.findClass(this.mNewClassLoader, name);
            }
            catch (ClassNotFoundException ignored) {
                return this.findClass(this.mOldClassLoader, name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> findClass(ClassLoader classLoader, String name) throws ClassNotFoundException {
            try {
                this.mCallFindClassOfLeafDirectly.set(true);
                Class<?> clazz = classLoader.loadClass(name);
                return clazz;
            }
            finally {
                this.mCallFindClassOfLeafDirectly.set(false);
            }
        }
    }
}

