/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.os.Build;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareFileLockHelper;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SharePatchInfo {
    private static final String TAG = "Tinker.PatchInfo";
    public static final int MAX_EXTRACT_ATTEMPTS = 2;
    public static final String OLD_VERSION = "old";
    public static final String NEW_VERSION = "new";
    public static final String IS_PROTECTED_APP = "is_protected_app";
    public static final String IS_REMOVE_NEW_VERSION = "is_remove_new_version";
    public static final String FINGER_PRINT = "print";
    public static final String OAT_DIR = "dir";
    public static final String DEFAULT_DIR = "odex";
    public String oldVersion;
    public String newVersion;
    public boolean isProtectedApp;
    public boolean isRemoveNewVersion;
    public String fingerPrint;
    public String oatDir;

    public SharePatchInfo(String oldVer, String newVer, boolean isProtectedApp, boolean isRemoveNewVersion, String finger, String oatDir) {
        this.oldVersion = oldVer;
        this.newVersion = newVer;
        this.isProtectedApp = isProtectedApp;
        this.isRemoveNewVersion = isRemoveNewVersion;
        this.fingerPrint = finger;
        this.oatDir = oatDir;
    }

    public static SharePatchInfo readAndCheckPropertyWithLock(File pathInfoFile, File lockFile) {
        SharePatchInfo patchInfo;
        if (pathInfoFile == null || lockFile == null) {
            return null;
        }
        File lockParentFile = lockFile.getParentFile();
        if (!lockParentFile.exists()) {
            lockParentFile.mkdirs();
        }
        ShareFileLockHelper fileLock = null;
        try {
            fileLock = ShareFileLockHelper.getFileLock(lockFile);
            patchInfo = SharePatchInfo.readAndCheckProperty(pathInfoFile);
        }
        catch (Exception e) {
            throw new TinkerRuntimeException("readAndCheckPropertyWithLock fail", e);
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.close();
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"releaseInfoLock error", (Throwable)e);
            }
        }
        return patchInfo;
    }

    public static boolean rewritePatchInfoFileWithLock(File pathInfoFile, SharePatchInfo info, File lockFile) {
        boolean rewriteSuccess;
        if (pathInfoFile == null || info == null || lockFile == null) {
            return false;
        }
        File lockParentFile = lockFile.getParentFile();
        if (!lockParentFile.exists()) {
            lockParentFile.mkdirs();
        }
        ShareFileLockHelper fileLock = null;
        try {
            fileLock = ShareFileLockHelper.getFileLock(lockFile);
            rewriteSuccess = SharePatchInfo.rewritePatchInfoFile(pathInfoFile, info);
        }
        catch (Exception e) {
            throw new TinkerRuntimeException("rewritePatchInfoFileWithLock fail", e);
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.close();
                }
            }
            catch (IOException e) {
                Log.i((String)TAG, (String)"releaseInfoLock error", (Throwable)e);
            }
        }
        return rewriteSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SharePatchInfo readAndCheckProperty(File pathInfoFile) {
        boolean isReadPatchSuccessful = false;
        int numAttempts = 0;
        String oldVer = null;
        String newVer = null;
        String lastFingerPrint = null;
        boolean isProtectedApp = false;
        boolean isRemoveNewVersion = false;
        String oatDir = null;
        while (numAttempts < 2 && !isReadPatchSuccessful) {
            ++numAttempts;
            Properties properties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(pathInfoFile);
                properties.load(inputStream);
                oldVer = properties.getProperty(OLD_VERSION);
                newVer = properties.getProperty(NEW_VERSION);
                String isProtectedAppStr = properties.getProperty(IS_PROTECTED_APP);
                isProtectedApp = isProtectedAppStr != null && !isProtectedAppStr.isEmpty() && !"0".equals(isProtectedAppStr);
                String isRemoveNewVersionStr = properties.getProperty(IS_REMOVE_NEW_VERSION);
                isRemoveNewVersion = isRemoveNewVersionStr != null && !isRemoveNewVersionStr.isEmpty() && !"0".equals(isRemoveNewVersionStr);
                lastFingerPrint = properties.getProperty(FINGER_PRINT);
                oatDir = properties.getProperty(OAT_DIR);
            }
            catch (IOException e) {
                try {
                    Log.w((String)TAG, (String)("read property failed, e:" + e));
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(inputStream);
            }
            SharePatchFileUtil.closeQuietly(inputStream);
            if (oldVer == null || newVer == null) continue;
            if (!oldVer.equals("") && !SharePatchFileUtil.checkIfMd5Valid(oldVer) || !SharePatchFileUtil.checkIfMd5Valid(newVer)) {
                Log.w((String)TAG, (String)("path info file  corrupted:" + pathInfoFile.getAbsolutePath()));
                continue;
            }
            isReadPatchSuccessful = true;
        }
        if (isReadPatchSuccessful) {
            return new SharePatchInfo(oldVer, newVer, isProtectedApp, isRemoveNewVersion, lastFingerPrint, oatDir);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean rewritePatchInfoFile(File pathInfoFile, SharePatchInfo info) {
        if (pathInfoFile == null || info == null) {
            return false;
        }
        if (ShareTinkerInternals.isNullOrNil(info.fingerPrint)) {
            info.fingerPrint = Build.FINGERPRINT;
        }
        if (ShareTinkerInternals.isNullOrNil(info.oatDir)) {
            info.oatDir = DEFAULT_DIR;
        }
        Log.i((String)TAG, (String)("rewritePatchInfoFile file path:" + pathInfoFile.getAbsolutePath() + " , oldVer:" + info.oldVersion + ", newVer:" + info.newVersion + ", isProtectedApp:" + (info.isProtectedApp ? 1 : 0) + ", isRemoveNewVersion:" + (info.isRemoveNewVersion ? 1 : 0) + ", fingerprint:" + info.fingerPrint + ", oatDir:" + info.oatDir));
        boolean isWritePatchSuccessful = false;
        int numAttempts = 0;
        File parentFile = pathInfoFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        while (numAttempts < 2 && !isWritePatchSuccessful) {
            SharePatchInfo tempInfo;
            ++numAttempts;
            Properties newProperties = new Properties();
            newProperties.put(OLD_VERSION, info.oldVersion);
            newProperties.put(NEW_VERSION, info.newVersion);
            newProperties.put(IS_PROTECTED_APP, info.isProtectedApp ? "1" : "0");
            newProperties.put(IS_REMOVE_NEW_VERSION, info.isRemoveNewVersion ? "1" : "0");
            newProperties.put(FINGER_PRINT, info.fingerPrint);
            newProperties.put(OAT_DIR, info.oatDir);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(pathInfoFile, false);
                String comment = "from old version:" + info.oldVersion + " to new version:" + info.newVersion;
                newProperties.store(outputStream, comment);
            }
            catch (Exception e) {
                try {
                    Log.w((String)TAG, (String)("write property failed, e:" + e));
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(outputStream);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(outputStream);
            }
            SharePatchFileUtil.closeQuietly(outputStream);
            if (isWritePatchSuccessful = (tempInfo = SharePatchInfo.readAndCheckProperty(pathInfoFile)) != null && tempInfo.oldVersion.equals(info.oldVersion) && tempInfo.newVersion.equals(info.newVersion)) continue;
            pathInfoFile.delete();
        }
        return isWritePatchSuccessful;
    }
}

