/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.app;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import com.tencent.tinker.loader.TinkerLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerUncaughtHandler;
import com.tencent.tinker.loader.hotplug.ComponentHotplug;
import com.tencent.tinker.loader.hotplug.UnsupportedEnvironmentException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class TinkerApplication
extends Application {
    private static final int TINKER_DISABLE = 0;
    private static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    private static final String TINKER_LOADER_METHOD = "tryLoad";
    private final int tinkerFlags;
    private final boolean tinkerLoadVerifyFlag;
    private final String delegateClassName;
    private final String loaderClassName;
    private boolean useSafeMode;
    private Intent tinkerResultIntent;
    private Object applicationLike = null;
    private long applicationStartElapsedTime;
    private long applicationStartMillisTime;
    private Method appLikeOnBaseContextAttached = null;
    private Method appLikeOnCreate = null;
    private Method appLikeOnTerminate = null;
    private Method appLikeOnLowMemory = null;
    private Method appLikeOnTrimMemory = null;
    private Method appLikeOnConfigurationChanged = null;
    private Method appLikeGetResources = null;
    private Method appLikeGetClassLoader = null;
    private Method appLikeGetAssets = null;
    private Method appLikeGetSystemService = null;
    private Method appLikeGetBaseContext = null;

    protected TinkerApplication(int tinkerFlags) {
        this(tinkerFlags, "com.tencent.tinker.entry.DefaultApplicationLike", TinkerLoader.class.getName(), false);
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName, String loaderClassName, boolean tinkerLoadVerifyFlag) {
        this.tinkerFlags = tinkerFlags;
        this.delegateClassName = delegateClassName;
        this.loaderClassName = loaderClassName;
        this.tinkerLoadVerifyFlag = tinkerLoadVerifyFlag;
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName) {
        this(tinkerFlags, delegateClassName, TinkerLoader.class.getName(), false);
    }

    private Object createDelegate() {
        try {
            Class<?> delegateClass = Class.forName(this.delegateClassName, false, this.getClassLoader());
            Constructor<?> constructor = delegateClass.getConstructor(Application.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Intent.class);
            return constructor.newInstance(new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag, this.applicationStartElapsedTime, this.applicationStartMillisTime, this.tinkerResultIntent});
        }
        catch (Throwable e) {
            throw new TinkerRuntimeException("createDelegate failed", e);
        }
    }

    private synchronized void ensureDelegate() {
        if (this.applicationLike == null) {
            this.applicationLike = this.createDelegate();
        }
    }

    private void invokeAppLikeOnBaseContextAttached(Object appLike, Context base) throws TinkerRuntimeException {
        try {
            if (this.appLikeOnBaseContextAttached == null) {
                this.appLikeOnBaseContextAttached = ShareReflectUtil.findMethod(this.applicationLike, "onBaseContextAttached", Context.class);
            }
            this.appLikeOnBaseContextAttached.invoke(appLike, base);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke onBaseContextAttached of appLike.", thr);
        }
    }

    private void onBaseContextAttached(Context base) {
        try {
            this.applicationStartElapsedTime = SystemClock.elapsedRealtime();
            this.applicationStartMillisTime = System.currentTimeMillis();
            this.loadTinker();
            this.ensureDelegate();
            this.invokeAppLikeOnBaseContextAttached(this.applicationLike, base);
            if (this.useSafeMode) {
                ShareTinkerInternals.setSafeModeCount((Context)this, 0);
            }
        }
        catch (TinkerRuntimeException e) {
            throw e;
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException(thr.getMessage(), thr);
        }
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        Thread.setDefaultUncaughtExceptionHandler(new TinkerUncaughtHandler((Context)this));
        this.onBaseContextAttached(base);
    }

    private void loadTinker() {
        try {
            Class<?> tinkerLoadClass = Class.forName(this.loaderClassName, false, this.getClassLoader());
            Method loadMethod = tinkerLoadClass.getMethod(TINKER_LOADER_METHOD, TinkerApplication.class);
            Constructor<?> constructor = tinkerLoadClass.getConstructor(new Class[0]);
            this.tinkerResultIntent = (Intent)loadMethod.invoke(constructor.newInstance(new Object[0]), new Object[]{this});
        }
        catch (Throwable e) {
            this.tinkerResultIntent = new Intent();
            ShareIntentUtil.setIntentReturnCode(this.tinkerResultIntent, -20);
            this.tinkerResultIntent.putExtra(INTENT_PATCH_EXCEPTION, (Serializable)e);
        }
    }

    private void invokeAppLikeOnCreate(Object appLike) throws TinkerRuntimeException {
        try {
            if (this.appLikeOnCreate == null) {
                this.appLikeOnCreate = ShareReflectUtil.findMethod(this.applicationLike, "onCreate", new Class[0]);
            }
            this.appLikeOnCreate.invoke(appLike, new Object[0]);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke onCreate of appLike.", thr);
        }
    }

    public void onCreate() {
        super.onCreate();
        try {
            this.ensureDelegate();
            try {
                ComponentHotplug.ensureComponentHotplugInstalled(this);
            }
            catch (UnsupportedEnvironmentException e) {
                throw new TinkerRuntimeException("failed to make sure that ComponentHotplug logic is fine.", e);
            }
            this.invokeAppLikeOnCreate(this.applicationLike);
        }
        catch (TinkerRuntimeException e) {
            throw e;
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException(thr.getMessage(), thr);
        }
    }

    private void invokeAppLikeOnTerminate(Object appLike) throws TinkerRuntimeException {
        try {
            if (this.appLikeOnTerminate == null) {
                this.appLikeOnTerminate = ShareReflectUtil.findMethod(this.applicationLike, "onTerminate", new Class[0]);
            }
            this.appLikeOnTerminate.invoke(appLike, new Object[0]);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke onTerminate of appLike.", thr);
        }
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.applicationLike != null) {
            this.invokeAppLikeOnTerminate(this.applicationLike);
        }
    }

    private void invokeAppLikeOnLowMemory(Object appLike) throws TinkerRuntimeException {
        try {
            if (this.appLikeOnLowMemory == null) {
                this.appLikeOnLowMemory = ShareReflectUtil.findMethod(this.applicationLike, "onLowMemory", new Class[0]);
            }
            this.appLikeOnLowMemory.invoke(appLike, new Object[0]);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke onLowMemory of appLike.", thr);
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.applicationLike != null) {
            this.invokeAppLikeOnLowMemory(this.applicationLike);
        }
    }

    private void invokeAppLikeOnTrimMemory(Object appLike, int level) throws TinkerRuntimeException {
        try {
            if (this.appLikeOnTrimMemory == null) {
                this.appLikeOnTrimMemory = ShareReflectUtil.findMethod(this.applicationLike, "onTrimMemory", Integer.TYPE);
            }
            this.appLikeOnTrimMemory.invoke(appLike, level);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke onTrimMemory of appLike.", thr);
        }
    }

    @TargetApi(value=14)
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.applicationLike != null) {
            this.invokeAppLikeOnTrimMemory(this.applicationLike, level);
        }
    }

    private void invokeAppLikeOnConfigurationChanged(Object appLike, Configuration newConfig) throws TinkerRuntimeException {
        try {
            if (this.appLikeOnConfigurationChanged == null) {
                this.appLikeOnConfigurationChanged = ShareReflectUtil.findMethod(this.applicationLike, "onConfigurationChanged", Configuration.class);
            }
            this.appLikeOnConfigurationChanged.invoke(appLike, newConfig);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke onConfigurationChanged of appLike.", thr);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.applicationLike != null) {
            this.invokeAppLikeOnConfigurationChanged(this.applicationLike, newConfig);
        }
    }

    private Resources invokeAppLikeGetResources(Object appLike, Resources resources) throws TinkerRuntimeException {
        try {
            if (this.appLikeGetResources == null) {
                this.appLikeGetResources = ShareReflectUtil.findMethod(this.applicationLike, "getResources", Resources.class);
            }
            return (Resources)this.appLikeGetResources.invoke(appLike, resources);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke getResources of appLike.", thr);
        }
    }

    public Resources getResources() {
        Resources resources = super.getResources();
        if (this.applicationLike != null) {
            return this.invokeAppLikeGetResources(this.applicationLike, resources);
        }
        return resources;
    }

    private ClassLoader invokeAppLikeGetClassLoader(Object appLike, ClassLoader classLoader) throws TinkerRuntimeException {
        try {
            if (this.appLikeGetClassLoader == null) {
                this.appLikeGetClassLoader = ShareReflectUtil.findMethod(this.applicationLike, "getClassLoader", ClassLoader.class);
            }
            return (ClassLoader)this.appLikeGetClassLoader.invoke(appLike, classLoader);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke getClassLoader of appLike.", thr);
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = super.getClassLoader();
        if (this.applicationLike != null) {
            return this.invokeAppLikeGetClassLoader(this.applicationLike, classLoader);
        }
        return classLoader;
    }

    private AssetManager invokeAppLikeGetAssets(Object appLike, AssetManager assetManager) throws TinkerRuntimeException {
        try {
            if (this.appLikeGetAssets == null) {
                this.appLikeGetAssets = ShareReflectUtil.findMethod(this.applicationLike, "getAssets", AssetManager.class);
            }
            return (AssetManager)this.appLikeGetAssets.invoke(appLike, assetManager);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke getAssets of appLike.", thr);
        }
    }

    public AssetManager getAssets() {
        AssetManager assetManager = super.getAssets();
        if (this.applicationLike != null) {
            return this.invokeAppLikeGetAssets(this.applicationLike, assetManager);
        }
        return assetManager;
    }

    private Object invokeAppLikeGetSystemService(Object appLike, String name, Object service) throws TinkerRuntimeException {
        try {
            if (this.appLikeGetSystemService == null) {
                this.appLikeGetSystemService = ShareReflectUtil.findMethod(this.applicationLike, "getSystemService", String.class, Object.class);
            }
            return this.appLikeGetSystemService.invoke(appLike, name, service);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke getSystemService of appLike.", thr);
        }
    }

    public Object getSystemService(String name) {
        Object service = super.getSystemService(name);
        if (this.applicationLike != null) {
            return this.invokeAppLikeGetSystemService(this.applicationLike, name, service);
        }
        return service;
    }

    private Object invokeAppLikeGetBaseContext(Object appLike, Context base) throws TinkerRuntimeException {
        try {
            if (this.appLikeGetBaseContext == null) {
                this.appLikeGetBaseContext = ShareReflectUtil.findMethod(this.applicationLike, "getBaseContext", Context.class);
            }
            return this.appLikeGetBaseContext.invoke(appLike, base);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to invoke getBaseContext of appLike.", thr);
        }
    }

    public Context getBaseContext() {
        Context base = super.getBaseContext();
        if (this.applicationLike != null) {
            return (Context)this.invokeAppLikeGetBaseContext(this.applicationLike, base);
        }
        return base;
    }

    public void setUseSafeMode(boolean useSafeMode) {
        this.useSafeMode = useSafeMode;
    }

    public boolean isTinkerLoadVerifyFlag() {
        return this.tinkerLoadVerifyFlag;
    }

    public int getTinkerFlags() {
        return this.tinkerFlags;
    }
}

