/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import com.tencent.tinker.loader.AbstractTinkerLoader;
import com.tencent.tinker.loader.TinkerDexLoader;
import com.tencent.tinker.loader.TinkerResourceLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerSoLoader;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.hotplug.ComponentHotplug;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.Serializable;

public class TinkerLoader
extends AbstractTinkerLoader {
    private static final String TAG = "Tinker.TinkerLoader";
    private SharePatchInfo patchInfo;

    @Override
    public Intent tryLoad(TinkerApplication app) {
        Intent resultIntent = new Intent();
        long begin = SystemClock.elapsedRealtime();
        this.tryLoadPatchFilesInternal(app, resultIntent);
        long cost = SystemClock.elapsedRealtime() - begin;
        ShareIntentUtil.setIntentPatchCostTime(resultIntent, cost);
        return resultIntent;
    }

    private void tryLoadPatchFilesInternal(TinkerApplication app, Intent resultIntent) {
        boolean loadTinkerResources;
        boolean resourceCheck;
        boolean libCheck;
        boolean dexCheck;
        File patchVersionFile;
        int tinkerFlag = app.getTinkerFlags();
        if (!ShareTinkerInternals.isTinkerEnabled(tinkerFlag)) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles: tinker is disable, just return");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -1);
            return;
        }
        if (ShareTinkerInternals.isInPatchProcess((Context)app)) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles: we don't load patch with :patch process itself, just return");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -1);
            return;
        }
        File patchDirectoryFile = SharePatchFileUtil.getPatchDirectory((Context)app);
        if (patchDirectoryFile == null) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:getPatchDirectory == null");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -2);
            return;
        }
        String patchDirectoryPath = patchDirectoryFile.getAbsolutePath();
        if (!patchDirectoryFile.exists()) {
            Log.w((String)TAG, (String)("tryLoadPatchFiles:patch dir not exist:" + patchDirectoryPath));
            ShareIntentUtil.setIntentReturnCode(resultIntent, -2);
            return;
        }
        File patchInfoFile = SharePatchFileUtil.getPatchInfoFile(patchDirectoryPath);
        if (!patchInfoFile.exists()) {
            Log.w((String)TAG, (String)("tryLoadPatchFiles:patch info not exist:" + patchInfoFile.getAbsolutePath()));
            ShareIntentUtil.setIntentReturnCode(resultIntent, -3);
            return;
        }
        File patchInfoLockFile = SharePatchFileUtil.getPatchInfoLockFile(patchDirectoryPath);
        this.patchInfo = SharePatchInfo.readAndCheckPropertyWithLock(patchInfoFile, patchInfoLockFile);
        if (this.patchInfo == null) {
            ShareIntentUtil.setIntentReturnCode(resultIntent, -4);
            return;
        }
        String oldVersion = this.patchInfo.oldVersion;
        String newVersion = this.patchInfo.newVersion;
        String oatDex = this.patchInfo.oatDir;
        if (oldVersion == null || newVersion == null || oatDex == null) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchInfoCorrupted");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -4);
            return;
        }
        boolean mainProcess = ShareTinkerInternals.isInMainProcess((Context)app);
        boolean isRemoveNewVersion = this.patchInfo.isRemoveNewVersion;
        if (mainProcess && isRemoveNewVersion) {
            Log.w((String)TAG, (String)"found clean patch mark and we are in main process, delete patch file now.");
            String patchName = SharePatchFileUtil.getPatchVersionDirectory(newVersion);
            if (patchName != null) {
                String patchVersionDirFullPath = patchDirectoryPath + "/" + patchName;
                SharePatchFileUtil.deleteDir(patchVersionDirFullPath);
                if (oldVersion.equals(newVersion)) {
                    oldVersion = "";
                }
                newVersion = oldVersion;
                this.patchInfo.oldVersion = oldVersion;
                this.patchInfo.newVersion = newVersion;
                SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile);
                ShareTinkerInternals.killProcessExceptMain((Context)app);
            }
        }
        resultIntent.putExtra("intent_patch_old_version", oldVersion);
        resultIntent.putExtra("intent_patch_new_version", newVersion);
        boolean versionChanged = !oldVersion.equals(newVersion);
        boolean oatModeChanged = oatDex.equals("changing");
        oatDex = ShareTinkerInternals.getCurrentOatMode((Context)app, oatDex);
        resultIntent.putExtra("intent_patch_oat_dir", oatDex);
        String version = oldVersion;
        if (versionChanged && mainProcess) {
            version = newVersion;
        }
        if (ShareTinkerInternals.isNullOrNil(version)) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:version is blank, wait main process to restart");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -5);
            return;
        }
        String patchName = SharePatchFileUtil.getPatchVersionDirectory(version);
        if (patchName == null) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:patchName is null");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -6);
            return;
        }
        String patchVersionDirectory = patchDirectoryPath + "/" + patchName;
        File patchVersionDirectoryFile = new File(patchVersionDirectory);
        if (!patchVersionDirectoryFile.exists()) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchVersionDirectoryNotFound");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -6);
            return;
        }
        String patchVersionFileRelPath = SharePatchFileUtil.getPatchVersionFile(version);
        File file = patchVersionFile = patchVersionFileRelPath != null ? new File(patchVersionDirectoryFile.getAbsolutePath(), patchVersionFileRelPath) : null;
        if (!SharePatchFileUtil.isLegalFile(patchVersionFile)) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchVersionFileNotFound");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -7);
            return;
        }
        ShareSecurityCheck securityCheck = new ShareSecurityCheck((Context)app);
        int returnCode = ShareTinkerInternals.checkTinkerPackage((Context)app, tinkerFlag, patchVersionFile, securityCheck);
        if (returnCode != 0) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:checkTinkerPackage");
            resultIntent.putExtra("intent_patch_package_patch_check", returnCode);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -8);
            return;
        }
        resultIntent.putExtra("intent_patch_package_config", securityCheck.getPackagePropertiesIfPresent());
        boolean isEnabledForDex = ShareTinkerInternals.isTinkerEnabledForDex(tinkerFlag);
        if (isEnabledForDex && !(dexCheck = TinkerDexLoader.checkComplete(patchVersionDirectory, securityCheck, oatDex, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:dex check fail");
            return;
        }
        boolean isEnabledForNativeLib = ShareTinkerInternals.isTinkerEnabledForNativeLib(tinkerFlag);
        if (isEnabledForNativeLib && !(libCheck = TinkerSoLoader.checkComplete(patchVersionDirectory, securityCheck, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:native lib check fail");
            return;
        }
        boolean isEnabledForResource = ShareTinkerInternals.isTinkerEnabledForResource(tinkerFlag);
        Log.w((String)TAG, (String)("tryLoadPatchFiles:isEnabledForResource:" + isEnabledForResource));
        if (isEnabledForResource && !(resourceCheck = TinkerResourceLoader.checkComplete((Context)app, patchVersionDirectory, securityCheck, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:resource check fail");
            return;
        }
        boolean isSystemOTA = ShareTinkerInternals.isVmArt() && ShareTinkerInternals.isSystemOTA(this.patchInfo.fingerPrint) && Build.VERSION.SDK_INT >= 21 && !ShareTinkerInternals.isAfterAndroidO();
        resultIntent.putExtra("intent_patch_system_ota", isSystemOTA);
        if (mainProcess && (versionChanged || oatModeChanged)) {
            this.patchInfo.oldVersion = version;
            this.patchInfo.oatDir = oatDex;
            if (!SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile)) {
                ShareIntentUtil.setIntentReturnCode(resultIntent, -19);
                Log.w((String)TAG, (String)"tryLoadPatchFiles:onReWritePatchInfoCorrupted");
                return;
            }
            Log.i((String)TAG, (String)"tryLoadPatchFiles:success to rewrite patch info, kill other process.");
            ShareTinkerInternals.killProcessExceptMain((Context)app);
            if (oatModeChanged) {
                Log.i((String)TAG, (String)"tryLoadPatchFiles:oatModeChanged, try to delete interpret optimize files");
                SharePatchFileUtil.deleteDir(patchVersionDirectory + "/" + "interpet");
            }
        }
        if (!this.checkSafeModeCount(app)) {
            resultIntent.putExtra("intent_patch_exception", (Serializable)new TinkerRuntimeException("checkSafeModeCount fail"));
            ShareIntentUtil.setIntentReturnCode(resultIntent, -25);
            Log.w((String)TAG, (String)"tryLoadPatchFiles:checkSafeModeCount fail");
            return;
        }
        if (isEnabledForDex) {
            boolean loadTinkerJars = TinkerDexLoader.loadTinkerJars(app, patchVersionDirectory, oatDex, resultIntent, isSystemOTA);
            if (isSystemOTA) {
                this.patchInfo.fingerPrint = Build.FINGERPRINT;
                this.patchInfo.oatDir = loadTinkerJars ? "interpet" : "odex";
                oatModeChanged = false;
                if (!SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile)) {
                    ShareIntentUtil.setIntentReturnCode(resultIntent, -19);
                    Log.w((String)TAG, (String)"tryLoadPatchFiles:onReWritePatchInfoCorrupted");
                    return;
                }
                resultIntent.putExtra("intent_patch_oat_dir", this.patchInfo.oatDir);
            }
            if (!loadTinkerJars) {
                Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchLoadDexesFail");
                return;
            }
        }
        if (isEnabledForResource && !(loadTinkerResources = TinkerResourceLoader.loadTinkerResources(app, patchVersionDirectory, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchLoadResourcesFail");
            return;
        }
        if (isEnabledForDex && isEnabledForResource) {
            ComponentHotplug.install(app, securityCheck);
        }
        ShareIntentUtil.setIntentReturnCode(resultIntent, 0);
        Log.i((String)TAG, (String)"tryLoadPatchFiles: load end, ok!");
    }

    private boolean checkSafeModeCount(TinkerApplication application) {
        int count = ShareTinkerInternals.getSafeModeCount((Context)application);
        if (count >= 2) {
            ShareTinkerInternals.setSafeModeCount((Context)application, 0);
            return false;
        }
        application.setUseSafeMode(true);
        ShareTinkerInternals.setSafeModeCount((Context)application, count + 1);
        return true;
    }
}

