/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;

@TargetApi(value=14)
class AndroidNClassLoader
extends PathClassLoader {
    private static final String TAG = "Tinker.NClassLoader";
    private static Object oldDexPathListHolder = null;
    private static String baseApkFullPath = null;
    private final PathClassLoader originClassLoader;
    private String applicationClassName;

    private AndroidNClassLoader(String dexPath, PathClassLoader parent, Application application) {
        super(dexPath, parent.getParent());
        this.originClassLoader = parent;
        String name = application.getClass().getName();
        if (name != null && !name.equals("android.app.Application")) {
            this.applicationClassName = name;
        }
        baseApkFullPath = application.getPackageCodePath();
    }

    private static Object recreateDexPathList(Object originalDexPathList, ClassLoader newDefiningContext, boolean createEmptyOne) throws Exception {
        Constructor<?> dexPathListConstructor = ShareReflectUtil.findConstructor(originalDexPathList, ClassLoader.class, String.class, String.class, File.class);
        if (createEmptyOne) {
            return dexPathListConstructor.newInstance(newDefiningContext, "", null, null);
        }
        Field dexElementsField = ShareReflectUtil.findField(originalDexPathList, "dexElements");
        Object[] dexElements = (Object[])dexElementsField.get(originalDexPathList);
        Field nativeLibraryDirectoriesField = ShareReflectUtil.findField(originalDexPathList, "nativeLibraryDirectories");
        List nativeLibraryDirectories = (List)nativeLibraryDirectoriesField.get(originalDexPathList);
        StringBuilder dexPathBuilder = new StringBuilder();
        Field dexFileField = ShareReflectUtil.findField(dexElements.getClass().getComponentType(), "dexFile");
        boolean isFirstItem = true;
        for (Object dexElement : dexElements) {
            DexFile dexFile = (DexFile)dexFileField.get(dexElement);
            if (dexFile == null || dexFile.getName() == null || !dexFile.getName().equals(baseApkFullPath)) continue;
            if (isFirstItem) {
                isFirstItem = false;
            } else {
                dexPathBuilder.append(File.pathSeparator);
            }
            dexPathBuilder.append(dexFile.getName());
        }
        String dexPath = dexPathBuilder.toString();
        StringBuilder libraryPathBuilder = new StringBuilder();
        isFirstItem = true;
        for (File libDir : nativeLibraryDirectories) {
            if (libDir == null) continue;
            if (isFirstItem) {
                isFirstItem = false;
            } else {
                libraryPathBuilder.append(File.pathSeparator);
            }
            libraryPathBuilder.append(libDir.getAbsolutePath());
        }
        String libraryPath = libraryPathBuilder.toString();
        return dexPathListConstructor.newInstance(newDefiningContext, dexPath, libraryPath, null);
    }

    private static AndroidNClassLoader createAndroidNClassLoader(PathClassLoader originalClassLoader, Application application) throws Exception {
        AndroidNClassLoader androidNClassLoader = new AndroidNClassLoader("", originalClassLoader, application);
        Field pathListField = ShareReflectUtil.findField(originalClassLoader, "pathList");
        Object originPathList = pathListField.get(originalClassLoader);
        Object newPathList = AndroidNClassLoader.recreateDexPathList(originPathList, (ClassLoader)((Object)androidNClassLoader), false);
        pathListField.set((Object)androidNClassLoader, newPathList);
        ShareReflectUtil.findField(originPathList, "definingContext").set(originPathList, (Object)androidNClassLoader);
        oldDexPathListHolder = originPathList;
        return androidNClassLoader;
    }

    private static void reflectPackageInfoClassloader(Application application, ClassLoader reflectClassLoader) throws Exception {
        Context baseContext = (Context)ShareReflectUtil.findField(application, "mBase").get(application);
        Object basePackageInfo = ShareReflectUtil.findField(baseContext, "mPackageInfo").get(baseContext);
        ShareReflectUtil.findField(basePackageInfo, "mClassLoader").set(basePackageInfo, reflectClassLoader);
        if (Build.VERSION.SDK_INT < 27) {
            Resources res = application.getResources();
            ShareReflectUtil.findField(res, "mClassLoader").set(res, reflectClassLoader);
            Object drawableInflater = ShareReflectUtil.findField(res, "mDrawableInflater").get(res);
            if (drawableInflater != null) {
                ShareReflectUtil.findField(drawableInflater, "mClassLoader").set(drawableInflater, reflectClassLoader);
            }
        }
        Thread.currentThread().setContextClassLoader(reflectClassLoader);
    }

    public static AndroidNClassLoader inject(PathClassLoader originClassLoader, Application application) throws Exception {
        AndroidNClassLoader classLoader = AndroidNClassLoader.createAndroidNClassLoader(originClassLoader, application);
        AndroidNClassLoader.reflectPackageInfoClassloader(application, (ClassLoader)((Object)classLoader));
        return classLoader;
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.applicationClassName != null && this.applicationClassName.equals(name)) {
            return this.originClassLoader.loadClass(name);
        }
        if (name != null && name.startsWith("com.tencent.tinker.loader.") && !name.equals("com.tencent.tinker.loader.TinkerTestDexLoad")) {
            return this.originClassLoader.loadClass(name);
        }
        if (name != null && name.startsWith("org.apache.http.")) {
            return this.originClassLoader.loadClass(name);
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.originClassLoader.loadClass(name);
        }
    }

    public String findLibrary(String name) {
        return super.findLibrary(name);
    }
}

