/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import java.util.ArrayList;

public class ShareBsDiffPatchInfo {
    public String name;
    public String md5;
    public String rawCrc;
    public String patchMd5;
    public String path;

    public ShareBsDiffPatchInfo(String name, String md5, String path, String raw, String patch) {
        this.name = name;
        this.md5 = md5;
        this.rawCrc = raw;
        this.patchMd5 = patch;
        this.path = path;
    }

    public static void parseDiffPatchInfo(String meta, ArrayList<ShareBsDiffPatchInfo> diffList) {
        String[] lines;
        if (meta == null || meta.length() == 0) {
            return;
        }
        for (String line : lines = meta.split("\n")) {
            String[] kv;
            if (line == null || line.length() <= 0 || (kv = line.split(",", 5)) == null || kv.length < 5) continue;
            String name = kv[0].trim();
            String path = kv[1].trim();
            String md5 = kv[2].trim();
            String rawCrc = kv[3].trim();
            String patchMd5 = kv[4].trim();
            ShareBsDiffPatchInfo dexInfo = new ShareBsDiffPatchInfo(name, md5, path, rawCrc, patchMd5);
            diffList.add(dexInfo);
        }
    }

    public static boolean checkDiffPatchInfo(ShareBsDiffPatchInfo info) {
        if (info == null) {
            return false;
        }
        String name = info.name;
        String md5 = info.md5;
        return name != null && name.length() > 0 && md5 != null && md5.length() == 32;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(",");
        sb.append(this.path);
        sb.append(",");
        sb.append(this.md5);
        sb.append(",");
        sb.append(this.rawCrc);
        sb.append(",");
        sb.append(this.patchMd5);
        return sb.toString();
    }
}

