/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug.handler;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcelable;
import com.tencent.tinker.loader.hotplug.ActivityStubManager;
import com.tencent.tinker.loader.hotplug.IncrementComponentManager;
import com.tencent.tinker.loader.hotplug.interceptor.ServiceBinderInterceptor;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.reflect.Method;

public class AMSInterceptHandler
implements ServiceBinderInterceptor.BinderInvocationHandler {
    private static final String TAG = "Tinker.AMSIntrcptHndlr";
    private static final int[] TRANSLUCENT_ATTR_ID = new int[]{16842840};
    private static final int INTENT_SENDER_ACTIVITY;
    private final Context mContext;

    public AMSInterceptHandler(Context context) {
        Context baseCtx;
        while (context instanceof ContextWrapper && (baseCtx = ((ContextWrapper)context).getBaseContext()) != null) {
            context = baseCtx;
        }
        this.mContext = context;
    }

    @Override
    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("startActivity".equals(methodName)) {
            return this.handleStartActivity(target, method, args);
        }
        if ("startActivities".equals(methodName)) {
            return this.handleStartActivities(target, method, args);
        }
        if ("startActivityAndWait".equals(methodName)) {
            return this.handleStartActivity(target, method, args);
        }
        if ("startActivityWithConfig".equals(methodName)) {
            return this.handleStartActivity(target, method, args);
        }
        if ("startActivityAsUser".equals(methodName)) {
            return this.handleStartActivity(target, method, args);
        }
        if ("getIntentSender".equals(methodName)) {
            return this.handleGetIntentSender(target, method, args);
        }
        return method.invoke(target, args);
    }

    private Object handleStartActivity(Object target, Method method, Object[] args) throws Throwable {
        int intentIdx = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Intent)) continue;
            intentIdx = i;
            break;
        }
        if (intentIdx != -1) {
            Intent newIntent = new Intent((Intent)args[intentIdx]);
            this.processActivityIntent(newIntent);
            args[intentIdx] = newIntent;
        }
        return method.invoke(target, args);
    }

    private Object handleStartActivities(Object target, Method method, Object[] args) throws Throwable {
        int intentArrIdx = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Intent[])) continue;
            intentArrIdx = i;
            break;
        }
        if (intentArrIdx != -1) {
            Intent[] oldIntentArr = (Intent[])args[intentArrIdx];
            for (int i = 0; i < oldIntentArr.length; ++i) {
                Intent newIntent = new Intent(oldIntentArr[i]);
                this.processActivityIntent(newIntent);
                oldIntentArr[i] = newIntent;
            }
        }
        return method.invoke(target, args);
    }

    private Object handleGetIntentSender(Object target, Method method, Object[] args) throws Throwable {
        int intentType;
        int intentArrIdx = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Intent[])) continue;
            intentArrIdx = i;
            break;
        }
        if (intentArrIdx != -1 && (intentType = ((Integer)args[0]).intValue()) == INTENT_SENDER_ACTIVITY) {
            Intent[] oldIntentArr = (Intent[])args[intentArrIdx];
            for (int i = 0; i < oldIntentArr.length; ++i) {
                Intent newIntent = new Intent(oldIntentArr[i]);
                this.processActivityIntent(newIntent);
                oldIntentArr[i] = newIntent;
            }
        }
        return method.invoke(target, args);
    }

    private void processActivityIntent(Intent intent) {
        String origPackageName = null;
        String origClassName = null;
        if (intent.getComponent() != null) {
            origPackageName = intent.getComponent().getPackageName();
            origClassName = intent.getComponent().getClassName();
        } else {
            ResolveInfo rInfo = this.mContext.getPackageManager().resolveActivity(intent, 0);
            if (rInfo == null) {
                rInfo = IncrementComponentManager.resolveIntent(intent);
            }
            if (rInfo != null && rInfo.filter != null && rInfo.filter.hasCategory("android.intent.category.DEFAULT")) {
                origPackageName = rInfo.activityInfo.packageName;
                origClassName = rInfo.activityInfo.name;
            }
        }
        if (IncrementComponentManager.isIncrementActivity(origClassName)) {
            ActivityInfo origInfo = IncrementComponentManager.queryActivityInfo(origClassName);
            boolean isTransparent = this.hasTransparentTheme(origInfo);
            String stubClassName = ActivityStubManager.assignStub(origClassName, origInfo.launchMode, isTransparent);
            this.storeAndReplaceOriginalComponentName(intent, origPackageName, origClassName, stubClassName);
        }
    }

    private void storeAndReplaceOriginalComponentName(Intent intent, String origPackageName, String origClassName, String stubClassName) {
        ComponentName origComponentName = new ComponentName(origPackageName, origClassName);
        ShareIntentUtil.fixIntentClassLoader(intent, this.mContext.getClassLoader());
        intent.putExtra("tinker_iek_old_component", (Parcelable)origComponentName);
        ComponentName stubComponentName = new ComponentName(origPackageName, stubClassName);
        intent.setComponent(stubComponentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTransparentTheme(ActivityInfo activityInfo) {
        int theme = activityInfo.getThemeResource();
        Resources.Theme themeObj = this.mContext.getResources().newTheme();
        themeObj.applyStyle(theme, true);
        TypedArray ta = null;
        try {
            ta = themeObj.obtainStyledAttributes(TRANSLUCENT_ATTR_ID);
            boolean bl = ta.getBoolean(0, false);
            return bl;
        }
        catch (Throwable thr) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ta != null) {
                ta.recycle();
            }
        }
    }

    static {
        int val = 0;
        try {
            val = (Integer)ShareReflectUtil.findField(ActivityManager.class, "INTENT_SENDER_ACTIVITY").get(null);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            val = 2;
        }
        INTENT_SENDER_ACTIVITY = val;
    }
}

