/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug;

import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class IncrementComponentManager {
    private static final String TAG = "Tinker.IncrementCompMgr";
    private static final int TAG_ACTIVITY = 0;
    private static final int TAG_SERVICE = 1;
    private static final int TAG_PROVIDER = 2;
    private static final int TAG_RECEIVER = 3;
    private static Context sContext = null;
    private static String sPackageName = null;
    private static volatile boolean sInitialized = false;
    private static final Map<String, ActivityInfo> sClassNameToActivityInfoMap = new HashMap<String, ActivityInfo>();
    private static final Map<String, IntentFilter> sClassNameToIntentFilterMap = new HashMap<String, IntentFilter>();
    private static final AttrTranslator<ActivityInfo> sActivityInfoAttrTranslator = new AttrTranslator<ActivityInfo>(){

        @Override
        void onInit(Context context, int tagType, XmlPullParser parser) {
            try {
                if (!(tagType != 0 || parser.getEventType() == 2 && "activity".equals(parser.getName()))) {
                    throw new IllegalStateException("unexpected xml parser state when parsing incremental component manifest.");
                }
            }
            catch (XmlPullParserException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        void onTranslate(Context context, int tagType, String attrName, String attrValue, ActivityInfo result) {
            if ("name".equals(attrName)) {
                result.name = attrValue.charAt(0) == '.' ? context.getPackageName() + attrValue : attrValue;
            } else if ("parentActivityName".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 16) {
                    result.parentActivityName = attrValue.charAt(0) == '.' ? context.getPackageName() + attrValue : attrValue;
                }
            } else if ("exported".equals(attrName)) {
                result.exported = "true".equalsIgnoreCase(attrValue);
            } else if ("launchMode".equals(attrName)) {
                result.launchMode = this.parseLaunchMode(attrValue);
            } else if ("theme".equals(attrName)) {
                Resources res = context.getResources();
                String packageName = context.getPackageName();
                result.theme = res.getIdentifier(attrValue, "style", packageName);
            } else if ("uiOptions".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 14) {
                    result.uiOptions = Integer.decode(attrValue);
                }
            } else if ("permission".equals(attrName)) {
                result.permission = attrValue;
            } else if ("taskAffinity".equals(attrName)) {
                result.taskAffinity = attrValue;
            } else if ("multiprocess".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 1;
                }
            } else if ("finishOnTaskLaunch".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 2;
                }
            } else if ("clearTaskOnLaunch".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 4;
                }
            } else if ("noHistory".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x80;
                }
            } else if ("alwaysRetainTaskState".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 8;
                }
            } else if ("stateNotNeeded".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x10;
                }
            } else if ("excludeFromRecents".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x20;
                }
            } else if ("allowTaskReparenting".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x40;
                }
            } else if ("finishOnCloseSystemDialogs".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x100;
                }
            } else if ("showOnLockScreen".equals(attrName) || "showForAllUsers".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 23 && "true".equalsIgnoreCase(attrValue)) {
                    result.flags |= ShareReflectUtil.getValueOfStaticIntField(ActivityInfo.class, "FLAG_SHOW_FOR_ALL_USERS", 0);
                }
            } else if ("immersive".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 18 && "true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x800;
                }
            } else if ("hardwareAccelerated".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 11 && "true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x200;
                }
            } else if ("documentLaunchMode".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 21) {
                    result.documentLaunchMode = Integer.decode(attrValue);
                }
            } else if ("maxRecents".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 21) {
                    result.maxRecents = Integer.decode(attrValue);
                }
            } else if ("configChanges".equals(attrName)) {
                result.configChanges = Integer.decode(attrValue);
            } else if ("windowSoftInputMode".equals(attrName)) {
                result.softInputMode = Integer.decode(attrValue);
            } else if ("persistableMode".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 21) {
                    result.persistableMode = Integer.decode(attrValue);
                }
            } else if ("allowEmbedded".equals(attrName)) {
                if ("true".equalsIgnoreCase(attrValue)) {
                    result.flags |= ShareReflectUtil.getValueOfStaticIntField(ActivityInfo.class, "FLAG_ALLOW_EMBEDDED", 0);
                }
            } else if ("autoRemoveFromRecents".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 21 && "true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x2000;
                }
            } else if ("relinquishTaskIdentity".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 21 && "true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x1000;
                }
            } else if ("resumeWhilePausing".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 21 && "true".equalsIgnoreCase(attrValue)) {
                    result.flags |= 0x4000;
                }
            } else if ("screenOrientation".equals(attrName)) {
                result.screenOrientation = this.parseScreenOrientation(attrValue);
            } else if ("label".equals(attrName)) {
                String strOrResId = attrValue;
                int id = 0;
                try {
                    id = context.getResources().getIdentifier(strOrResId, "string", sPackageName);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (id != 0) {
                    result.labelRes = id;
                } else {
                    result.nonLocalizedLabel = strOrResId;
                }
            } else if ("icon".equals(attrName)) {
                try {
                    result.icon = context.getResources().getIdentifier(attrValue, null, sPackageName);
                }
                catch (Throwable throwable) {}
            } else if ("banner".equals(attrName)) {
                if (Build.VERSION.SDK_INT >= 20) {
                    try {
                        result.banner = context.getResources().getIdentifier(attrValue, null, sPackageName);
                    }
                    catch (Throwable throwable) {}
                }
            } else if ("logo".equals(attrName)) {
                try {
                    result.logo = context.getResources().getIdentifier(attrValue, null, sPackageName);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private int parseLaunchMode(String attrValue) {
            if ("standard".equalsIgnoreCase(attrValue)) {
                return 0;
            }
            if ("singleTop".equalsIgnoreCase(attrValue)) {
                return 1;
            }
            if ("singleTask".equalsIgnoreCase(attrValue)) {
                return 2;
            }
            if ("singleInstance".equalsIgnoreCase(attrValue)) {
                return 3;
            }
            Log.w((String)IncrementComponentManager.TAG, (String)("Unknown launchMode: " + attrValue));
            return 0;
        }

        private int parseScreenOrientation(String attrValue) {
            if ("unspecified".equalsIgnoreCase(attrValue)) {
                return -1;
            }
            if ("behind".equalsIgnoreCase(attrValue)) {
                return 3;
            }
            if ("landscape".equalsIgnoreCase(attrValue)) {
                return 0;
            }
            if ("portrait".equalsIgnoreCase(attrValue)) {
                return 1;
            }
            if ("reverseLandscape".equalsIgnoreCase(attrValue)) {
                return 8;
            }
            if ("reversePortrait".equalsIgnoreCase(attrValue)) {
                return 9;
            }
            if ("sensorLandscape".equalsIgnoreCase(attrValue)) {
                return 6;
            }
            if ("sensorPortrait".equalsIgnoreCase(attrValue)) {
                return 7;
            }
            if ("sensor".equalsIgnoreCase(attrValue)) {
                return 4;
            }
            if ("fullSensor".equalsIgnoreCase(attrValue)) {
                return 10;
            }
            if ("nosensor".equalsIgnoreCase(attrValue)) {
                return 5;
            }
            if ("user".equalsIgnoreCase(attrValue)) {
                return 2;
            }
            if (Build.VERSION.SDK_INT >= 18 && "fullUser".equalsIgnoreCase(attrValue)) {
                return 13;
            }
            if (Build.VERSION.SDK_INT >= 18 && "locked".equalsIgnoreCase(attrValue)) {
                return 14;
            }
            if (Build.VERSION.SDK_INT >= 18 && "userLandscape".equalsIgnoreCase(attrValue)) {
                return 11;
            }
            if (Build.VERSION.SDK_INT >= 18 && "userPortrait".equalsIgnoreCase(attrValue)) {
                return 12;
            }
            return -1;
        }
    };

    public static synchronized boolean init(Context context, ShareSecurityCheck checker) throws IOException {
        Context baseCtx;
        if (!checker.getMetaContentMap().containsKey("assets/inc_component_meta.txt")) {
            Log.i((String)TAG, (String)"package has no incremental component meta, skip init.");
            return false;
        }
        while (context instanceof ContextWrapper && (baseCtx = ((ContextWrapper)context).getBaseContext()) != null) {
            context = baseCtx;
        }
        sContext = context;
        sPackageName = context.getPackageName();
        String xmlMeta = checker.getMetaContentMap().get("assets/inc_component_meta.txt");
        StringReader sr = new StringReader(xmlMeta);
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((Reader)sr);
            int event = parser.getEventType();
            while (event != 1) {
                switch (event) {
                    case 2: {
                        String tagName = parser.getName();
                        if ("activity".equalsIgnoreCase(tagName)) {
                            ActivityInfo aInfo = IncrementComponentManager.parseActivity(context, parser);
                            sClassNameToActivityInfoMap.put(aInfo.name, aInfo);
                            break;
                        }
                        if ("service".equalsIgnoreCase(tagName) || "receiver".equalsIgnoreCase(tagName) || !"provider".equalsIgnoreCase(tagName)) break;
                        break;
                    }
                }
                event = parser.next();
            }
            sInitialized = true;
            boolean bl = true;
            return bl;
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        finally {
            SharePatchFileUtil.closeQuietly(sr);
        }
    }

    private static synchronized ActivityInfo parseActivity(Context context, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        ApplicationInfo appInfo;
        ActivityInfo aInfo = new ActivityInfo();
        aInfo.applicationInfo = appInfo = context.getApplicationInfo();
        aInfo.packageName = sPackageName;
        aInfo.processName = appInfo.processName;
        aInfo.launchMode = 0;
        aInfo.permission = appInfo.permission;
        aInfo.screenOrientation = -1;
        aInfo.taskAffinity = appInfo.taskAffinity;
        if (Build.VERSION.SDK_INT >= 11 && (appInfo.flags & 0x20000000) != 0) {
            aInfo.flags |= 0x200;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            aInfo.documentLaunchMode = 0;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            aInfo.uiOptions = appInfo.uiOptions;
        }
        sActivityInfoAttrTranslator.translate(context, 0, parser, aInfo);
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("intent-filter".equalsIgnoreCase(tagName)) {
                IncrementComponentManager.parseIntentFilter(context, aInfo.name, parser);
                continue;
            }
            if (!"meta-data".equalsIgnoreCase(tagName)) continue;
            IncrementComponentManager.parseMetaData(context, aInfo, parser);
        }
        return aInfo;
    }

    private static synchronized void parseIntentFilter(Context context, String componentName, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        String autoVerify;
        IntentFilter intentFilter = new IntentFilter();
        String priorityStr = parser.getAttributeValue(null, "priority");
        if (!TextUtils.isEmpty((CharSequence)priorityStr)) {
            intentFilter.setPriority(Integer.decode(priorityStr).intValue());
        }
        if (!TextUtils.isEmpty((CharSequence)(autoVerify = parser.getAttributeValue(null, "autoVerify")))) {
            try {
                Method setAutoVerifyMethod = ShareReflectUtil.findMethod(IntentFilter.class, "setAutoVerify", Boolean.TYPE);
                setAutoVerifyMethod.invoke((Object)intentFilter, "true".equalsIgnoreCase(autoVerify));
            }
            catch (Throwable setAutoVerifyMethod) {
                // empty catch block
            }
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String name;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("action".equals(tagName)) {
                name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    intentFilter.addAction(name);
                }
            } else if ("category".equals(tagName)) {
                name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    intentFilter.addCategory(name);
                }
            } else if ("data".equals(tagName)) {
                String pathPattern;
                String pathPrefix;
                String path;
                String scheme;
                String mimeType = parser.getAttributeValue(null, "mimeType");
                if (mimeType != null) {
                    try {
                        intentFilter.addDataType(mimeType);
                    }
                    catch (IntentFilter.MalformedMimeTypeException e) {
                        throw new XmlPullParserException("bad mimeType", parser, (Throwable)e);
                    }
                }
                if ((scheme = parser.getAttributeValue(null, "scheme")) != null) {
                    intentFilter.addDataScheme(scheme);
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    String sspPattern;
                    String sspPrefix;
                    String ssp = parser.getAttributeValue(null, "ssp");
                    if (ssp != null) {
                        intentFilter.addDataSchemeSpecificPart(ssp, 0);
                    }
                    if ((sspPrefix = parser.getAttributeValue(null, "sspPrefix")) != null) {
                        intentFilter.addDataSchemeSpecificPart(sspPrefix, 1);
                    }
                    if ((sspPattern = parser.getAttributeValue(null, "sspPattern")) != null) {
                        intentFilter.addDataSchemeSpecificPart(sspPattern, 2);
                    }
                }
                String host = parser.getAttributeValue(null, "host");
                String port = parser.getAttributeValue(null, "port");
                if (host != null) {
                    intentFilter.addDataAuthority(host, port);
                }
                if ((path = parser.getAttributeValue(null, "path")) != null) {
                    intentFilter.addDataPath(path, 0);
                }
                if ((pathPrefix = parser.getAttributeValue(null, "pathPrefix")) != null) {
                    intentFilter.addDataPath(pathPrefix, 1);
                }
                if ((pathPattern = parser.getAttributeValue(null, "pathPattern")) != null) {
                    intentFilter.addDataPath(pathPattern, 2);
                }
            }
            IncrementComponentManager.skipCurrentTag(parser);
        }
        sClassNameToIntentFilterMap.put(componentName, intentFilter);
    }

    private static synchronized void parseMetaData(Context context, ActivityInfo aInfo, XmlPullParser parser) throws XmlPullParserException, IOException {
        ClassLoader myCl = IncrementComponentManager.class.getClassLoader();
        String name = parser.getAttributeValue(null, "name");
        String value = parser.getAttributeValue(null, "value");
        if (!TextUtils.isEmpty((CharSequence)name)) {
            if (aInfo.metaData == null) {
                aInfo.metaData = new Bundle(myCl);
            }
            aInfo.metaData.putString(name, value);
        }
    }

    private static void skipCurrentTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
        }
    }

    private static synchronized void ensureInitialized() {
        if (!sInitialized) {
            throw new IllegalStateException("Not initialized!!");
        }
    }

    public static boolean isIncrementActivity(String className) {
        IncrementComponentManager.ensureInitialized();
        return className != null && sClassNameToActivityInfoMap.containsKey(className);
    }

    public static ActivityInfo queryActivityInfo(String className) {
        IncrementComponentManager.ensureInitialized();
        return className != null ? sClassNameToActivityInfoMap.get(className) : null;
    }

    public static ResolveInfo resolveIntent(Intent intent) {
        IncrementComponentManager.ensureInitialized();
        int maxPriority = -1;
        String bestComponentName = null;
        IntentFilter respFilter = null;
        int bestMatchRes = 0;
        ComponentName component = intent.getComponent();
        if (component != null) {
            String compName = component.getClassName();
            if (sClassNameToActivityInfoMap.containsKey(compName)) {
                bestComponentName = compName;
                maxPriority = 0;
            }
        } else {
            for (Map.Entry entry : sClassNameToIntentFilterMap.entrySet()) {
                String componentName = (String)entry.getKey();
                IntentFilter intentFilter = (IntentFilter)entry.getValue();
                int matchRes = intentFilter.match(intent.getAction(), intent.getType(), intent.getScheme(), intent.getData(), intent.getCategories(), TAG);
                boolean matches = matchRes != -3 && matchRes != -4 && matchRes != -2 && matchRes != -1;
                int priority = intentFilter.getPriority();
                if (!matches || priority <= maxPriority) continue;
                maxPriority = priority;
                bestComponentName = componentName;
                respFilter = intentFilter;
                bestMatchRes = matchRes;
            }
        }
        if (bestComponentName != null) {
            ResolveInfo result = new ResolveInfo();
            result.activityInfo = sClassNameToActivityInfoMap.get(bestComponentName);
            result.filter = respFilter;
            result.match = bestMatchRes;
            result.priority = maxPriority;
            result.resolvePackageName = sPackageName;
            result.icon = result.activityInfo.icon;
            result.labelRes = result.activityInfo.labelRes;
            return result;
        }
        return null;
    }

    private IncrementComponentManager() {
        throw new UnsupportedOperationException();
    }

    private static abstract class AttrTranslator<T_RESULT> {
        private AttrTranslator() {
        }

        final void translate(Context context, int tagType, XmlPullParser parser, T_RESULT result) {
            this.onInit(context, tagType, parser);
            int attrCount = parser.getAttributeCount();
            for (int i = 0; i < attrCount; ++i) {
                String attrPrefix = parser.getAttributePrefix(i);
                if (!"android".equals(attrPrefix)) continue;
                String attrName = parser.getAttributeName(i);
                String attrValue = parser.getAttributeValue(i);
                this.onTranslate(context, tagType, attrName, attrValue, result);
            }
        }

        void onInit(Context context, int tagType, XmlPullParser parser) {
        }

        abstract void onTranslate(Context var1, int var2, String var3, String var4, T_RESULT var5);
    }
}

