/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.hotplug.IncrementComponentManager;
import com.tencent.tinker.loader.hotplug.UnsupportedEnvironmentException;
import com.tencent.tinker.loader.hotplug.handler.AMSInterceptHandler;
import com.tencent.tinker.loader.hotplug.handler.MHMessageHandler;
import com.tencent.tinker.loader.hotplug.handler.PMSInterceptHandler;
import com.tencent.tinker.loader.hotplug.interceptor.HandlerMessageInterceptor;
import com.tencent.tinker.loader.hotplug.interceptor.ServiceBinderInterceptor;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import java.lang.reflect.Field;

public final class ComponentHotplug {
    private static final String TAG = "Tinker.ComponentHotplug";
    private static volatile boolean sInstalled = false;
    private static ServiceBinderInterceptor sAMSInterceptor;
    private static ServiceBinderInterceptor sPMSInterceptor;
    private static HandlerMessageInterceptor sMHMessageInterceptor;

    public static synchronized void install(TinkerApplication app, ShareSecurityCheck checker) throws UnsupportedEnvironmentException {
        if (!sInstalled) {
            try {
                if (IncrementComponentManager.init((Context)app, checker)) {
                    sAMSInterceptor = new ServiceBinderInterceptor((Context)app, "activity", new AMSInterceptHandler((Context)app));
                    sPMSInterceptor = new ServiceBinderInterceptor((Context)app, "package", new PMSInterceptHandler());
                    Handler mH = ComponentHotplug.fetchMHInstance((Context)app);
                    sMHMessageInterceptor = new HandlerMessageInterceptor(mH, new MHMessageHandler((Context)app));
                    sAMSInterceptor.install();
                    sPMSInterceptor.install();
                    sMHMessageInterceptor.install();
                    sInstalled = true;
                    Log.i((String)TAG, (String)"installed successfully.");
                }
            }
            catch (Throwable thr) {
                ComponentHotplug.uninstall();
                throw new UnsupportedEnvironmentException(thr);
            }
        }
    }

    public static synchronized void ensureComponentHotplugInstalled(TinkerApplication app) throws UnsupportedEnvironmentException {
        if (sInstalled) {
            try {
                sAMSInterceptor.install();
                sPMSInterceptor.install();
                sMHMessageInterceptor.install();
            }
            catch (Throwable thr) {
                ComponentHotplug.uninstall();
                throw new UnsupportedEnvironmentException(thr);
            }
        } else {
            Log.i((String)TAG, (String)"method install() is not invoked, ignore ensuring operations.");
        }
    }

    private static Handler fetchMHInstance(Context context) {
        Object activityThread = ShareReflectUtil.getActivityThread(context, null);
        if (activityThread == null) {
            throw new IllegalStateException("failed to fetch instance of ActivityThread.");
        }
        try {
            Field mHField = ShareReflectUtil.findField(activityThread, "mH");
            Handler mH = (Handler)mHField.get(activityThread);
            return mH;
        }
        catch (Throwable thr) {
            throw new IllegalStateException(thr);
        }
    }

    public static synchronized void uninstall() {
        if (sInstalled) {
            try {
                sAMSInterceptor.uninstall();
                sPMSInterceptor.uninstall();
                sMHMessageInterceptor.uninstall();
            }
            catch (Throwable thr) {
                Log.e((String)TAG, (String)"exception when uninstall.", (Throwable)thr);
            }
            sInstalled = false;
        }
    }

    private ComponentHotplug() {
        throw new UnsupportedOperationException();
    }
}

