/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class TinkerResourcePatcher {
    private static final String TAG = "Tinker.ResourcePatcher";
    private static final String TEST_ASSETS_VALUE = "only_use_to_test_tinker_resource.txt";
    private static Collection<WeakReference<Resources>> references = null;
    private static Object currentActivityThread = null;
    private static AssetManager newAssetManager = null;
    private static Method addAssetPathMethod = null;
    private static Method ensureStringBlocksMethod = null;
    private static Field assetsFiled = null;
    private static Field resourcesImplFiled = null;
    private static Field resDir = null;
    private static Field packagesFiled = null;
    private static Field resourcePackagesFiled = null;
    private static Field publicSourceDirField = null;

    TinkerResourcePatcher() {
    }

    public static void isResourceCanPatch(Context context) throws Throwable {
        Class<?> loadedApkClass;
        Class<?> activityThread = Class.forName("android.app.ActivityThread");
        currentActivityThread = ShareReflectUtil.getActivityThread(context, activityThread);
        try {
            loadedApkClass = Class.forName("android.app.LoadedApk");
        }
        catch (ClassNotFoundException e) {
            loadedApkClass = Class.forName("android.app.ActivityThread$PackageInfo");
        }
        resDir = loadedApkClass.getDeclaredField("mResDir");
        resDir.setAccessible(true);
        packagesFiled = activityThread.getDeclaredField("mPackages");
        packagesFiled.setAccessible(true);
        resourcePackagesFiled = activityThread.getDeclaredField("mResourcePackages");
        resourcePackagesFiled.setAccessible(true);
        AssetManager assets = context.getAssets();
        if (assets.getClass().getName().equals("android.content.res.BaiduAssetManager")) {
            Class<?> baiduAssetManager = Class.forName("android.content.res.BaiduAssetManager");
            newAssetManager = (AssetManager)baiduAssetManager.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            newAssetManager = (AssetManager)AssetManager.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        addAssetPathMethod = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
        addAssetPathMethod.setAccessible(true);
        ensureStringBlocksMethod = AssetManager.class.getDeclaredMethod("ensureStringBlocks", new Class[0]);
        ensureStringBlocksMethod.setAccessible(true);
        if (Build.VERSION.SDK_INT >= 19) {
            Class<?> resourcesManagerClass = Class.forName("android.app.ResourcesManager");
            Method mGetInstance = resourcesManagerClass.getDeclaredMethod("getInstance", new Class[0]);
            mGetInstance.setAccessible(true);
            Object resourcesManager = mGetInstance.invoke(null, new Object[0]);
            try {
                Field fMActiveResources = resourcesManagerClass.getDeclaredField("mActiveResources");
                fMActiveResources.setAccessible(true);
                ArrayMap activeResources19 = (ArrayMap)fMActiveResources.get(resourcesManager);
                references = activeResources19.values();
            }
            catch (NoSuchFieldException ignore) {
                Field mResourceReferences = resourcesManagerClass.getDeclaredField("mResourceReferences");
                mResourceReferences.setAccessible(true);
                references = (Collection)mResourceReferences.get(resourcesManager);
            }
        } else {
            Field fMActiveResources = activityThread.getDeclaredField("mActiveResources");
            fMActiveResources.setAccessible(true);
            HashMap activeResources7 = (HashMap)fMActiveResources.get(currentActivityThread);
            references = activeResources7.values();
        }
        if (references == null) {
            throw new IllegalStateException("resource references is null");
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                resourcesImplFiled = Resources.class.getDeclaredField("mResourcesImpl");
                resourcesImplFiled.setAccessible(true);
            }
            catch (Throwable ignore) {
                assetsFiled = Resources.class.getDeclaredField("mAssets");
                assetsFiled.setAccessible(true);
            }
        } else {
            assetsFiled = Resources.class.getDeclaredField("mAssets");
            assetsFiled.setAccessible(true);
        }
        try {
            publicSourceDirField = ShareReflectUtil.findField(ApplicationInfo.class, "publicSourceDir");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static void monkeyPatchExistingResources(Context context, String externalResourceFile) throws Throwable {
        if (externalResourceFile == null) {
            return;
        }
        for (Field field : new Field[]{packagesFiled, resourcePackagesFiled}) {
            Object value = field.get(currentActivityThread);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object loadedApk = ((WeakReference)entry.getValue()).get();
                if (loadedApk == null || externalResourceFile == null) continue;
                resDir.set(loadedApk, externalResourceFile);
            }
        }
        if ((Integer)addAssetPathMethod.invoke((Object)newAssetManager, externalResourceFile) == 0) {
            throw new IllegalStateException("Could not create new AssetManager");
        }
        ensureStringBlocksMethod.invoke((Object)newAssetManager, new Object[0]);
        for (WeakReference weakReference : references) {
            Resources resources = (Resources)weakReference.get();
            if (resources == null) continue;
            try {
                assetsFiled.set(resources, newAssetManager);
            }
            catch (Throwable ignore) {
                Object resourceImpl = resourcesImplFiled.get(resources);
                Field implAssets = ShareReflectUtil.findField(resourceImpl, "mAssets");
                implAssets.setAccessible(true);
                implAssets.set(resourceImpl, newAssetManager);
            }
            TinkerResourcePatcher.clearPreloadTypedArrayIssue(resources);
            resources.updateConfiguration(resources.getConfiguration(), resources.getDisplayMetrics());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                if (publicSourceDirField != null) {
                    publicSourceDirField.set(context.getApplicationInfo(), externalResourceFile);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!TinkerResourcePatcher.checkResUpdate(context)) {
            throw new TinkerRuntimeException("checkResInstall failed");
        }
    }

    private static void clearPreloadTypedArrayIssue(Resources resources) {
        Log.w((String)TAG, (String)"try to clear typedArray cache!");
        try {
            Field typedArrayPoolField = ShareReflectUtil.findField(Resources.class, "mTypedArrayPool");
            Object origTypedArrayPool = typedArrayPoolField.get(resources);
            Field poolField = ShareReflectUtil.findField(origTypedArrayPool, "mPool");
            Constructor<?> typedArrayConstructor = origTypedArrayPool.getClass().getConstructor(Integer.TYPE);
            typedArrayConstructor.setAccessible(true);
            int poolSize = ((Object[])poolField.get(origTypedArrayPool)).length;
            Object newTypedArrayPool = typedArrayConstructor.newInstance(poolSize);
            typedArrayPoolField.set(resources, newTypedArrayPool);
        }
        catch (Throwable ignored) {
            Log.e((String)TAG, (String)("clearPreloadTypedArrayIssue failed, ignore error: " + ignored));
        }
    }

    private static boolean checkResUpdate(Context context) {
        try {
            context.getAssets().open(TEST_ASSETS_VALUE);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("checkResUpdate failed, can't find test resource assets file only_use_to_test_tinker_resource.txt e:" + e.getMessage()));
            return false;
        }
        Log.i((String)TAG, (String)"checkResUpdate success, found test resource assets file only_use_to_test_tinker_resource.txt");
        return true;
    }
}

