/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.content.Intent;
import android.util.Log;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.TinkerDexOptimizer;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.shareutil.ShareConstants;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TinkerDexLoader {
    private static final String TAG = "Tinker.TinkerDexLoader";
    private static final String DEX_MEAT_FILE = "assets/dex_meta.txt";
    private static final String DEX_PATH = "dex";
    private static final String DEFAULT_DEX_OPTIMIZE_PATH = "odex";
    private static final String INTERPRET_DEX_OPTIMIZE_PATH = "interpet";
    private static final ArrayList<ShareDexDiffPatchInfo> loadDexList = new ArrayList();
    private static HashSet<ShareDexDiffPatchInfo> classNDexInfo = new HashSet();
    private static boolean isVmArt = ShareTinkerInternals.isVmArt();

    private TinkerDexLoader() {
    }

    @TargetApi(value=14)
    public static boolean loadTinkerJars(TinkerApplication application, String directory, String oatDir, Intent intentResult, boolean isSystemOTA) {
        if (loadDexList.isEmpty() && classNDexInfo.isEmpty()) {
            Log.w((String)TAG, (String)"there is no dex to load");
            return true;
        }
        PathClassLoader classLoader = (PathClassLoader)TinkerDexLoader.class.getClassLoader();
        if (classLoader == null) {
            Log.e((String)TAG, (String)"classloader is null");
            ShareIntentUtil.setIntentReturnCode(intentResult, -12);
            return false;
        }
        Log.i((String)TAG, (String)("classloader: " + classLoader.toString()));
        String dexPath = directory + "/" + DEX_PATH + "/";
        ArrayList<File> legalFiles = new ArrayList<File>();
        for (ShareDexDiffPatchInfo info : loadDexList) {
            if (TinkerDexLoader.isJustArtSupportDex(info)) continue;
            String path = dexPath + info.realName;
            File file = new File(path);
            if (application.isTinkerLoadVerifyFlag()) {
                long start = System.currentTimeMillis();
                String checkMd5 = TinkerDexLoader.getInfoMd5(info);
                if (!SharePatchFileUtil.verifyDexFileMd5(file, checkMd5)) {
                    ShareIntentUtil.setIntentReturnCode(intentResult, -13);
                    intentResult.putExtra("intent_patch_mismatch_dex_path", file.getAbsolutePath());
                    return false;
                }
                Log.i((String)TAG, (String)("verify dex file:" + file.getPath() + " md5, use time: " + (System.currentTimeMillis() - start)));
            }
            legalFiles.add(file);
        }
        if (isVmArt && !classNDexInfo.isEmpty()) {
            File classNFile = new File(dexPath + "tinker_classN.apk");
            long start = System.currentTimeMillis();
            if (application.isTinkerLoadVerifyFlag()) {
                for (ShareDexDiffPatchInfo info : classNDexInfo) {
                    if (SharePatchFileUtil.verifyDexFileMd5(classNFile, info.rawName, info.destMd5InArt)) continue;
                    ShareIntentUtil.setIntentReturnCode(intentResult, -13);
                    intentResult.putExtra("intent_patch_mismatch_dex_path", classNFile.getAbsolutePath());
                    return false;
                }
            }
            Log.i((String)TAG, (String)("verify dex file:" + classNFile.getPath() + " md5, use time: " + (System.currentTimeMillis() - start)));
            legalFiles.add(classNFile);
        }
        File optimizeDir = new File(directory + "/" + oatDir);
        if (isSystemOTA) {
            String targetISA;
            final boolean[] parallelOTAResult = new boolean[]{true};
            final Throwable[] parallelOTAThrowable = new Throwable[1];
            try {
                targetISA = ShareTinkerInternals.getCurrentInstructionSet();
            }
            catch (Throwable throwable) {
                Log.i((String)TAG, (String)("getCurrentInstructionSet fail:" + throwable));
                TinkerDexLoader.deleteOutOfDateOATFile(directory);
                intentResult.putExtra("intent_patch_interpret_exception", (Serializable)throwable);
                ShareIntentUtil.setIntentReturnCode(intentResult, -15);
                return false;
            }
            TinkerDexLoader.deleteOutOfDateOATFile(directory);
            Log.w((String)TAG, (String)("systemOTA, try parallel oat dexes, targetISA:" + targetISA));
            optimizeDir = new File(directory + "/" + INTERPRET_DEX_OPTIMIZE_PATH);
            TinkerDexOptimizer.optimizeAll(legalFiles, optimizeDir, true, targetISA, new TinkerDexOptimizer.ResultCallback(){
                long start;

                @Override
                public void onStart(File dexFile, File optimizedDir) {
                    this.start = System.currentTimeMillis();
                    Log.i((String)TinkerDexLoader.TAG, (String)("start to optimize dex:" + dexFile.getPath()));
                }

                @Override
                public void onSuccess(File dexFile, File optimizedDir, File optimizedFile) {
                    Log.i((String)TinkerDexLoader.TAG, (String)("success to optimize dex " + dexFile.getPath() + ", use time " + (System.currentTimeMillis() - this.start)));
                }

                @Override
                public void onFailed(File dexFile, File optimizedDir, Throwable thr) {
                    parallelOTAResult[0] = false;
                    parallelOTAThrowable[0] = thr;
                    Log.i((String)TinkerDexLoader.TAG, (String)("fail to optimize dex " + dexFile.getPath() + ", use time " + (System.currentTimeMillis() - this.start)));
                }
            });
            if (!parallelOTAResult[0]) {
                Log.e((String)TAG, (String)"parallel oat dexes failed");
                intentResult.putExtra("intent_patch_interpret_exception", (Serializable)parallelOTAThrowable[0]);
                ShareIntentUtil.setIntentReturnCode(intentResult, -16);
                return false;
            }
        }
        try {
            SystemClassLoaderAdder.installDexes(application, classLoader, optimizeDir, legalFiles);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"install dexes failed");
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -14);
            return false;
        }
        return true;
    }

    public static boolean checkComplete(String directory, ShareSecurityCheck securityCheck, String oatDir, Intent intentResult) {
        String dexDirectory;
        File dexDir;
        String meta = securityCheck.getMetaContentMap().get(DEX_MEAT_FILE);
        if (meta == null) {
            return true;
        }
        loadDexList.clear();
        classNDexInfo.clear();
        ArrayList<ShareDexDiffPatchInfo> allDexInfo = new ArrayList<ShareDexDiffPatchInfo>();
        ShareDexDiffPatchInfo.parseDexDiffPatchInfo(meta, allDexInfo);
        if (allDexInfo.isEmpty()) {
            return true;
        }
        HashMap<String, String> dexes = new HashMap<String, String>();
        ShareDexDiffPatchInfo testInfo = null;
        for (ShareDexDiffPatchInfo info : allDexInfo) {
            if (TinkerDexLoader.isJustArtSupportDex(info)) continue;
            if (!ShareDexDiffPatchInfo.checkDexDiffPatchInfo(info)) {
                intentResult.putExtra("intent_patch_package_patch_check", -3);
                ShareIntentUtil.setIntentReturnCode(intentResult, -8);
                return false;
            }
            if (isVmArt && info.rawName.startsWith("test.dex")) {
                testInfo = info;
                continue;
            }
            if (isVmArt && ShareConstants.CLASS_N_PATTERN.matcher(info.realName).matches()) {
                classNDexInfo.add(info);
                continue;
            }
            dexes.put(info.realName, TinkerDexLoader.getInfoMd5(info));
            loadDexList.add(info);
        }
        if (isVmArt && (testInfo != null || !classNDexInfo.isEmpty())) {
            if (testInfo != null) {
                classNDexInfo.add(ShareTinkerInternals.changeTestDexToClassN(testInfo, classNDexInfo.size() + 1));
            }
            dexes.put("tinker_classN.apk", "");
        }
        if (!(dexDir = new File(dexDirectory = directory + "/" + DEX_PATH + "/")).exists() || !dexDir.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -9);
            return false;
        }
        String optimizeDexDirectory = directory + "/" + oatDir + "/";
        File optimizeDexDirectoryFile = new File(optimizeDexDirectory);
        for (String name : dexes.keySet()) {
            File dexFile = new File(dexDirectory + name);
            if (!SharePatchFileUtil.isLegalFile(dexFile)) {
                intentResult.putExtra("intent_patch_missing_dex_path", dexFile.getAbsolutePath());
                ShareIntentUtil.setIntentReturnCode(intentResult, -10);
                return false;
            }
            File dexOptFile = new File(SharePatchFileUtil.optimizedPathFor(dexFile, optimizeDexDirectoryFile));
            if (SharePatchFileUtil.isLegalFile(dexOptFile)) continue;
            intentResult.putExtra("intent_patch_missing_dex_path", dexOptFile.getAbsolutePath());
            ShareIntentUtil.setIntentReturnCode(intentResult, -11);
            return false;
        }
        intentResult.putExtra("intent_patch_dexes_path", dexes);
        return true;
    }

    private static String getInfoMd5(ShareDexDiffPatchInfo info) {
        return isVmArt ? info.destMd5InArt : info.destMd5InDvm;
    }

    private static void deleteOutOfDateOATFile(String directory) {
        String optimizeDexDirectory = directory + "/" + DEFAULT_DEX_OPTIMIZE_PATH + "/";
        SharePatchFileUtil.deleteDir(optimizeDexDirectory);
        if (ShareTinkerInternals.isAfterAndroidO()) {
            String androidODexDirectory = directory + "/" + DEX_PATH + "/" + "oat" + "/";
            SharePatchFileUtil.deleteDir(androidODexDirectory);
        }
    }

    private static boolean isJustArtSupportDex(ShareDexDiffPatchInfo dexDiffPatchInfo) {
        if (isVmArt) {
            return false;
        }
        String destMd5InDvm = dexDiffPatchInfo.destMd5InDvm;
        return destMd5InDvm.equals("0");
    }
}

