/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ShareTinkerInternals {
    private static final String TAG = "Tinker.TinkerInternals";
    private static final boolean VM_IS_ART = ShareTinkerInternals.isVmArt(System.getProperty("java.vm.version"));
    private static final boolean VM_IS_JIT = ShareTinkerInternals.isVmJitInternal();
    private static final String PATCH_PROCESS_NAME = ":patch";
    private static Boolean isPatchProcess = null;
    private static String processName = null;
    private static String tinkerID = null;
    private static String currentInstructionSet = null;

    public static boolean isVmArt() {
        return VM_IS_ART || Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isVmJit() {
        return VM_IS_JIT && Build.VERSION.SDK_INT < 24;
    }

    public static boolean isAfterAndroidO() {
        return Build.VERSION.SDK_INT > 25;
    }

    public static String getCurrentInstructionSet() throws Exception {
        if (currentInstructionSet != null) {
            return currentInstructionSet;
        }
        Class<?> clazz = Class.forName("dalvik.system.VMRuntime");
        Method currentGet = clazz.getDeclaredMethod("getCurrentInstructionSet", new Class[0]);
        currentInstructionSet = (String)currentGet.invoke(null, new Object[0]);
        Log.d((String)TAG, (String)("getCurrentInstructionSet:" + currentInstructionSet));
        return currentInstructionSet;
    }

    public static boolean isSystemOTA(String lastFingerPrint) {
        String currentFingerprint = Build.FINGERPRINT;
        if (lastFingerPrint == null || lastFingerPrint.equals("") || currentFingerprint == null || currentFingerprint.equals("")) {
            Log.d((String)TAG, (String)("fingerprint empty:" + lastFingerPrint + ",current:" + currentFingerprint));
            return false;
        }
        if (lastFingerPrint.equals(currentFingerprint)) {
            Log.d((String)TAG, (String)("same fingerprint:" + currentFingerprint));
            return false;
        }
        Log.d((String)TAG, (String)("system OTA,fingerprint not equal:" + lastFingerPrint + "," + currentFingerprint));
        return true;
    }

    public static ShareDexDiffPatchInfo changeTestDexToClassN(ShareDexDiffPatchInfo rawDexInfo, int index) {
        if (rawDexInfo.rawName.startsWith("test.dex")) {
            String newName = index != 1 ? "classes" + index + ".dex" : "classes.dex";
            return new ShareDexDiffPatchInfo(newName, rawDexInfo.path, rawDexInfo.destMd5InDvm, rawDexInfo.destMd5InArt, rawDexInfo.dexDiffMd5, rawDexInfo.oldDexCrC, rawDexInfo.newDexCrC, rawDexInfo.dexMode);
        }
        return null;
    }

    public static boolean isNullOrNil(String object) {
        return object == null || object.length() <= 0;
    }

    public static int checkTinkerPackage(Context context, int tinkerFlag, File patchFile, ShareSecurityCheck securityCheck) {
        int returnCode = ShareTinkerInternals.checkSignatureAndTinkerID(context, patchFile, securityCheck);
        if (returnCode == 0) {
            returnCode = ShareTinkerInternals.checkPackageAndTinkerFlag(securityCheck, tinkerFlag);
        }
        return returnCode;
    }

    public static int checkSignatureAndTinkerID(Context context, File patchFile, ShareSecurityCheck securityCheck) {
        if (!securityCheck.verifyPatchMetaSignature(patchFile)) {
            return -1;
        }
        String oldTinkerId = ShareTinkerInternals.getManifestTinkerID(context);
        if (oldTinkerId == null) {
            return -5;
        }
        HashMap<String, String> properties = securityCheck.getPackagePropertiesIfPresent();
        if (properties == null) {
            return -2;
        }
        String patchTinkerId = properties.get("TINKER_ID");
        if (patchTinkerId == null) {
            return -6;
        }
        if (!oldTinkerId.equals(patchTinkerId)) {
            Log.e((String)TAG, (String)("tinkerId is not equal, base is " + oldTinkerId + ", but patch is " + patchTinkerId));
            return -7;
        }
        return 0;
    }

    public static int checkPackageAndTinkerFlag(ShareSecurityCheck securityCheck, int tinkerFlag) {
        if (ShareTinkerInternals.isTinkerEnabledAll(tinkerFlag)) {
            return 0;
        }
        HashMap<String, String> metaContentMap = securityCheck.getMetaContentMap();
        boolean dexEnable = ShareTinkerInternals.isTinkerEnabledForDex(tinkerFlag);
        if (!dexEnable && metaContentMap.containsKey("assets/dex_meta.txt")) {
            return -9;
        }
        boolean nativeEnable = ShareTinkerInternals.isTinkerEnabledForNativeLib(tinkerFlag);
        if (!nativeEnable && metaContentMap.containsKey("assets/so_meta.txt")) {
            return -9;
        }
        boolean resEnable = ShareTinkerInternals.isTinkerEnabledForResource(tinkerFlag);
        if (!resEnable && metaContentMap.containsKey("assets/res_meta.txt")) {
            return -9;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties fastGetPatchPackageMeta(File patchFile) {
        ZipEntry packageEntry;
        ZipFile zipFile;
        block9: {
            if (patchFile == null || !patchFile.isFile() || patchFile.length() == 0L) {
                Log.e((String)TAG, (String)"patchFile is illegal");
                return null;
            }
            zipFile = null;
            zipFile = new ZipFile(patchFile);
            packageEntry = zipFile.getEntry("assets/package_meta.txt");
            if (packageEntry != null) break block9;
            Log.e((String)TAG, (String)"patch meta entry not found");
            Properties properties = null;
            SharePatchFileUtil.closeZip(zipFile);
            return properties;
        }
        InputStream inputStream = null;
        inputStream = zipFile.getInputStream(packageEntry);
        Properties properties = new Properties();
        properties.load(inputStream);
        Properties properties2 = properties;
        SharePatchFileUtil.closeQuietly(inputStream);
        SharePatchFileUtil.closeZip(zipFile);
        return properties2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        SharePatchFileUtil.closeQuietly(inputStream);
                        throw throwable;
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)("fastGetPatchPackageMeta exception:" + e.getMessage()));
                        Properties properties3 = null;
                        SharePatchFileUtil.closeZip(zipFile);
                        return properties3;
                    }
                }
                catch (Throwable throwable2) {
                    SharePatchFileUtil.closeZip(zipFile);
                    throw throwable2;
                }
            }
        }
    }

    public static String getManifestTinkerID(Context context) {
        if (tinkerID != null) {
            return tinkerID;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Object object = appInfo.metaData.get("TINKER_ID");
            tinkerID = object != null ? String.valueOf(object) : null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getManifestTinkerID exception:" + e.getMessage()));
            return null;
        }
        return tinkerID;
    }

    public static boolean isTinkerEnabledForDex(int flag) {
        return (flag & 1) != 0;
    }

    public static boolean isTinkerEnabledForNativeLib(int flag) {
        return (flag & 2) != 0;
    }

    public static boolean isTinkerEnabledForResource(int flag) {
        return (flag & 4) != 0;
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 3: {
                return "dex";
            }
            case 4: {
                return "dex_opt";
            }
            case 5: {
                return "lib";
            }
            case 1: {
                return "patch_file";
            }
            case 2: {
                return "patch_info";
            }
            case 6: {
                return "resource";
            }
        }
        return "unknown";
    }

    public static void setTinkerDisableWithSharedPreferences(Context context) {
        SharedPreferences sp = context.getSharedPreferences("tinker_share_config", 4);
        sp.edit().putBoolean(ShareTinkerInternals.getTinkerSharedPreferencesName(), false).commit();
    }

    public static boolean isTinkerEnableWithSharedPreferences(Context context) {
        if (context == null) {
            return false;
        }
        SharedPreferences sp = context.getSharedPreferences("tinker_share_config", 4);
        return sp.getBoolean(ShareTinkerInternals.getTinkerSharedPreferencesName(), true);
    }

    private static String getTinkerSharedPreferencesName() {
        return "tinker_enable_1.8.1";
    }

    public static boolean isTinkerEnabled(int flag) {
        return flag != 0;
    }

    public static boolean isTinkerEnabledAll(int flag) {
        return flag == 7;
    }

    public static boolean isInMainProcess(Context context) {
        String pkgName = context.getPackageName();
        String processName = ShareTinkerInternals.getProcessName(context);
        if (processName == null || processName.length() == 0) {
            processName = "";
        }
        return pkgName.equals(processName);
    }

    public static boolean isInPatchProcess(Context context) {
        if (isPatchProcess != null) {
            return isPatchProcess;
        }
        isPatchProcess = ShareTinkerInternals.getProcessName(context).endsWith(PATCH_PROCESS_NAME);
        return isPatchProcess;
    }

    public static String getCurrentOatMode(Context context, String current) {
        if (current.equals("changing")) {
            current = ShareTinkerInternals.isInMainProcess(context) ? "odex" : "interpet";
        }
        return current;
    }

    public static void killAllOtherProcess(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am == null) {
            return;
        }
        List appProcessList = am.getRunningAppProcesses();
        if (appProcessList == null) {
            return;
        }
        for (ActivityManager.RunningAppProcessInfo ai : appProcessList) {
            if (ai.uid != Process.myUid() || ai.pid == Process.myPid()) continue;
            Process.killProcess((int)ai.pid);
        }
    }

    public static String getProcessName(Context context) {
        if (processName != null) {
            return processName;
        }
        processName = ShareTinkerInternals.getProcessNameInternal(context);
        return processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessNameInternal(Context context) {
        List appProcessList;
        int myPid = Process.myPid();
        if (context == null || myPid <= 0) {
            return "";
        }
        ActivityManager.RunningAppProcessInfo myProcess = null;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null && (appProcessList = activityManager.getRunningAppProcesses()) != null) {
            try {
                for (ActivityManager.RunningAppProcessInfo process : appProcessList) {
                    if (process.pid != myPid) continue;
                    myProcess = process;
                    break;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getProcessNameInternal exception:" + e.getMessage()));
            }
            if (myProcess != null) {
                return myProcess.processName;
            }
        }
        byte[] b = new byte[128];
        FileInputStream in = null;
        try {
            in = new FileInputStream("/proc/" + myPid + "/cmdline");
            int len = in.read(b);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    if (b[i] <= 128 && b[i] > 0) continue;
                    len = i;
                    break;
                }
                String string = new String(b, 0, len);
                return string;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getProcessNameInternal exception:" + e.getMessage()));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return "";
    }

    private static boolean isVmArt(String versionString) {
        Matcher matcher;
        boolean isArt = false;
        if (versionString != null && (matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(versionString)).matches()) {
            try {
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                isArt = major > 2 || major == 2 && minor >= 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isArt;
    }

    private static boolean isVmJitInternal() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method mthGet = clazz.getDeclaredMethod("get", String.class);
            String jit = (String)mthGet.invoke(null, "dalvik.vm.usejit");
            String jitProfile = (String)mthGet.invoke(null, "dalvik.vm.usejitprofiles");
            if (!ShareTinkerInternals.isNullOrNil(jit) && ShareTinkerInternals.isNullOrNil(jitProfile) && jit.equals("true")) {
                return true;
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("isVmJitInternal ex:" + e));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExceptionCauseString(Throwable ex) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        try {
            Throwable t = ex;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            t.printStackTrace(ps);
            String string = ShareTinkerInternals.toVisualString(bos.toString());
            return string;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String toVisualString(String src) {
        int i;
        boolean cutFlg = false;
        if (null == src) {
            return null;
        }
        char[] chr = src.toCharArray();
        if (null == chr) {
            return null;
        }
        for (i = 0; i < chr.length; ++i) {
            if (chr[i] <= '\u007f') continue;
            chr[i] = '\u0000';
            cutFlg = true;
            break;
        }
        if (cutFlg) {
            return new String(chr, 0, i);
        }
        return src;
    }
}

