/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import com.tencent.tinker.loader.shareutil.ShareElfFile;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public final class ShareOatUtil {
    private static final String TAG = "Tinker.OatUtil";

    private ShareOatUtil() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getOatFileInstructionSet(File oatFile) throws Throwable {
        ShareElfFile elfFile = null;
        String result = "";
        try {
            elfFile = new ShareElfFile(oatFile);
            ShareElfFile.SectionHeader roDataHdr = elfFile.getSectionHeaderByName(".rodata");
            if (roDataHdr == null) {
                throw new IOException("Unable to find .rodata section.");
            }
            FileChannel channel = elfFile.getChannel();
            channel.position(roDataHdr.shOffset);
            byte[] oatMagicAndVersion = new byte[8];
            ShareElfFile.readUntilLimit(channel, ByteBuffer.wrap(oatMagicAndVersion), "Failed to read oat magic and version.");
            if (oatMagicAndVersion[0] != 111 || oatMagicAndVersion[1] != 97 || oatMagicAndVersion[2] != 116 || oatMagicAndVersion[3] != 10) {
                throw new IOException(String.format("Bad oat magic: %x %x %x %x", oatMagicAndVersion[0], oatMagicAndVersion[1], oatMagicAndVersion[2], oatMagicAndVersion[3]));
            }
            int versionOffsetFromOatBegin = 4;
            int versionBytes = 3;
            String oatVersion = new String(oatMagicAndVersion, 4, 3, Charset.forName("ASCII"));
            try {
                Integer.parseInt(oatVersion);
            }
            catch (NumberFormatException e) {
                throw new IOException("Bad oat version: " + oatVersion);
            }
            ByteBuffer buffer = ByteBuffer.allocate(128);
            buffer.order(elfFile.getDataOrder());
            int isaNumOffsetFromOatBegin = 12;
            channel.position(roDataHdr.shOffset + 12L);
            buffer.limit(4);
            ShareElfFile.readUntilLimit(channel, buffer, "Failed to read isa num.");
            int isaNum = buffer.getInt();
            if (isaNum < 0 || isaNum >= InstructionSet.values().length) {
                throw new IOException("Bad isa num: " + isaNum);
            }
            switch (InstructionSet.values()[isaNum]) {
                case kArm: 
                case kThumb2: {
                    result = "arm";
                    return result;
                }
                case kArm64: {
                    result = "arm64";
                    return result;
                }
                case kX86: {
                    result = "x86";
                    return result;
                }
                case kX86_64: {
                    result = "x86_64";
                    return result;
                }
                case kMips: {
                    result = "mips";
                    return result;
                }
                case kMips64: {
                    result = "mips64";
                    return result;
                }
                case kNone: {
                    result = "none";
                    return result;
                }
                default: {
                    throw new IOException("Should not reach here.");
                }
            }
        }
        finally {
            if (elfFile != null) {
                try {
                    elfFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static enum InstructionSet {
        kNone,
        kArm,
        kArm64,
        kThumb2,
        kX86,
        kX86_64,
        kMips,
        kMips64;

    }
}

