/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.content.Intent;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class ShareIntentUtil {
    public static final String INTENT_RETURN_CODE = "intent_return_code";
    public static final String INTENT_PATCH_OLD_VERSION = "intent_patch_old_version";
    public static final String INTENT_PATCH_NEW_VERSION = "intent_patch_new_version";
    public static final String INTENT_PATCH_MISMATCH_DEX_PATH = "intent_patch_mismatch_dex_path";
    public static final String INTENT_PATCH_MISSING_DEX_PATH = "intent_patch_missing_dex_path";
    public static final String INTENT_PATCH_DEXES_PATH = "intent_patch_dexes_path";
    public static final String INTENT_PATCH_MISMATCH_LIB_PATH = "intent_patch_mismatch_lib_path";
    public static final String INTENT_PATCH_MISSING_LIB_PATH = "intent_patch_missing_lib_path";
    public static final String INTENT_PATCH_LIBS_PATH = "intent_patch_libs_path";
    public static final String INTENT_PATCH_COST_TIME = "intent_patch_cost_time";
    public static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    public static final String INTENT_PATCH_PACKAGE_PATCH_CHECK = "intent_patch_package_patch_check";
    public static final String INTENT_PATCH_PACKAGE_CONFIG = "intent_patch_package_config";
    public static final String INTENT_PATCH_SYSTEM_OTA = "intent_patch_system_ota";
    public static final String INTENT_PATCH_OAT_DIR = "intent_patch_oat_dir";
    public static final String INTENT_PATCH_INTERPRET_EXCEPTION = "intent_patch_interpret_exception";
    private static final String TAG = "ShareIntentUtil";

    public static void setIntentReturnCode(Intent intent, int code) {
        intent.putExtra(INTENT_RETURN_CODE, code);
    }

    public static int getIntentReturnCode(Intent intent) {
        return ShareIntentUtil.getIntExtra(intent, INTENT_RETURN_CODE, -10000);
    }

    public static void setIntentPatchCostTime(Intent intent, long cost) {
        intent.putExtra(INTENT_PATCH_COST_TIME, cost);
    }

    public static long getIntentPatchCostTime(Intent intent) {
        return intent.getLongExtra(INTENT_PATCH_COST_TIME, 0L);
    }

    public static Throwable getIntentPatchException(Intent intent) {
        Serializable serializable = ShareIntentUtil.getSerializableExtra(intent, INTENT_PATCH_EXCEPTION);
        if (serializable != null) {
            return (Throwable)serializable;
        }
        return null;
    }

    public static Throwable getIntentInterpretException(Intent intent) {
        Serializable serializable = ShareIntentUtil.getSerializableExtra(intent, INTENT_PATCH_INTERPRET_EXCEPTION);
        if (serializable != null) {
            return (Throwable)serializable;
        }
        return null;
    }

    public static HashMap<String, String> getIntentPatchDexPaths(Intent intent) {
        Serializable serializable = ShareIntentUtil.getSerializableExtra(intent, INTENT_PATCH_DEXES_PATH);
        if (serializable != null) {
            return (HashMap)serializable;
        }
        return null;
    }

    public static HashMap<String, String> getIntentPatchLibsPaths(Intent intent) {
        Serializable serializable = ShareIntentUtil.getSerializableExtra(intent, INTENT_PATCH_LIBS_PATH);
        if (serializable != null) {
            return (HashMap)serializable;
        }
        return null;
    }

    public static HashMap<String, String> getIntentPackageConfig(Intent intent) {
        Serializable serializable = ShareIntentUtil.getSerializableExtra(intent, INTENT_PATCH_PACKAGE_CONFIG);
        if (serializable != null) {
            return (HashMap)serializable;
        }
        return null;
    }

    public static ArrayList<String> getStringArrayListExtra(Intent intent, String name) {
        if (null == intent) {
            return null;
        }
        ArrayList ret = null;
        try {
            ret = intent.getStringArrayListExtra(name);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getStringExtra exception:" + e.getMessage()));
            ret = null;
        }
        return ret;
    }

    public static String getStringExtra(Intent intent, String name) {
        if (null == intent) {
            return null;
        }
        String ret = null;
        try {
            ret = intent.getStringExtra(name);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getStringExtra exception:" + e.getMessage()));
            ret = null;
        }
        return ret;
    }

    public static Serializable getSerializableExtra(Intent intent, String name) {
        if (null == intent) {
            return null;
        }
        Serializable ret = null;
        try {
            ret = intent.getSerializableExtra(name);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getSerializableExtra exception:" + e.getMessage()));
            ret = null;
        }
        return ret;
    }

    public static int getIntExtra(Intent intent, String name, int defaultValue) {
        if (null == intent) {
            return defaultValue;
        }
        int ret = defaultValue;
        try {
            ret = intent.getIntExtra(name, defaultValue);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getIntExtra exception:" + e.getMessage()));
            ret = defaultValue;
        }
        return ret;
    }

    public static boolean getBooleanExtra(Intent intent, String name, boolean defaultValue) {
        if (null == intent) {
            return defaultValue;
        }
        boolean ret = defaultValue;
        try {
            ret = intent.getBooleanExtra(name, defaultValue);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getBooleanExtra exception:" + e.getMessage()));
            ret = defaultValue;
        }
        return ret;
    }

    public static long getLongExtra(Intent intent, String name, long defaultValue) {
        if (null == intent) {
            return defaultValue;
        }
        long ret = defaultValue;
        try {
            ret = intent.getLongExtra(name, defaultValue);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getIntExtra exception:" + e.getMessage()));
            ret = defaultValue;
        }
        return ret;
    }
}

