/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.util.Log;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public final class TinkerParallelDexOptimizer {
    private static final String TAG = "Tinker.ParallelDex";
    private static final int DEFAULT_THREAD_COUNT = 2;

    public static boolean optimizeAll(Collection<File> dexFiles, File optimizedDir, ResultCallback cb) {
        return TinkerParallelDexOptimizer.optimizeAll(dexFiles, optimizedDir, false, null, cb);
    }

    public static boolean optimizeAll(Collection<File> dexFiles, File optimizedDir, boolean useInterpretMode, String targetISA, ResultCallback cb) {
        AtomicInteger successCount = new AtomicInteger(0);
        return TinkerParallelDexOptimizer.optimizeAllLocked(dexFiles, optimizedDir, useInterpretMode, targetISA, successCount, cb, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean optimizeAllLocked(Collection<File> dexFiles, File optimizedDir, boolean useInterpretMode, String targetISA, AtomicInteger successCount, ResultCallback cb, int threadCount) {
        CountDownLatch latch = new CountDownLatch(dexFiles.size());
        ExecutorService threadPool = Executors.newFixedThreadPool(threadCount);
        long startTick = System.nanoTime();
        ArrayList<File> sortList = new ArrayList<File>(dexFiles);
        Collections.sort(sortList, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                long diffSize = lhs.length() - rhs.length();
                if (diffSize > 0L) {
                    return 1;
                }
                if (diffSize == 0L) {
                    return 0;
                }
                return -1;
            }
        });
        Collections.reverse(sortList);
        for (File dexFile : sortList) {
            OptimizeWorker worker = new OptimizeWorker(dexFile, optimizedDir, useInterpretMode, targetISA, successCount, latch, cb);
            threadPool.submit(worker);
        }
        try {
            latch.await();
            long timeCost = (System.nanoTime() - startTick) / 1000000L;
            if (successCount.get() == dexFiles.size()) {
                Log.i((String)TAG, (String)("All dexes are optimized successfully, cost: " + timeCost + " ms."));
                boolean bl = true;
                return bl;
            }
            Log.e((String)TAG, (String)"Dexes optimizing failed, some dexes are not optimized.");
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            Log.w((String)TAG, (String)"Dex optimizing was interrupted.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            threadPool.shutdown();
        }
    }

    private static class StreamConsumer {
        static final Executor STREAM_CONSUMER = Executors.newSingleThreadExecutor();

        private StreamConsumer() {
        }

        static void consumeInputStream(final InputStream is) {
            STREAM_CONSUMER.execute(new Runnable(){

                @Override
                public void run() {
                    if (is == null) {
                        return;
                    }
                    byte[] buffer = new byte[256];
                    try {
                        while (is.read(buffer) > 0) {
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    private static class OptimizeWorker
    implements Runnable {
        private static String targetISA = null;
        private final File dexFile;
        private final File optimizedDir;
        private final boolean useInterpretMode;
        private final AtomicInteger successCount;
        private final CountDownLatch waitingLatch;
        private final ResultCallback callback;

        OptimizeWorker(File dexFile, File optimizedDir, boolean useInterpretMode, String targetISA, AtomicInteger successCount, CountDownLatch latch, ResultCallback cb) {
            this.dexFile = dexFile;
            this.optimizedDir = optimizedDir;
            this.useInterpretMode = useInterpretMode;
            this.successCount = successCount;
            this.waitingLatch = latch;
            this.callback = cb;
            OptimizeWorker.targetISA = targetISA;
        }

        @Override
        public void run() {
            try {
                if (!SharePatchFileUtil.isLegalFile(this.dexFile) && this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, new IOException("dex file " + this.dexFile.getAbsolutePath() + " is not exist!"));
                }
                if (this.callback != null) {
                    this.callback.onStart(this.dexFile, this.optimizedDir);
                }
                String optimizedPath = SharePatchFileUtil.optimizedPathFor(this.dexFile, this.optimizedDir);
                if (this.useInterpretMode) {
                    this.interpretDex2Oat(this.dexFile.getAbsolutePath(), optimizedPath);
                } else {
                    DexFile.loadDex((String)this.dexFile.getAbsolutePath(), (String)optimizedPath, (int)0);
                }
                this.successCount.incrementAndGet();
                if (this.callback != null) {
                    this.callback.onSuccess(this.dexFile, this.optimizedDir, new File(optimizedPath));
                }
            }
            catch (Throwable e) {
                Log.e((String)TinkerParallelDexOptimizer.TAG, (String)("Failed to optimize dex: " + this.dexFile.getAbsolutePath()), (Throwable)e);
                if (this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, e);
                }
            }
            finally {
                this.waitingLatch.countDown();
            }
        }

        private void interpretDex2Oat(String dexFilePath, String oatFilePath) throws IOException {
            File oatFile = new File(oatFilePath);
            if (!oatFile.exists()) {
                oatFile.getParentFile().mkdirs();
            }
            ArrayList<String> commandAndParams = new ArrayList<String>();
            commandAndParams.add("dex2oat");
            commandAndParams.add("--dex-file=" + dexFilePath);
            commandAndParams.add("--oat-file=" + oatFilePath);
            commandAndParams.add("--instruction-set=" + targetISA);
            commandAndParams.add("--compiler-filter=interpret-only");
            ProcessBuilder pb = new ProcessBuilder(commandAndParams);
            pb.redirectErrorStream(true);
            Process dex2oatProcess = pb.start();
            StreamConsumer.consumeInputStream(dex2oatProcess.getInputStream());
            StreamConsumer.consumeInputStream(dex2oatProcess.getErrorStream());
            try {
                int ret = dex2oatProcess.waitFor();
                if (ret != 0) {
                    throw new IOException("dex2oat works unsuccessfully, exit code: " + ret);
                }
            }
            catch (InterruptedException e) {
                throw new IOException("dex2oat is interrupted, msg: " + e.getMessage(), e);
            }
        }
    }

    public static interface ResultCallback {
        public void onStart(File var1, File var2);

        public void onSuccess(File var1, File var2, File var3);

        public void onFailed(File var1, File var2, Throwable var3);
    }
}

