/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=14)
class AndroidNClassLoader
extends PathClassLoader {
    private static final String TAG = "Tinker.NClassLoader";
    private static final String CHECK_CLASSLOADER_CLASS = "com.tencent.tinker.loader.TinkerTestAndroidNClassLoader";
    private static ArrayList<DexFile> oldDexFiles = new ArrayList();
    private final PathClassLoader originClassLoader;
    private String applicationClassName;

    private AndroidNClassLoader(String dexPath, PathClassLoader parent, Application application) {
        super(dexPath, parent.getParent());
        this.originClassLoader = parent;
        String name = application.getClass().getName();
        if (name != null && !name.equals("android.app.Application")) {
            this.applicationClassName = name;
        }
    }

    private static AndroidNClassLoader createAndroidNClassLoader(PathClassLoader original, Application application) throws Exception {
        Object[] originDexElements;
        AndroidNClassLoader androidNClassLoader = new AndroidNClassLoader("", original, application);
        Field originPathList = ShareReflectUtil.findField(original, "pathList");
        Object originPathListObject = originPathList.get(original);
        Field originClassloader = ShareReflectUtil.findField(originPathListObject, "definingContext");
        originClassloader.set(originPathListObject, (Object)androidNClassLoader);
        Field pathListField = ShareReflectUtil.findField((Object)androidNClassLoader, "pathList");
        pathListField.set((Object)androidNClassLoader, originPathListObject);
        ArrayList<File> additionalClassPathEntries = new ArrayList<File>();
        Field dexElement = ShareReflectUtil.findField(originPathListObject, "dexElements");
        for (Object element : originDexElements = (Object[])dexElement.get(originPathListObject)) {
            DexFile dexFile = (DexFile)ShareReflectUtil.findField(element, "dexFile").get(element);
            if (dexFile == null) continue;
            additionalClassPathEntries.add(new File(dexFile.getName()));
            oldDexFiles.add(dexFile);
        }
        Method makePathElements = ShareReflectUtil.findMethod(originPathListObject, "makePathElements", List.class, File.class, List.class);
        ArrayList suppressedExceptions = new ArrayList();
        Object[] newDexElements = (Object[])makePathElements.invoke(originPathListObject, additionalClassPathEntries, null, suppressedExceptions);
        dexElement.set(originPathListObject, newDexElements);
        try {
            Class.forName(CHECK_CLASSLOADER_CLASS, true, (ClassLoader)((Object)androidNClassLoader));
        }
        catch (Throwable thr) {
            Log.e((String)TAG, (String)"load TinkerTestAndroidNClassLoader fail, try to fixDexElementsForProtectedApp");
            AndroidNClassLoader.fixDexElementsForProtectedApp(application, newDexElements);
        }
        return androidNClassLoader;
    }

    private static void reflectPackageInfoClassloader(Application application, ClassLoader reflectClassLoader) throws Exception {
        String defBase = "mBase";
        String defPackageInfo = "mPackageInfo";
        String defClassLoader = "mClassLoader";
        Context baseContext = (Context)ShareReflectUtil.findField(application, defBase).get(application);
        Object basePackageInfo = ShareReflectUtil.findField(baseContext, defPackageInfo).get(baseContext);
        Field classLoaderField = ShareReflectUtil.findField(basePackageInfo, defClassLoader);
        Thread.currentThread().setContextClassLoader(reflectClassLoader);
        classLoaderField.set(basePackageInfo, reflectClassLoader);
    }

    public static AndroidNClassLoader inject(PathClassLoader originClassLoader, Application application) throws Exception {
        AndroidNClassLoader classLoader = AndroidNClassLoader.createAndroidNClassLoader(originClassLoader, application);
        AndroidNClassLoader.reflectPackageInfoClassloader(application, (ClassLoader)((Object)classLoader));
        return classLoader;
    }

    private static void fixDexElementsForProtectedApp(Application application, Object[] newDexElements) throws Exception {
        Field zipField = null;
        Field dexFileField = null;
        Field mFileNameField = ShareReflectUtil.findField(DexFile.class, "mFileName");
        Field mCookieField = ShareReflectUtil.findField(DexFile.class, "mCookie");
        Field mInternalCookieField = ShareReflectUtil.findField(DexFile.class, "mInternalCookie");
        for (int i = 0; i < newDexElements.length - 1; ++i) {
            String newZipPath;
            Object newElement = newDexElements[i];
            if (zipField == null && dexFileField == null) {
                zipField = ShareReflectUtil.findField(newElement, "zip");
                dexFileField = ShareReflectUtil.findField(newElement, "dexFile");
            }
            DexFile origDexFile = oldDexFiles.get(i);
            String origFileName = (String)mFileNameField.get(origDexFile);
            Object origCookie = mCookieField.get(origDexFile);
            Object origInternalCookie = mInternalCookieField.get(origDexFile);
            DexFile dupOrigDexFile = DexFile.loadDex((String)application.getApplicationInfo().sourceDir, null, (int)0);
            mFileNameField.set(dupOrigDexFile, origFileName);
            mCookieField.set(dupOrigDexFile, origCookie);
            mInternalCookieField.set(dupOrigDexFile, origInternalCookie);
            dexFileField.set(newElement, dupOrigDexFile);
            File newZip = (File)zipField.get(newElement);
            String string = newZipPath = newZip != null ? newZip.getAbsolutePath() : null;
            if (newZipPath == null || newZipPath.endsWith(".zip") || newZipPath.endsWith(".jar") || newZipPath.endsWith(".apk")) continue;
            zipField.set(newElement, null);
        }
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (name != null && name.startsWith("com.tencent.tinker.loader.") && !name.equals("com.tencent.tinker.loader.TinkerTestDexLoad") && !name.equals(CHECK_CLASSLOADER_CLASS) || this.applicationClassName != null && TextUtils.equals((CharSequence)this.applicationClassName, (CharSequence)name)) {
            return this.originClassLoader.loadClass(name);
        }
        return super.findClass(name);
    }

    public String findLibrary(String name) {
        return super.findLibrary(name);
    }
}

