/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.os.Process;
import android.util.Log;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class TinkerUncaughtHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "Tinker.UncaughtHandler";
    private final File crashFile;
    private final Context context;
    private final Thread.UncaughtExceptionHandler ueh;

    public TinkerUncaughtHandler(Context context) {
        this.context = context;
        this.ueh = Thread.getDefaultUncaughtExceptionHandler();
        this.crashFile = SharePatchFileUtil.getPatchLastCrashFile(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        block5: {
            Thread.UncaughtExceptionHandler handler;
            Log.e((String)TAG, (String)("catch exception when loading tinker:" + Log.getStackTraceString((Throwable)ex)));
            this.ueh.uncaughtException(thread, ex);
            if (this.crashFile == null || !((handler = Thread.getDefaultUncaughtExceptionHandler()) instanceof TinkerUncaughtHandler)) break block5;
            File parentFile = this.crashFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                Log.e((String)TAG, (String)"print crash file error: create directory fail!");
                return;
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(this.crashFile, false));
                pw.println("process:" + ShareTinkerInternals.getProcessName(this.context));
                pw.println(ShareTinkerInternals.getExceptionCauseString(ex));
            }
            catch (IOException e) {
                try {
                    Log.e((String)TAG, (String)("print crash file error:" + Log.getStackTraceString((Throwable)e)));
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(pw);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(pw);
            }
            SharePatchFileUtil.closeQuietly(pw);
            Process.killProcess((int)Process.myPid());
        }
    }
}

