/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Build;
import android.util.Log;
import com.tencent.tinker.loader.AndroidNClassLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public class SystemClassLoaderAdder {
    public static final String CHECK_DEX_CLASS = "com.tencent.tinker.loader.TinkerTestDexLoad";
    public static final String CHECK_DEX_FIELD = "isPatch";
    private static final String TAG = "Tinker.ClassLoaderAdder";
    private static int sPatchDexCount = 0;

    @SuppressLint(value={"NewApi"})
    public static void installDexes(Application application, PathClassLoader loader, File dexOptDir, List<File> files) throws Throwable {
        Log.i((String)TAG, (String)("installDexes dexOptDir: " + dexOptDir.getAbsolutePath() + ", dex size:" + files.size()));
        if (!files.isEmpty()) {
            files = SystemClassLoaderAdder.createSortedAdditionalPathEntries(files);
            PathClassLoader classLoader = loader;
            if (Build.VERSION.SDK_INT >= 24 && !SystemClassLoaderAdder.checkIsProtectedApp(files)) {
                classLoader = AndroidNClassLoader.inject(loader, application);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                V23.install((ClassLoader)classLoader, files, dexOptDir);
            } else if (Build.VERSION.SDK_INT >= 19) {
                V19.install((ClassLoader)classLoader, files, dexOptDir);
            } else if (Build.VERSION.SDK_INT >= 14) {
                V14.install((ClassLoader)classLoader, files, dexOptDir);
            } else {
                V4.install((ClassLoader)classLoader, files, dexOptDir);
            }
            sPatchDexCount = files.size();
            Log.i((String)TAG, (String)("after loaded classloader: " + classLoader + ", dex size:" + sPatchDexCount));
            if (!SystemClassLoaderAdder.checkDexInstall((ClassLoader)classLoader)) {
                SystemClassLoaderAdder.uninstallPatchDex((ClassLoader)classLoader);
                throw new TinkerRuntimeException("checkDexInstall failed");
            }
        }
    }

    public static void uninstallPatchDex(ClassLoader classLoader) throws Throwable {
        if (sPatchDexCount <= 0) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            Field pathListField = ShareReflectUtil.findField(classLoader, "pathList");
            Object dexPathList = pathListField.get(classLoader);
            ShareReflectUtil.reduceFieldArray(dexPathList, "dexElements", sPatchDexCount);
        } else {
            ShareReflectUtil.reduceFieldArray(classLoader, "mPaths", sPatchDexCount);
            ShareReflectUtil.reduceFieldArray(classLoader, "mFiles", sPatchDexCount);
            ShareReflectUtil.reduceFieldArray(classLoader, "mZips", sPatchDexCount);
            try {
                ShareReflectUtil.reduceFieldArray(classLoader, "mDexs", sPatchDexCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean checkDexInstall(ClassLoader classLoader) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = Class.forName(CHECK_DEX_CLASS, true, classLoader);
        Field filed = ShareReflectUtil.findField(clazz, CHECK_DEX_FIELD);
        boolean isPatch = (Boolean)filed.get(null);
        Log.w((String)TAG, (String)("checkDexInstall result:" + isPatch));
        return isPatch;
    }

    private static boolean checkIsProtectedApp(List<File> files) {
        if (!files.isEmpty()) {
            for (File file : files) {
                if (file == null || !file.getName().startsWith("changed_classes.dex")) continue;
                return true;
            }
        }
        return false;
    }

    private static List<File> createSortedAdditionalPathEntries(List<File> additionalPathEntries) {
        ArrayList<File> result = new ArrayList<File>(additionalPathEntries);
        Pattern classNPattern = Pattern.compile("classes(?:[2-9]{0,1}|[1-9][0-9]+)\\.dex");
        final HashMap<String, Boolean> matchesClassNPatternMemo = new HashMap<String, Boolean>();
        for (File file : result) {
            String name = file.getName();
            matchesClassNPatternMemo.put(name, classNPattern.matcher(name).matches());
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                String rhsName;
                if (lhs == null && rhs == null) {
                    return 0;
                }
                if (lhs == null) {
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                String lhsName = lhs.getName();
                if (lhsName.equals(rhsName = rhs.getName())) {
                    return 0;
                }
                String testDexSuffix = "test.dex";
                if (lhsName.startsWith("test.dex")) {
                    return 1;
                }
                if (rhsName.startsWith("test.dex")) {
                    return -1;
                }
                boolean isLhsNameMatchClassN = (Boolean)matchesClassNPatternMemo.get(lhsName);
                boolean isRhsNameMatchClassN = (Boolean)matchesClassNPatternMemo.get(rhsName);
                if (isLhsNameMatchClassN && isRhsNameMatchClassN) {
                    int rhsId;
                    int lhsDotPos = lhsName.lastIndexOf(46);
                    int rhsDotPos = rhsName.lastIndexOf(46);
                    int lhsId = lhsDotPos > 7 ? Integer.parseInt(lhsName.substring(7, lhsDotPos)) : 1;
                    int n = rhsId = rhsDotPos > 7 ? Integer.parseInt(rhsName.substring(7, rhsDotPos)) : 1;
                    return lhsId == rhsId ? 0 : (lhsId < rhsId ? -1 : 1);
                }
                if (isLhsNameMatchClassN) {
                    return -1;
                }
                if (isRhsNameMatchClassN) {
                    return 1;
                }
                return lhsName.compareTo(rhsName);
            }
        });
        return result;
    }

    private static final class V4 {
        private V4() {
        }

        private static void install(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, IOException {
            int extraSize = additionalClassPathEntries.size();
            Field pathField = ShareReflectUtil.findField(loader, "path");
            StringBuilder path = new StringBuilder((String)pathField.get(loader));
            Object[] extraPaths = new String[extraSize];
            Object[] extraFiles = new File[extraSize];
            Object[] extraZips = new ZipFile[extraSize];
            Object[] extraDexs = new DexFile[extraSize];
            ListIterator<File> iterator = additionalClassPathEntries.listIterator();
            while (iterator.hasNext()) {
                File additionalEntry = iterator.next();
                String entryPath = additionalEntry.getAbsolutePath();
                path.append(':').append(entryPath);
                int index = iterator.previousIndex();
                extraPaths[index] = entryPath;
                extraFiles[index] = additionalEntry;
                extraZips[index] = new ZipFile(additionalEntry);
                String outputPathName = SharePatchFileUtil.optimizedPathFor(additionalEntry, optimizedDirectory);
                extraDexs[index] = DexFile.loadDex((String)entryPath, (String)outputPathName, (int)0);
            }
            pathField.set(loader, path.toString());
            ShareReflectUtil.expandFieldArray(loader, "mPaths", extraPaths);
            ShareReflectUtil.expandFieldArray(loader, "mFiles", extraFiles);
            ShareReflectUtil.expandFieldArray(loader, "mZips", extraZips);
            try {
                ShareReflectUtil.expandFieldArray(loader, "mDexs", extraDexs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class V14 {
        private V14() {
        }

        private static void install(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
            Field pathListField = ShareReflectUtil.findField(loader, "pathList");
            Object dexPathList = pathListField.get(loader);
            ShareReflectUtil.expandFieldArray(dexPathList, "dexElements", V14.makeDexElements(dexPathList, new ArrayList<File>(additionalClassPathEntries), optimizedDirectory));
        }

        private static Object[] makeDexElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Method makeDexElements = ShareReflectUtil.findMethod(dexPathList, "makeDexElements", ArrayList.class, File.class);
            return (Object[])makeDexElements.invoke(dexPathList, files, optimizedDirectory);
        }
    }

    private static final class V19 {
        private V19() {
        }

        private static void install(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IOException {
            Iterator<IOException> iterator;
            Field pathListField = ShareReflectUtil.findField(loader, "pathList");
            Object dexPathList = pathListField.get(loader);
            ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
            ShareReflectUtil.expandFieldArray(dexPathList, "dexElements", V19.makeDexElements(dexPathList, new ArrayList<File>(additionalClassPathEntries), optimizedDirectory, suppressedExceptions));
            if (suppressedExceptions.size() > 0 && (iterator = suppressedExceptions.iterator()).hasNext()) {
                IOException e = iterator.next();
                Log.w((String)SystemClassLoaderAdder.TAG, (String)"Exception in makeDexElement", (Throwable)e);
                throw e;
            }
        }

        private static Object[] makeDexElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory, ArrayList<IOException> suppressedExceptions) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Method makeDexElements = null;
            try {
                makeDexElements = ShareReflectUtil.findMethod(dexPathList, "makeDexElements", ArrayList.class, File.class, ArrayList.class);
            }
            catch (NoSuchMethodException e) {
                Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makeDexElements(ArrayList,File,ArrayList) failure");
                try {
                    makeDexElements = ShareReflectUtil.findMethod(dexPathList, "makeDexElements", List.class, File.class, List.class);
                }
                catch (NoSuchMethodException e1) {
                    Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makeDexElements(List,File,List) failure");
                    throw e1;
                }
            }
            return (Object[])makeDexElements.invoke(dexPathList, files, optimizedDirectory, suppressedExceptions);
        }
    }

    private static final class V23 {
        private V23() {
        }

        private static void install(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IOException {
            Iterator<IOException> iterator;
            Field pathListField = ShareReflectUtil.findField(loader, "pathList");
            Object dexPathList = pathListField.get(loader);
            ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
            ShareReflectUtil.expandFieldArray(dexPathList, "dexElements", V23.makePathElements(dexPathList, new ArrayList<File>(additionalClassPathEntries), optimizedDirectory, suppressedExceptions));
            if (suppressedExceptions.size() > 0 && (iterator = suppressedExceptions.iterator()).hasNext()) {
                IOException e = iterator.next();
                Log.w((String)SystemClassLoaderAdder.TAG, (String)"Exception in makePathElement", (Throwable)e);
                throw e;
            }
        }

        private static Object[] makePathElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory, ArrayList<IOException> suppressedExceptions) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Method makePathElements;
            try {
                makePathElements = ShareReflectUtil.findMethod(dexPathList, "makePathElements", List.class, File.class, List.class);
            }
            catch (NoSuchMethodException e) {
                Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makePathElements(List,File,List) failure");
                try {
                    makePathElements = ShareReflectUtil.findMethod(dexPathList, "makePathElements", ArrayList.class, File.class, ArrayList.class);
                }
                catch (NoSuchMethodException e1) {
                    Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makeDexElements(ArrayList,File,ArrayList) failure");
                    try {
                        Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: try use v19 instead");
                        return V19.makeDexElements(dexPathList, files, optimizedDirectory, suppressedExceptions);
                    }
                    catch (NoSuchMethodException e2) {
                        Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makeDexElements(List,File,List) failure");
                        throw e2;
                    }
                }
            }
            return (Object[])makePathElements.invoke(dexPathList, files, optimizedDirectory, suppressedExceptions);
        }
    }
}

