/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import com.tencent.tinker.commons.dexpatcher.DexPatchApplier;
import com.tencent.tinker.commons.util.DigestUtil;
import com.tencent.tinker.commons.util.IOHelper;
import com.tencent.tinker.lib.patch.BasePatchInternal;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerDexOptimizer;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareConstants;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareElfFile;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.ziputils.ziputil.AlignedZipOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DexDiffPatchInternal
extends BasePatchInternal {
    protected static final String TAG = "Tinker.DexDiffPatchInternal";
    protected static final int WAIT_ASYN_OAT_TIME = 10000;
    protected static final int MAX_WAIT_COUNT = 120;
    private static ArrayList<File> optFiles = new ArrayList();
    private static ArrayList<ShareDexDiffPatchInfo> patchList = new ArrayList();
    private static HashMap<ShareDexDiffPatchInfo, File> classNDexInfo = new HashMap();
    private static boolean isVmArt = ShareTinkerInternals.isVmArt();

    protected static boolean tryRecoverDexFiles(Tinker manager, ShareSecurityCheck checker, Context context, String patchVersionDirectory, File patchFile) {
        if (!manager.isEnabledForDex()) {
            TinkerLog.w(TAG, "patch recover, dex is not enabled", new Object[0]);
            return true;
        }
        String dexMeta = (String)checker.getMetaContentMap().get("assets/dex_meta.txt");
        if (dexMeta == null) {
            TinkerLog.w(TAG, "patch recover, dex is not contained", new Object[0]);
            return true;
        }
        long begin = SystemClock.elapsedRealtime();
        boolean result = DexDiffPatchInternal.patchDexExtractViaDexDiff(context, patchVersionDirectory, dexMeta, patchFile);
        long cost = SystemClock.elapsedRealtime() - begin;
        TinkerLog.i(TAG, "recover dex result:%b, cost:%d", result, cost);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean waitAndCheckDexOptFile(File patchFile, Tinker manager) {
        if (optFiles.isEmpty()) {
            return true;
        }
        int size = patchList.size() * 30;
        if (size > 120) {
            size = 120;
        }
        TinkerLog.i(TAG, "raw dex count: %d, dex opt dex count: %d, final wait times: %d", patchList.size(), optFiles.size(), size);
        for (int i = 0; i < size; ++i) {
            if (DexDiffPatchInternal.checkAllDexOptFile(optFiles, i + 1)) continue;
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                TinkerLog.e(TAG, "thread sleep InterruptedException e:" + e, new Object[0]);
            }
        }
        ArrayList<File> failDexFiles = new ArrayList<File>();
        for (File file : optFiles) {
            TinkerLog.i(TAG, "check dex optimizer file exist: %s, size %d", file.getPath(), file.length());
            if (SharePatchFileUtil.isLegalFile((File)file) || SharePatchFileUtil.shouldAcceptEvenIfIllegal((File)file)) continue;
            TinkerLog.e(TAG, "final parallel dex optimizer file %s is not exist, return false", file.getName());
            failDexFiles.add(file);
        }
        if (!failDexFiles.isEmpty()) {
            manager.getPatchReporter().onPatchDexOptFail(patchFile, failDexFiles, (Throwable)new TinkerRuntimeException("checkDexOptExist failed"));
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Throwable lastThrowable = null;
            for (File file : optFiles) {
                int returnType;
                if (SharePatchFileUtil.shouldAcceptEvenIfIllegal((File)file)) continue;
                TinkerLog.i(TAG, "check dex optimizer file format: %s, size %d", file.getName(), file.length());
                try {
                    returnType = ShareElfFile.getFileTypeByMagic((File)file);
                }
                catch (IOException e) {
                    continue;
                }
                if (returnType != 1) continue;
                ShareElfFile elfFile = null;
                try {
                    elfFile = new ShareElfFile(file);
                }
                catch (Throwable e) {
                    try {
                        TinkerLog.e(TAG, "final parallel dex optimizer file %s is not elf format, return false", file.getName());
                        failDexFiles.add(file);
                        lastThrowable = e;
                    }
                    catch (Throwable throwable) {
                        IOHelper.closeQuietly(elfFile);
                        throw throwable;
                    }
                    IOHelper.closeQuietly((Object)elfFile);
                    continue;
                }
                IOHelper.closeQuietly((Object)elfFile);
            }
            if (!failDexFiles.isEmpty()) {
                TinkerRuntimeException tinkerRuntimeException = lastThrowable == null ? new TinkerRuntimeException("checkDexOptFormat failed") : new TinkerRuntimeException("checkDexOptFormat failed", lastThrowable);
                manager.getPatchReporter().onPatchDexOptFail(patchFile, failDexFiles, (Throwable)tinkerRuntimeException);
                return false;
            }
        }
        return true;
    }

    private static boolean patchDexExtractViaDexDiff(Context context, String patchVersionDirectory, String meta, File patchFile) {
        String dir = patchVersionDirectory + "/" + "dex" + "/";
        if (!DexDiffPatchInternal.extractDexDiffInternals(context, dir, meta, patchFile, 3)) {
            TinkerLog.w(TAG, "patch recover, extractDiffInternals fail", new Object[0]);
            return false;
        }
        File dexFiles = new File(dir);
        File[] files = dexFiles.listFiles();
        ArrayList<File> legalFiles = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!file.isFile() || !fileName.endsWith(".dex") && !fileName.endsWith(".jar") && !fileName.endsWith(".apk")) continue;
                legalFiles.add(file);
            }
        }
        TinkerLog.i(TAG, "legal files to do dexopt: " + legalFiles, new Object[0]);
        String optimizeDexDirectory = patchVersionDirectory + "/" + "odex" + "/";
        return DexDiffPatchInternal.dexOptimizeDexFiles(context, legalFiles, optimizeDexDirectory, patchFile);
    }

    private static boolean checkClassNDexFiles(String dexFilePath) {
        if (patchList.isEmpty() || !isVmArt) {
            return false;
        }
        ShareDexDiffPatchInfo testInfo = null;
        File testFile = null;
        for (ShareDexDiffPatchInfo info : patchList) {
            File dexFile = new File(dexFilePath + info.realName);
            String fileName = dexFile.getName();
            if (ShareConstants.CLASS_N_PATTERN.matcher(fileName).matches()) {
                classNDexInfo.put(info, dexFile);
            }
            if (!info.rawName.startsWith("test.dex")) continue;
            testInfo = info;
            testFile = dexFile;
        }
        if (testInfo != null) {
            classNDexInfo.put(ShareTinkerInternals.changeTestDexToClassN(testInfo, (int)(classNDexInfo.size() + 1)), testFile);
        }
        File classNFile = new File(dexFilePath, "tinker_classN.apk");
        boolean result = true;
        if (classNFile.exists()) {
            for (ShareDexDiffPatchInfo info : classNDexInfo.keySet()) {
                if (SharePatchFileUtil.verifyDexFileMd5((File)classNFile, (String)info.rawName, (String)info.destMd5InArt)) continue;
                TinkerLog.e(TAG, "verify dex file md5 error, entry name; %s, file len: %d", info.rawName, classNFile.length());
                result = false;
                break;
            }
            if (!result) {
                SharePatchFileUtil.safeDeleteFile((File)classNFile);
            }
        } else {
            result = false;
        }
        if (result) {
            for (File dexFile : classNDexInfo.values()) {
                SharePatchFileUtil.safeDeleteFile((File)dexFile);
            }
        }
        return result;
    }

    private static ZipEntry makeStoredZipEntry(ZipEntry originalEntry, String realDexName) {
        ZipEntry result = new ZipEntry(realDexName);
        result.setMethod(0);
        result.setCompressedSize(originalEntry.getSize());
        result.setSize(originalEntry.getSize());
        result.setCrc(originalEntry.getCrc());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean mergeClassNDexFiles(Context context, File patchFile, String dexFilePath) {
        if (DexDiffPatchInternal.patchList.isEmpty() || !DexDiffPatchInternal.isVmArt) {
            return true;
        }
        classNFile = new File(dexFilePath, "tinker_classN.apk");
        if (DexDiffPatchInternal.classNDexInfo.isEmpty()) {
            TinkerLog.w("Tinker.DexDiffPatchInternal", "classNDexInfo size: %d, no need to merge classN dex files", new Object[]{DexDiffPatchInternal.classNDexInfo.size()});
            return true;
        }
        start = System.currentTimeMillis();
        result = true;
        out = null;
        try {
            out = new AlignedZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(classNFile)));
            for (ShareDexDiffPatchInfo info : DexDiffPatchInternal.classNDexInfo.keySet()) {
                dexFile = DexDiffPatchInternal.classNDexInfo.get(info);
                if (info.isJarMode) {
                    dexZipFile = null;
                    inputStream = null;
                    try {
                        dexZipFile = new ZipFile(dexFile);
                        rawDexZipEntry = dexZipFile.getEntry("classes.dex");
                        newDexZipEntry = DexDiffPatchInternal.makeStoredZipEntry(rawDexZipEntry, info.rawName);
                        inputStream = dexZipFile.getInputStream(rawDexZipEntry);
                        try {
                            out.putNextEntry(newDexZipEntry);
                            IOHelper.copyStream((InputStream)inputStream, (OutputStream)out);
                        }
                        finally {
                            out.closeEntry();
                        }
                    }
                    catch (Throwable var16_16) {
                        IOHelper.closeQuietly(inputStream);
                        IOHelper.closeQuietly((Object)dexZipFile);
                        throw var16_16;
                    }
                    IOHelper.closeQuietly((Object)inputStream);
                    IOHelper.closeQuietly((Object)dexZipFile);
                    continue;
                }
                newDexZipEntry = new ZipEntry(info.rawName);
                newDexZipEntry.setMethod(0);
                newDexZipEntry.setCompressedSize(dexFile.length());
                newDexZipEntry.setSize(dexFile.length());
                newDexZipEntry.setCrc(DigestUtil.getCRC32((File)dexFile));
                is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(dexFile));
                    try {
                        out.putNextEntry(newDexZipEntry);
                        IOHelper.copyStream((InputStream)is, (OutputStream)out);
                    }
                    finally {
                        out.closeEntry();
                    }
                }
                catch (Throwable var18_18) {
                    IOHelper.closeQuietly(is);
                    throw var18_18;
                }
                IOHelper.closeQuietly((Object)is);
            }
            ** GOTO lbl67
        }
        catch (Throwable throwable) {
            try {
                TinkerLog.printErrStackTrace("Tinker.DexDiffPatchInternal", throwable, "merge classN file", new Object[0]);
                result = false;
            }
            catch (Throwable var19_19) {
                IOHelper.closeQuietly(out);
                throw var19_19;
            }
lbl67:
            // 1 sources

            IOHelper.closeQuietly((Object)out);
            IOHelper.closeQuietly((Object)out);
        }
        if (result) {
            for (ShareDexDiffPatchInfo info : DexDiffPatchInternal.classNDexInfo.keySet()) {
                if (SharePatchFileUtil.verifyDexFileMd5((File)classNFile, (String)info.rawName, (String)info.destMd5InArt)) continue;
                result = false;
                TinkerLog.e("Tinker.DexDiffPatchInternal", "verify dex file md5 error, entry name; %s, file len: %d", new Object[]{info.rawName, classNFile.length()});
                break;
            }
        }
        if (result) {
            for (File dexFile : DexDiffPatchInternal.classNDexInfo.values()) {
                SharePatchFileUtil.safeDeleteFile((File)dexFile);
            }
        } else {
            TinkerLog.e("Tinker.DexDiffPatchInternal", "merge classN dex error, try delete temp file", new Object[0]);
            SharePatchFileUtil.safeDeleteFile((File)classNFile);
            Tinker.with(context).getPatchReporter().onPatchTypeExtractFail(patchFile, classNFile, classNFile.getName(), 7);
        }
        TinkerLog.i("Tinker.DexDiffPatchInternal", "merge classN dex file %s, result: %b, size: %d, use: %dms", new Object[]{classNFile.getPath(), result, classNFile.length(), System.currentTimeMillis() - start});
        return result;
    }

    private static boolean dexOptimizeDexFiles(Context context, List<File> dexFiles, String optimizeDexDirectory, File patchFile) {
        Tinker manager = Tinker.with(context);
        optFiles.clear();
        if (dexFiles != null) {
            File optimizeDexDirectoryFile = new File(optimizeDexDirectory);
            if (!optimizeDexDirectoryFile.exists() && !optimizeDexDirectoryFile.mkdirs()) {
                TinkerLog.w(TAG, "patch recover, make optimizeDexDirectoryFile fail", new Object[0]);
                return false;
            }
            for (File file : dexFiles) {
                String outputPathName = SharePatchFileUtil.optimizedPathFor((File)file, (File)optimizeDexDirectoryFile);
                optFiles.add(new File(outputPathName));
            }
            TinkerLog.i(TAG, "patch recover, try to optimize dex file count:%d, optimizeDexDirectory:%s", dexFiles.size(), optimizeDexDirectory);
            final Vector<File> failOptDexFile = new Vector<File>();
            final Throwable[] throwable = new Throwable[1];
            TinkerDexOptimizer.optimizeAll((Context)context, dexFiles, (File)optimizeDexDirectoryFile, (TinkerDexOptimizer.ResultCallback)new TinkerDexOptimizer.ResultCallback(){
                long startTime;

                public void onStart(File dexFile, File optimizedDir) {
                    this.startTime = System.currentTimeMillis();
                    TinkerLog.i(DexDiffPatchInternal.TAG, "start to parallel optimize dex %s, size: %d", dexFile.getPath(), dexFile.length());
                }

                public void onSuccess(File dexFile, File optimizedDir, File optimizedFile) {
                    TinkerLog.i(DexDiffPatchInternal.TAG, "success to parallel optimize dex %s, opt file:%s, opt file size: %d, use time %d", dexFile.getPath(), optimizedFile.getPath(), optimizedFile.length(), System.currentTimeMillis() - this.startTime);
                }

                public void onFailed(File dexFile, File optimizedDir, Throwable thr) {
                    TinkerLog.i(DexDiffPatchInternal.TAG, "fail to parallel optimize dex %s use time %d", dexFile.getPath(), System.currentTimeMillis() - this.startTime);
                    failOptDexFile.add(dexFile);
                    throwable[0] = thr;
                }
            });
            if (!failOptDexFile.isEmpty()) {
                manager.getPatchReporter().onPatchDexOptFail(patchFile, failOptDexFile, throwable[0]);
                return false;
            }
        }
        return true;
    }

    private static boolean checkAllDexOptFile(ArrayList<File> files, int count) {
        for (File file : files) {
            if (SharePatchFileUtil.isLegalFile((File)file) || SharePatchFileUtil.shouldAcceptEvenIfIllegal((File)file)) continue;
            TinkerLog.e(TAG, "parallel dex optimizer file %s is not exist, just wait %d times", file.getName(), count);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private static boolean extractDexDiffInternals(Context context, String dir, String meta, File patchFile, int type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractDexToJar(ZipFile zipFile, ZipEntry entryFile, File extractTo, String targetMd5) throws IOException {
        int numAttempts = 0;
        boolean isExtractionSuccessful = false;
        while (numAttempts < 2 && !isExtractionSuccessful) {
            boolean succ;
            ++numAttempts;
            ZipOutputStream zos = null;
            BufferedInputStream bis = null;
            TinkerLog.i(TAG, "try Extracting " + extractTo.getPath(), new Object[0]);
            try {
                zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(extractTo)));
                bis = new BufferedInputStream(zipFile.getInputStream(entryFile));
                byte[] buffer = new byte[16384];
                ZipEntry entry = new ZipEntry("classes.dex");
                zos.putNextEntry(entry);
                int length = bis.read(buffer);
                while (length != -1) {
                    zos.write(buffer, 0, length);
                    length = bis.read(buffer);
                }
                zos.closeEntry();
            }
            catch (Throwable throwable) {
                IOHelper.closeQuietly(bis);
                IOHelper.closeQuietly(zos);
                throw throwable;
            }
            IOHelper.closeQuietly((Object)bis);
            IOHelper.closeQuietly((Object)zos);
            isExtractionSuccessful = SharePatchFileUtil.verifyDexFileMd5((File)extractTo, (String)targetMd5);
            TinkerLog.i(TAG, "isExtractionSuccessful: %b", isExtractionSuccessful);
            if (isExtractionSuccessful || (succ = extractTo.delete()) && !extractTo.exists()) continue;
            TinkerLog.e(TAG, "Failed to delete corrupted dex " + extractTo.getPath(), new Object[0]);
        }
        return isExtractionSuccessful;
    }

    private static boolean extractDexFile(ZipFile zipFile, ZipEntry entryFile, File extractTo, ShareDexDiffPatchInfo dexInfo) throws IOException {
        String fileMd5 = isVmArt ? dexInfo.destMd5InArt : dexInfo.destMd5InDvm;
        String rawName = dexInfo.rawName;
        boolean isJarMode = dexInfo.isJarMode;
        if (SharePatchFileUtil.isRawDexFile((String)rawName) && isJarMode) {
            return DexDiffPatchInternal.extractDexToJar(zipFile, entryFile, extractTo, fileMd5);
        }
        return DexDiffPatchInternal.extract(zipFile, entryFile, extractTo, fileMd5, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchDexFile(ZipFile baseApk, ZipFile patchPkg, ZipEntry oldDexEntry, ZipEntry patchFileEntry, ShareDexDiffPatchInfo patchInfo, File patchedDexFile) throws IOException {
        BufferedInputStream patchFileStream;
        BufferedInputStream oldDexStream;
        block8: {
            oldDexStream = null;
            patchFileStream = null;
            try {
                block9: {
                    oldDexStream = new BufferedInputStream(baseApk.getInputStream(oldDexEntry));
                    patchFileStream = patchFileEntry != null ? new BufferedInputStream(patchPkg.getInputStream(patchFileEntry)) : null;
                    boolean isRawDexFile = SharePatchFileUtil.isRawDexFile((String)patchInfo.rawName);
                    if (isRawDexFile && !patchInfo.isJarMode) break block9;
                    ZipOutputStream zos = null;
                    try {
                        block11: {
                            block10: {
                                zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(patchedDexFile)));
                                zos.putNextEntry(new ZipEntry("classes.dex"));
                                if (isRawDexFile) break block10;
                                ZipInputStream zis = null;
                                try {
                                    ZipEntry entry;
                                    zis = new ZipInputStream(oldDexStream);
                                    while ((entry = zis.getNextEntry()) != null && !"classes.dex".equals(entry.getName())) {
                                    }
                                    if (entry == null) {
                                        throw new TinkerRuntimeException("can't recognize zip dex format file:" + patchedDexFile.getAbsolutePath());
                                    }
                                    new DexPatchApplier((InputStream)zis, (InputStream)patchFileStream).executeAndSaveTo((OutputStream)zos);
                                }
                                catch (Throwable throwable) {
                                    IOHelper.closeQuietly(zis);
                                    throw throwable;
                                }
                                IOHelper.closeQuietly((Object)zis);
                                break block11;
                            }
                            new DexPatchApplier((InputStream)oldDexStream, (InputStream)patchFileStream).executeAndSaveTo((OutputStream)zos);
                        }
                        zos.closeEntry();
                    }
                    catch (Throwable throwable) {
                        IOHelper.closeQuietly(zos);
                        throw throwable;
                    }
                    IOHelper.closeQuietly((Object)zos);
                    break block8;
                }
                new DexPatchApplier((InputStream)oldDexStream, (InputStream)patchFileStream).executeAndSaveTo(patchedDexFile);
            }
            catch (Throwable throwable) {
                IOHelper.closeQuietly(oldDexStream);
                IOHelper.closeQuietly(patchFileStream);
                throw throwable;
            }
        }
        IOHelper.closeQuietly((Object)oldDexStream);
        IOHelper.closeQuietly((Object)patchFileStream);
    }
}

