/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.listener;

import android.content.Context;
import com.tencent.tinker.lib.listener.PatchListener;
import com.tencent.tinker.lib.service.TinkerPatchService;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.lib.util.UpgradePatchRetry;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class DefaultPatchListener
implements PatchListener {
    protected final Context context;

    public DefaultPatchListener(Context context) {
        this.context = context;
    }

    @Override
    public int onPatchReceived(String path) {
        File patchFile = new File(path);
        int returnCode = this.patchCheck(path, SharePatchFileUtil.getMD5((File)patchFile));
        if (returnCode == 0) {
            TinkerPatchService.runPatchService(this.context, path);
        } else {
            Tinker.with(this.context).getLoadReporter().onLoadPatchListenerReceiveFail(new File(path), returnCode);
        }
        return returnCode;
    }

    protected int patchCheck(String path, String patchMd5) {
        String currentVersion;
        TinkerLoadResult tinkerLoadResult;
        Tinker manager = Tinker.with(this.context);
        if (!manager.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences((Context)this.context)) {
            return -1;
        }
        File file = new File(path);
        if (!SharePatchFileUtil.isLegalFile((File)file)) {
            return -2;
        }
        if (manager.isPatchProcess()) {
            return -4;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning(this.context)) {
            return -3;
        }
        if (ShareTinkerInternals.isVmJit()) {
            return -5;
        }
        Tinker tinker = Tinker.with(this.context);
        if (tinker.isTinkerLoaded() && (tinkerLoadResult = tinker.getTinkerLoadResultIfPresent()) != null && !tinkerLoadResult.useInterpretMode && patchMd5.equals(currentVersion = tinkerLoadResult.currentVersion)) {
            return -6;
        }
        if (!UpgradePatchRetry.getInstance(this.context).onPatchListenerCheck(patchMd5)) {
            return -7;
        }
        return 0;
    }
}

