/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.library;

import android.content.Context;
import android.os.Build;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TinkerLoadLibrary {
    private static final String TAG = "Tinker.LoadLibrary";

    public static void loadArmLibrary(Context context, String libName) {
        if (libName == null || libName.isEmpty() || context == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        Tinker tinker = Tinker.with(context);
        if (tinker.isEnabledForNativeLib() && TinkerLoadLibrary.loadLibraryFromTinker(context, "lib/armeabi", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static void loadArmV7Library(Context context, String libName) {
        if (libName == null || libName.isEmpty() || context == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        Tinker tinker = Tinker.with(context);
        if (tinker.isEnabledForNativeLib() && TinkerLoadLibrary.loadLibraryFromTinker(context, "lib/armeabi-v7a", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static boolean loadLibraryFromTinker(Context context, String relativePath, String libName) throws UnsatisfiedLinkError {
        Tinker tinker = Tinker.with(context);
        libName = libName.startsWith("lib") ? libName : "lib" + libName;
        libName = libName.endsWith(".so") ? libName : libName + ".so";
        String relativeLibPath = relativePath + "/" + libName;
        if (tinker.isEnabledForNativeLib() && tinker.isTinkerLoaded()) {
            TinkerLoadResult loadResult = tinker.getTinkerLoadResultIfPresent();
            if (loadResult.libs != null) {
                for (String name : loadResult.libs.keySet()) {
                    String patchLibraryPath;
                    File library;
                    if (!name.equals(relativeLibPath) || !(library = new File(patchLibraryPath = loadResult.libraryDirectory + "/" + name)).exists()) continue;
                    boolean verifyMd5 = tinker.isTinkerLoadVerify();
                    if (verifyMd5 && !SharePatchFileUtil.verifyFileMd5((File)library, (String)loadResult.libs.get(name))) {
                        tinker.getLoadReporter().onLoadFileMd5Mismatch(library, 5);
                        continue;
                    }
                    System.load(patchLibraryPath);
                    TinkerLog.i(TAG, "loadLibraryFromTinker success:" + patchLibraryPath, new Object[0]);
                    return true;
                }
            }
        }
        return false;
    }

    public static void installNavitveLibraryABI(Context context, String currentABI) {
        Tinker tinker = Tinker.with(context);
        if (!tinker.isTinkerLoaded()) {
            TinkerLog.i(TAG, "tinker is not loaded, just return", new Object[0]);
            return;
        }
        TinkerLoadResult loadResult = tinker.getTinkerLoadResultIfPresent();
        if (loadResult.libs == null) {
            TinkerLog.i(TAG, "tinker libs is null, just return", new Object[0]);
            return;
        }
        File soDir = new File(loadResult.libraryDirectory, "lib/" + currentABI);
        if (!soDir.exists()) {
            TinkerLog.e(TAG, "current libraryABI folder is not exist, path: %s", soDir.getPath());
            return;
        }
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader == null) {
            TinkerLog.e(TAG, "classloader is null", new Object[0]);
            return;
        }
        TinkerLog.i(TAG, "before hack classloader:" + classLoader.toString(), new Object[0]);
        try {
            TinkerLoadLibrary.installNativeLibraryPath(classLoader, soDir);
        }
        catch (Throwable throwable) {
            TinkerLog.e(TAG, "installNativeLibraryPath fail:" + throwable, new Object[0]);
        }
        TinkerLog.i(TAG, "after hack classloader:" + classLoader.toString(), new Object[0]);
    }

    private static void installNativeLibraryPath(ClassLoader classLoader, File folder) throws Throwable {
        if (folder == null || !folder.exists()) {
            TinkerLog.e(TAG, "installNativeLibraryPath, folder %s is illegal", folder);
            return;
        }
        if (Build.VERSION.SDK_INT == 25 && Build.VERSION.PREVIEW_SDK_INT != 0 || Build.VERSION.SDK_INT > 25) {
            try {
                V25.install(classLoader, folder);
                return;
            }
            catch (Throwable throwable) {
                TinkerLog.e(TAG, "installNativeLibraryPath, v25 fail, sdk: %d, error: %s, try to fallback to V23", Build.VERSION.SDK_INT, throwable.getMessage());
                V23.install(classLoader, folder);
            }
        } else if (Build.VERSION.SDK_INT >= 23) {
            try {
                V23.install(classLoader, folder);
            }
            catch (Throwable throwable) {
                TinkerLog.e(TAG, "installNativeLibraryPath, v23 fail, sdk: %d, error: %s, try to fallback to V14", Build.VERSION.SDK_INT, throwable.getMessage());
                V14.install(classLoader, folder);
            }
        } else if (Build.VERSION.SDK_INT >= 14) {
            V14.install(classLoader, folder);
        } else {
            V4.install(classLoader, folder);
        }
    }

    private static final class V25 {
        private V25() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField((Object)classLoader, (String)"pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibraryDirectories = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryDirectories");
            List libDirs = (List)nativeLibraryDirectories.get(dexPathList);
            libDirs.add(0, folder);
            Field systemNativeLibraryDirectories = ShareReflectUtil.findField((Object)dexPathList, (String)"systemNativeLibraryDirectories");
            List systemLibDirs = (List)systemNativeLibraryDirectories.get(dexPathList);
            Method makePathElements = ShareReflectUtil.findMethod((Object)dexPathList, (String)"makePathElements", (Class[])new Class[]{List.class});
            libDirs.addAll(systemLibDirs);
            Object[] elements = (Object[])makePathElements.invoke(dexPathList, libDirs);
            Field nativeLibraryPathElements = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryPathElements");
            nativeLibraryPathElements.setAccessible(true);
            nativeLibraryPathElements.set(dexPathList, elements);
        }
    }

    private static final class V23 {
        private V23() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField((Object)classLoader, (String)"pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibraryDirectories = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryDirectories");
            List libDirs = (List)nativeLibraryDirectories.get(dexPathList);
            libDirs.add(0, folder);
            Field systemNativeLibraryDirectories = ShareReflectUtil.findField((Object)dexPathList, (String)"systemNativeLibraryDirectories");
            List systemLibDirs = (List)systemNativeLibraryDirectories.get(dexPathList);
            Method makePathElements = ShareReflectUtil.findMethod((Object)dexPathList, (String)"makePathElements", (Class[])new Class[]{List.class, File.class, List.class});
            ArrayList suppressedExceptions = new ArrayList();
            libDirs.addAll(systemLibDirs);
            Object[] elements = (Object[])makePathElements.invoke(dexPathList, libDirs, null, suppressedExceptions);
            Field nativeLibraryPathElements = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryPathElements");
            nativeLibraryPathElements.setAccessible(true);
            nativeLibraryPathElements.set(dexPathList, elements);
        }
    }

    private static final class V14 {
        private V14() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField((Object)classLoader, (String)"pathList");
            Object dexPathList = pathListField.get(classLoader);
            ShareReflectUtil.expandFieldArray((Object)dexPathList, (String)"nativeLibraryDirectories", (Object[])new File[]{folder});
        }
    }

    private static final class V4 {
        private V4() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            String addPath = folder.getPath();
            Field pathField = ShareReflectUtil.findField((Object)classLoader, (String)"libPath");
            StringBuilder libPath = new StringBuilder((String)pathField.get(classLoader));
            libPath.append(':').append(addPath);
            pathField.set(classLoader, libPath.toString());
            Field libraryPathElementsFiled = ShareReflectUtil.findField((Object)classLoader, (String)"libraryPathElements");
            List libraryPathElements = (List)libraryPathElementsFiled.get(classLoader);
            libraryPathElements.add(0, addPath);
            libraryPathElementsFiled.set(classLoader, libraryPathElements);
        }
    }
}

