package com.tinkerpatch.sdk.okhttp3;

import com.tinkerpatch.sdk.server.RequestLoader;
import com.tinkerpatch.sdk.server.model.DataFetcher;
import com.tinkerpatch.sdk.server.model.TinkerClientUrl;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;

/**
 * Okhttp3 加载器
 */
public class OkHttp3Loader implements RequestLoader {

    private final OkHttpClient client;

    /**
     * 使用用户传递的okhttp client
     * @param okHttpClient custom {@link okhttp3.OkHttpClient}
     */
    public OkHttp3Loader(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    /**
     * 使用默认的okhttpclient
     */
    public OkHttp3Loader() {
        this.client = new OkHttpClient.Builder()
            .connectTimeout(30, TimeUnit.SECONDS)
            .readTimeout(100, TimeUnit.SECONDS)
            .writeTimeout(30, TimeUnit.SECONDS)
            .retryOnConnectionFailure(true)
            .build();
    }

    @Override
    public DataFetcher<InputStream> buildLoadData(TinkerClientUrl url) {
        return new OkHttp3StreamFetcher(this.client, url);
    }
}
