/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk.okhttp;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tinkerpatch.sdk.server.model.DataFetcher;
import com.tinkerpatch.sdk.server.model.TinkerClientUrl;
import com.tinkerpatch.sdk.util.ContentLengthInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class OkHttpStreamFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "Tinker.OkHttpFetcher";
    private static MediaType mediaTypeForm = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    private final TinkerClientUrl tkUrl;
    private OkHttpClient client;
    private ResponseBody responseBody;
    private InputStream stream;

    public OkHttpStreamFetcher(OkHttpClient okHttpClient, TinkerClientUrl tinkerClientUrl) {
        this.client = okHttpClient;
        this.tkUrl = tinkerClientUrl;
    }

    /*
     * WARNING - void declaration
     */
    public void loadData(final DataFetcher.DataCallback<? super InputStream> dataCallback) {
        void var4_7;
        Request.Builder builder = new Request.Builder().url(this.tkUrl.getStringUrl());
        Object object = this.tkUrl.getMethod();
        int n = -1;
        switch (((String)object).hashCode()) {
            case 70454: {
                if (!((String)object).equals("GET")) break;
                boolean entry = false;
                break;
            }
            case 2461856: {
                if (!((String)object).equals("POST")) break;
                boolean call = true;
            }
        }
        switch (var4_7) {
            case 0: {
                builder = builder.get();
                break;
            }
            case 1: {
                builder = builder.post(RequestBody.create((MediaType)mediaTypeForm, (String)this.tkUrl.getBody()));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported request Method" + this.tkUrl.getMethod());
            }
        }
        for (Map.Entry entry : this.tkUrl.getHeaders().entrySet()) {
            String string = (String)entry.getKey();
            builder.addHeader(string, (String)entry.getValue());
        }
        object = builder.build();
        Call call = this.client.newCall((Request)object);
        call.enqueue(new Callback(){

            public void onFailure(Request request, IOException iOException) {
                TinkerLog.w((String)OkHttpStreamFetcher.TAG, (String)"failed to obtain result", (Object[])new Object[]{iOException});
                dataCallback.onLoadFailed((Exception)iOException);
            }

            public void onResponse(Response response) {
                OkHttpStreamFetcher.this.responseBody = response.body();
                if (OkHttpStreamFetcher.this.responseBody != null && response.isSuccessful()) {
                    long l = OkHttpStreamFetcher.this.responseBody.contentLength();
                    TinkerLog.d((String)OkHttpStreamFetcher.TAG, (String)("got success response: " + response.code() + ", " + response.message()), (Object[])new Object[0]);
                    OkHttpStreamFetcher.this.stream = ContentLengthInputStream.obtain((InputStream)OkHttpStreamFetcher.this.responseBody.byteStream(), (long)l);
                    dataCallback.onDataReady((Object)OkHttpStreamFetcher.this.stream);
                } else {
                    TinkerLog.w((String)OkHttpStreamFetcher.TAG, (String)("got error response: " + response.code() + ", " + response.message()), (Object[])new Object[0]);
                    dataCallback.onLoadFailed((Exception)new RuntimeException(String.format("Okhttp3 error:%s", response.message())));
                }
            }
        });
    }

    public void cleanup() {
        this.client = null;
        SharePatchFileUtil.closeQuietly((Object)this.stream);
        SharePatchFileUtil.closeQuietly((Object)this.responseBody);
    }
}

