/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk.build.gradle.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Utils {
    public static boolean isNullOrNil(String object) {
        return object == null || object.length() <= 0;
    }

    public static boolean isLegalFile(String path) {
        if (Utils.isNullOrNil(path)) {
            return false;
        }
        File file = new File(path);
        return file.exists() && file.isFile() && file.length() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFileUsingStream(File source, File dest) throws IOException {
        if (source == null || !source.exists() || !source.isFile()) {
            return false;
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            return false;
        }
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(is);
            Utils.closeQuietly(os);
            throw throwable;
        }
        Utils.closeQuietly(is);
        Utils.closeQuietly(os);
        return true;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

