/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk.util;

import android.text.TextUtils;
import com.tencent.tinker.lib.util.TinkerLog;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentLengthInputStream
extends FilterInputStream {
    private static final String TAG = "Tinker.ContentLengthStream";
    private static final int UNKNOWN = -1;
    private final long contentLength;
    private int readSoFar;

    public static InputStream obtain(InputStream inputStream, String string) {
        return ContentLengthInputStream.obtain(inputStream, ContentLengthInputStream.parseContentLength(string));
    }

    public static InputStream obtain(InputStream inputStream, long l) {
        return new ContentLengthInputStream(inputStream, l);
    }

    private static int parseContentLength(String string) {
        int n = -1;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                TinkerLog.d((String)TAG, (String)("failed to parse content length header: " + string), (Object[])new Object[]{numberFormatException});
            }
        }
        return n;
    }

    ContentLengthInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.contentLength = l;
    }

    @Override
    public synchronized int available() throws IOException {
        return (int)Math.max(this.contentLength - (long)this.readSoFar, (long)this.in.available());
    }

    @Override
    public synchronized int read() throws IOException {
        int n = super.read();
        this.checkReadSoFarOrThrow(n >= 0 ? 1 : -1);
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        return this.checkReadSoFarOrThrow(super.read(byArray, n, n2));
    }

    private int checkReadSoFarOrThrow(int n) throws IOException {
        if (n >= 0) {
            this.readSoFar += n;
        } else if (this.contentLength - (long)this.readSoFar > 0L) {
            throw new IOException("Failed to read all expected data, expected: " + this.contentLength + ", but read: " + this.readSoFar);
        }
        return n;
    }
}

