/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk.server.callback;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tinkerpatch.sdk.a.f;
import com.tinkerpatch.sdk.a.g;
import com.tinkerpatch.sdk.server.a;
import com.tinkerpatch.sdk.server.c.b;
import com.tinkerpatch.sdk.server.callback.PatchRequestCallback;
import com.tinkerpatch.sdk.server.callback.RollbackCallBack;
import com.tinkerpatch.sdk.server.utils.e;
import java.io.File;

public class TinkerPatchRequestCallback
implements PatchRequestCallback {
    private static final String TAG = "Tinker.PatchRequestCallback";
    public static final String TINKER_DOWNLOAD_FAIL_TIMES = "tinker_download_fail";
    public static final int DOWNLOAD_FAIL_MAX_TIMES = 3;
    public static final int PATCH_MAX_RETRY_COUNT = 3;
    private static boolean rollbackOnScreenOff;
    private static RollbackCallBack rollbackCallBack;

    public static void setRollbackOnScreenOff(boolean bl) {
        rollbackOnScreenOff = bl;
    }

    public static void setPatchRollbackCallBack(RollbackCallBack rollbackCallBack) {
        TinkerPatchRequestCallback.rollbackCallBack = rollbackCallBack;
    }

    @Override
    public boolean beforePatchRequest() {
        Context context = b.d();
        Tinker tinker = Tinker.with((Context)context);
        if (!com.tinkerpatch.sdk.a.b.a(context)) {
            TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: beforePatchRequest return false, not connect to internet", (Object[])new Object[0]);
            return false;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning((Context)context)) {
            TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: beforePatchRequest return false, tinker service is running", (Object[])new Object[0]);
            return false;
        }
        if (!tinker.isMainProcess()) {
            TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: beforePatchRequest return false, only request on the main process", (Object[])new Object[0]);
            return false;
        }
        if (f.b()) {
            TinkerLog.e((String)TAG, (String)"TinkerPatchRequestCallback: beforePatchRequest return false, is in ignore channel, current channel:%s", (Object[])new Object[]{f.a()});
            return false;
        }
        return true;
    }

    @Override
    public void onPatchRollback() {
        Object object = b.d();
        Tinker tinker = Tinker.with((Context)object);
        if (!tinker.isTinkerLoaded()) {
            TinkerLog.w((String)TAG, (String)"TinkerPatchRequestCallback: onPatchRollback, tinker is not loaded, just return", (Object[])new Object[0]);
            return;
        }
        if (rollbackCallBack != null) {
            rollbackCallBack.onPatchRollback();
        }
        if (rollbackOnScreenOff) {
            TinkerLog.i((String)TAG, (String)"tinker wait screen to clean patch and kill all process", (Object[])new Object[0]);
            new f.b((Context)object, new f.a(){

                @Override
                public void onScreenOff() {
                    TinkerPatchRequestCallback.this.rollbackPatchDirectly();
                }
            });
        }
        object = tinker.getTinkerLoadResultIfPresent().currentVersion;
        object = new SharePatchInfo((String)object, "00000000000000000000000000000000", Build.FINGERPRINT, "odex");
        SharePatchInfo.rewritePatchInfoFileWithLock((File)tinker.getPatchInfoFile(), (SharePatchInfo)object, (File)tinker.getPatchInfoLockFile());
    }

    @Override
    public void onPatchDownloadFail(Exception exception, Integer n, Integer n2) {
        TinkerLog.w((String)TAG, (String)"TinkerPatchRequestCallback: onPatchDownloadFail: %s", (Object[])new Object[]{exception.getMessage()});
    }

    @Override
    public boolean onPatchUpgrade(File file, Integer n, Integer object) {
        TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: onPatchUpgrade, file:%s, newVersion:%d, currentVersion:%d", (Object[])new Object[]{file.getPath(), n, object});
        object = a.a();
        Context context = b.d();
        ShareSecurityCheck shareSecurityCheck = new ShareSecurityCheck(context);
        if (!shareSecurityCheck.verifyPatchMetaSignature(file)) {
            TinkerLog.e((String)TAG, (String)"onPatchUpgrade, signature check failed. file: %s, version:%d", (Object[])new Object[]{file.getPath(), n});
            if (this.increaseDownloadError(context)) {
                g.a().a(n, SharePatchFileUtil.getMD5((File)file));
                ((a)object).a(n, -1);
            }
            SharePatchFileUtil.safeDeleteFile((File)file);
            return false;
        }
        if (ShareTinkerInternals.isVmJit()) {
            TinkerLog.e((String)TAG, (String)"TinkerPatchRequestCallback: is jvm jit, just return", (Object[])new Object[0]);
            g.a().a(n, SharePatchFileUtil.getMD5((File)file));
            SharePatchFileUtil.safeDeleteFile((File)file);
            ((a)object).a(n, -205);
            return false;
        }
        this.handleUpgradePatch(file, n);
        file = context.getSharedPreferences("patch_server_config", 0);
        file.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, 0).apply();
        return true;
    }

    @Override
    public void onPatchNeedNotUpgrade() {
        Object object = a.a();
        Context context = b.d();
        Object object2 = Tinker.with((Context)context);
        Object object3 = g.a();
        String string = ((g)object3).h();
        object2 = object2.getTinkerLoadResultIfPresent();
        if ((object2.currentVersion == null || !string.equals(object2.currentVersion)) && (object2 = ((g)object3).c()).intValue() > 0 && ((File)(object = e.a(context, ((a)object).c(), String.valueOf(object2)))).exists() && ((File)object).isFile() && ((String)(object3 = SharePatchFileUtil.getMD5((File)object))).equals(string) && this.retryPendingPatch(context, (Integer)object2, (String)object3, (File)object)) {
            return;
        }
    }

    @Override
    public void onPatchSyncFail(Exception exception) {
        TinkerLog.w((String)TAG, (String)("TinkerPatchRequestCallback onPatchSyncFail error: " + exception), (Object[])new Object[0]);
        TinkerLog.e((String)TAG, (String)"Plz make sure you fill the correct appVersion and appKey in tinkerpatch.gradle. Or create the correspond project in tinkerpatch.com", (Object[])new Object[0]);
    }

    @Override
    public void updatePatchConditions() {
        TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: updatePatchConditions", (Object[])new Object[0]);
        a a2 = a.a();
        Context context = b.d();
        a2.a("wifi", com.tinkerpatch.sdk.a.b.b(context) ? "1" : "0");
    }

    private boolean retryPendingPatch(Context context, Integer object, String string, File file) {
        g g2 = g.a();
        int n = g2.g() + 1;
        if (n < 3) {
            TinkerLog.d((String)TAG, (String)"[beforePatchRequest] have pending patch to install, version: %d, patch:%s", (Object[])new Object[]{object, file.getPath()});
            object = g2;
            if (!((g)object).h().equals(string)) {
                TinkerLog.w((String)"Tinker.VersionInfo", (String)"increaseRetryTimes fail, current PatchMd5: %s, try increase md5: %s", (Object[])new Object[]{((g)object).h(), string});
            } else {
                ((g)object).a(((g)object).i(), ((g)object).j(), ((g)object).d(), ((g)object).c(), string, ((g)object).k(), ((g)object).f(), ((g)object).g() + 1, ((g)object).e());
            }
            TinkerInstaller.onReceiveUpgradePatch((Context)context, (String)file.getAbsolutePath());
            return true;
        }
        SharePatchFileUtil.safeDeleteFile((File)file);
        TinkerLog.d((String)TAG, (String)"[beforePatchRequest] retry patch install more than %d times, version: %d, patch:%s", (Object[])new Object[]{n, object, file.getPath()});
        return false;
    }

    private void rollbackPatchDirectly() {
        Context context = b.d();
        Tinker tinker = Tinker.with((Context)context);
        ShareTinkerInternals.killAllOtherProcess((Context)context);
        tinker.cleanPatch();
        Process.killProcess((int)Process.myPid());
    }

    private void handleUpgradePatch(File file, Integer fileArray) {
        Object object = a.a();
        Context context = b.d();
        g g2 = g.a();
        ((a)object).a((Integer)fileArray);
        object = SharePatchFileUtil.getMD5((File)file);
        g2.a((Integer)fileArray, (String)object);
        fileArray = e.c(context).listFiles();
        if (fileArray != null) {
            object = file.getName();
            for (File file2 : fileArray) {
                String string = file2.getName();
                if (string.equals(object) || string.endsWith("_version.info") || string.equals("version.lock")) continue;
                SharePatchFileUtil.safeDeleteFile((File)file2);
            }
        }
        TinkerInstaller.onReceiveUpgradePatch((Context)context, (String)file.getAbsolutePath());
    }

    private boolean increaseDownloadError(Context context) {
        context = context.getSharedPreferences("patch_server_config", 0);
        int n = context.getInt(TINKER_DOWNLOAD_FAIL_TIMES, 0);
        TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: increaseDownloadError, current count:%d", (Object[])new Object[]{n});
        if (n >= 3) {
            context.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, 0).commit();
            return true;
        }
        context.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, ++n).commit();
        return false;
    }
}

