/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ShareTinkerInternals {
    private static final String TAG = "Tinker.TinkerInternals";
    private static final boolean VM_IS_ART = ShareTinkerInternals.isVmArt(System.getProperty("java.vm.version"));
    private static final boolean VM_IS_JIT = ShareTinkerInternals.isVmJitInternal();
    private static final String PATCH_PROCESS_NAME = ":patch";
    private static Boolean isPatchProcess = null;
    private static String processName = null;
    private static String tinkerID = null;

    public static boolean isVmArt() {
        return VM_IS_ART || Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isVmJit() {
        return VM_IS_JIT && Build.VERSION.SDK_INT < 24;
    }

    public static boolean isSystemOTA(String string) {
        String string2 = Build.FINGERPRINT;
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            Log.d((String)TAG, (String)("fingerprint empty:" + string + ",current:" + string2));
            return false;
        }
        if (string.equals(string2)) {
            Log.d((String)TAG, (String)("same fingerprint:" + string2));
            return false;
        }
        Log.d((String)TAG, (String)("system OTA,fingerprint not equal:" + string + "," + string2));
        return true;
    }

    public static boolean isNullOrNil(String string) {
        return string == null || string.length() <= 0;
    }

    public static int checkTinkerPackage(Context context, int n, File file, ShareSecurityCheck shareSecurityCheck) {
        int n2 = ShareTinkerInternals.checkSignatureAndTinkerID(context, file, shareSecurityCheck);
        if (n2 == 0) {
            n2 = ShareTinkerInternals.checkPackageAndTinkerFlag(shareSecurityCheck, n);
        }
        return n2;
    }

    public static int checkSignatureAndTinkerID(Context object, File hashMap, ShareSecurityCheck shareSecurityCheck) {
        if (!shareSecurityCheck.verifyPatchMetaSignature((File)((Object)hashMap))) {
            return -1;
        }
        if ((object = ShareTinkerInternals.getManifestTinkerID((Context)object)) == null) {
            return -5;
        }
        hashMap = shareSecurityCheck.getPackagePropertiesIfPresent();
        if (hashMap == null) {
            return -2;
        }
        if ((hashMap = (String)hashMap.get("TINKER_ID")) == null) {
            return -6;
        }
        if (!((String)object).equals(hashMap)) {
            Log.e((String)TAG, (String)("tinkerId is not equal, base is " + (String)object + ", but patch is " + (String)((Object)hashMap)));
            return -7;
        }
        return 0;
    }

    public static int checkPackageAndTinkerFlag(ShareSecurityCheck object, int n) {
        if (ShareTinkerInternals.isTinkerEnabledAll(n)) {
            return 0;
        }
        object = ((ShareSecurityCheck)object).getMetaContentMap();
        boolean bl = ShareTinkerInternals.isTinkerEnabledForDex(n);
        if (!bl && ((HashMap)object).containsKey("assets/dex_meta.txt")) {
            return -9;
        }
        bl = ShareTinkerInternals.isTinkerEnabledForNativeLib(n);
        if (!bl && ((HashMap)object).containsKey("assets/so_meta.txt")) {
            return -9;
        }
        boolean bl2 = ShareTinkerInternals.isTinkerEnabledForResource(n);
        n = bl2 ? 1 : 0;
        if (!bl2 && ((HashMap)object).containsKey("assets/res_meta.txt")) {
            return -9;
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    public static Properties fastGetPatchPackageMeta(File object) {
        ZipFile zipFile;
        block9: {
            if (object == null || !((File)object).isFile() || ((File)object).length() == 0L) {
                Log.e((String)TAG, (String)"patchFile is illegal");
                return null;
            }
            zipFile = null;
            zipFile = new ZipFile((File)object);
            object = zipFile.getEntry("assets/package_meta.txt");
            if (object != null) break block9;
            Log.e((String)TAG, (String)"patch meta entry not found");
            SharePatchFileUtil.closeZip(zipFile);
            return null;
        }
        InputStream inputStream = null;
        inputStream = zipFile.getInputStream((ZipEntry)object);
        object = new Properties();
        ((Properties)object).load(inputStream);
        SharePatchFileUtil.closeQuietly(inputStream);
        SharePatchFileUtil.closeZip(zipFile);
        return object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        SharePatchFileUtil.closeQuietly(inputStream);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        Log.e((String)TAG, (String)("fastGetPatchPackageMeta exception:" + iOException.getMessage()));
                        SharePatchFileUtil.closeZip(zipFile);
                        return null;
                    }
                }
                catch (Throwable throwable2) {
                    SharePatchFileUtil.closeZip(zipFile);
                    throw throwable2;
                }
            }
        }
    }

    public static String getManifestTinkerID(Context object) {
        if (tinkerID != null) {
            return tinkerID;
        }
        try {
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            object = object.metaData.get("TINKER_ID");
            tinkerID = object != null ? String.valueOf(object) : null;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("getManifestTinkerID exception:" + exception.getMessage()));
            return null;
        }
        return tinkerID;
    }

    public static boolean isTinkerEnabledForDex(int n) {
        return (n & 1) != 0;
    }

    public static boolean isTinkerEnabledForNativeLib(int n) {
        return (n & 2) != 0;
    }

    public static boolean isTinkerEnabledForResource(int n) {
        return (n & 4) != 0;
    }

    public static String getTypeString(int n) {
        switch (n) {
            case 3: {
                return "dex";
            }
            case 4: {
                return "dex_opt";
            }
            case 5: {
                return "lib";
            }
            case 1: {
                return "patch_file";
            }
            case 2: {
                return "patch_info";
            }
            case 6: {
                return "resource";
            }
        }
        return "unknown";
    }

    public static void setTinkerDisableWithSharedPreferences(Context context) {
        context = context.getSharedPreferences("tinker_share_config", 4);
        context.edit().putBoolean(ShareTinkerInternals.getTinkerSharedPreferencesName(), false).commit();
    }

    public static boolean isTinkerEnableWithSharedPreferences(Context context) {
        if (context == null) {
            return false;
        }
        context = context.getSharedPreferences("tinker_share_config", 4);
        return context.getBoolean(ShareTinkerInternals.getTinkerSharedPreferencesName(), true);
    }

    private static String getTinkerSharedPreferencesName() {
        return "tinker_enable_1.7.8";
    }

    public static boolean isTinkerEnabled(int n) {
        return n != 0;
    }

    public static boolean isTinkerEnabledAll(int n) {
        return n == 7;
    }

    public static boolean isInMainProcess(Context object) {
        String string = object.getPackageName();
        if ((object = ShareTinkerInternals.getProcessName((Context)object)) == null || ((String)object).length() == 0) {
            object = "";
        }
        return string.equals(object);
    }

    public static boolean isInPatchProcess(Context context) {
        if (isPatchProcess != null) {
            return isPatchProcess;
        }
        isPatchProcess = ShareTinkerInternals.getProcessName(context).endsWith(PATCH_PROCESS_NAME);
        return isPatchProcess;
    }

    public static String getCurrentOatMode(Context context, String string) {
        if (string.equals("changing")) {
            string = ShareTinkerInternals.isInMainProcess(context) ? "odex" : "interpet";
        }
        return string;
    }

    public static void killAllOtherProcess(Context object) {
        if ((object = (ActivityManager)object.getSystemService("activity")) == null) {
            return;
        }
        if ((object = object.getRunningAppProcesses()) == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
            if (runningAppProcessInfo.uid != Process.myUid() || runningAppProcessInfo.pid == Process.myPid()) continue;
            Process.killProcess((int)runningAppProcessInfo.pid);
        }
    }

    public static String getProcessName(Context context) {
        if (processName != null) {
            return processName;
        }
        processName = ShareTinkerInternals.getProcessNameInternal(context);
        return processName;
    }

    /*
     * Loose catch block
     */
    private static String getProcessNameInternal(Context object) {
        block23: {
            Object object2;
            block22: {
                int n = Process.myPid();
                if (object == null || n <= 0) {
                    return "";
                }
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = null;
                object = (ActivityManager)object.getSystemService("activity");
                if ((object = object.getRunningAppProcesses()) != null) {
                    try {
                        object = object.iterator();
                        while (object.hasNext()) {
                            object2 = (ActivityManager.RunningAppProcessInfo)object.next();
                            if (((ActivityManager.RunningAppProcessInfo)object2).pid != n) continue;
                            runningAppProcessInfo = object2;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)("getProcessNameInternal exception:" + exception.getMessage()));
                    }
                    if (runningAppProcessInfo != null) {
                        return runningAppProcessInfo.processName;
                    }
                }
                object = new byte[128];
                object2 = null;
                object2 = new FileInputStream("/proc/" + n + "/cmdline");
                n = ((FileInputStream)object2).read((byte[])object);
                if (n <= 0) break block22;
                for (int i = 0; i < n; ++i) {
                    if (object[i] <= 128 && object[i] > 0) continue;
                    n = i;
                    break;
                }
                String string = new String((byte[])object, 0, n);
                try {
                    ((FileInputStream)object2).close();
                }
                catch (Exception exception) {}
                return string;
            }
            try {
                ((FileInputStream)object2).close();
            }
            catch (Exception exception) {}
            break block23;
            catch (Exception exception) {
                try {
                    Log.e((String)TAG, (String)("getProcessNameInternal exception:" + exception.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        if (object2 != null) {
                            ((FileInputStream)object2).close();
                        }
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    if (object2 != null) {
                        ((FileInputStream)object2).close();
                    }
                }
                catch (Exception exception3) {}
            }
        }
        return "";
    }

    private static boolean isVmArt(String object) {
        boolean bl = false;
        if (object != null && ((Matcher)(object = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher((CharSequence)object))).matches()) {
            try {
                int n = Integer.parseInt(((Matcher)object).group(1));
                int n2 = Integer.parseInt(((Matcher)object).group(2));
                bl = n > 2 || n == 2 && n2 > 0;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    private static boolean isVmJitInternal() {
        try {
            Object object = Class.forName("android.os.SystemProperties");
            object = ((Class)object).getDeclaredMethod("get", String.class);
            String string = (String)((Method)object).invoke(null, "dalvik.vm.usejit");
            object = (String)((Method)object).invoke(null, "dalvik.vm.usejitprofiles");
            if (!ShareTinkerInternals.isNullOrNil(string) && ShareTinkerInternals.isNullOrNil((String)object) && string.equals("true")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)("isVmJitInternal ex:" + throwable));
        }
        return false;
    }

    public static String getExceptionCauseString(Throwable object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        try {
            while (((Throwable)object).getCause() != null) {
                object = ((Throwable)object).getCause();
            }
            ((Throwable)object).printStackTrace(printStream);
            object = ShareTinkerInternals.toVisualString(byteArrayOutputStream.toString());
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {}
        return object;
    }

    public static String toVisualString(String string) {
        int n;
        boolean bl = false;
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        if (cArray == null) {
            return null;
        }
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] <= '\u007f') continue;
            cArray[n] = '\u0000';
            bl = true;
            break;
        }
        if (bl) {
            return new String(cArray, 0, n);
        }
        return string;
    }
}

