/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.os.Build;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareFileLockHelper;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class SharePatchInfo {
    public static final int MAX_EXTRACT_ATTEMPTS = 2;
    public static final String OLD_VERSION = "old";
    public static final String NEW_VERSION = "new";
    public static final String FINGER_PRINT = "print";
    public static final String OAT_DIR = "dir";
    public static final String DEFAULT_DIR = "odex";
    private static final String TAG = "PatchInfo";
    public String oldVersion;
    public String newVersion;
    public String fingerPrint;
    public String oatDir;

    public SharePatchInfo(String string, String string2, String string3, String string4) {
        this.oldVersion = string;
        this.newVersion = string2;
        this.fingerPrint = string3;
        this.oatDir = string4;
    }

    public static SharePatchInfo readAndCheckPropertyWithLock(File object, File file) {
        if (object == null || file == null) {
            return null;
        }
        Object object2 = file.getParentFile();
        if (!((File)object2).exists()) {
            ((File)object2).mkdirs();
        }
        object2 = null;
        try {
            object2 = ShareFileLockHelper.getFileLock(file);
            object = SharePatchInfo.readAndCheckProperty((File)object);
        }
        catch (Exception exception) {
            throw new TinkerRuntimeException("readAndCheckPropertyWithLock fail", exception);
        }
        finally {
            try {
                if (object2 != null) {
                    ((ShareFileLockHelper)object2).close();
                }
            }
            catch (IOException iOException) {
                Log.i((String)TAG, (String)"releaseInfoLock error", (Throwable)iOException);
            }
        }
        return object;
    }

    public static boolean rewritePatchInfoFileWithLock(File file, SharePatchInfo sharePatchInfo, File file2) {
        boolean bl;
        if (file == null || sharePatchInfo == null || file2 == null) {
            return false;
        }
        Object object = file2.getParentFile();
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        object = null;
        try {
            object = ShareFileLockHelper.getFileLock(file2);
            bl = SharePatchInfo.rewritePatchInfoFile(file, sharePatchInfo);
        }
        catch (Exception exception) {
            throw new TinkerRuntimeException("rewritePatchInfoFileWithLock fail", exception);
        }
        finally {
            try {
                if (object != null) {
                    ((ShareFileLockHelper)object).close();
                }
            }
            catch (IOException iOException) {
                Log.i((String)TAG, (String)"releaseInfoLock error", (Throwable)iOException);
            }
        }
        return bl;
    }

    private static SharePatchInfo readAndCheckProperty(File file) {
        boolean bl = false;
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while (n < 2 && !bl) {
            ++n;
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                string = properties.getProperty(OLD_VERSION);
                string2 = properties.getProperty(NEW_VERSION);
                string3 = properties.getProperty(FINGER_PRINT);
                string4 = properties.getProperty(OAT_DIR);
            }
            catch (IOException iOException) {
                try {
                    Log.e((String)TAG, (String)("read property failed, e:" + iOException));
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(fileInputStream);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(fileInputStream);
            }
            SharePatchFileUtil.closeQuietly(fileInputStream);
            if (string == null || string2 == null) continue;
            if (!string.equals("") && !SharePatchFileUtil.checkIfMd5Valid(string) || !SharePatchFileUtil.checkIfMd5Valid(string2)) {
                Log.w((String)TAG, (String)("path info file  corrupted:" + file.getAbsolutePath()));
                continue;
            }
            bl = true;
        }
        if (bl) {
            return new SharePatchInfo(string, string2, string3, string4);
        }
        return null;
    }

    private static boolean rewritePatchInfoFile(File file, SharePatchInfo sharePatchInfo) {
        if (file == null || sharePatchInfo == null) {
            return false;
        }
        if (ShareTinkerInternals.isNullOrNil(sharePatchInfo.fingerPrint)) {
            sharePatchInfo.fingerPrint = Build.FINGERPRINT;
        }
        if (ShareTinkerInternals.isNullOrNil(sharePatchInfo.oatDir)) {
            sharePatchInfo.oatDir = DEFAULT_DIR;
        }
        Log.i((String)TAG, (String)("rewritePatchInfoFile file path:" + file.getAbsolutePath() + " , oldVer:" + sharePatchInfo.oldVersion + ", newVer:" + sharePatchInfo.newVersion + ", fingerprint:" + sharePatchInfo.fingerPrint + ", oatDir:" + sharePatchInfo.oatDir));
        boolean bl = false;
        int n = 0;
        Object object = file.getParentFile();
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        while (n < 2 && !bl) {
            Object object2;
            ++n;
            Properties properties = new Properties();
            properties.put(OLD_VERSION, sharePatchInfo.oldVersion);
            properties.put(NEW_VERSION, sharePatchInfo.newVersion);
            properties.put(FINGER_PRINT, sharePatchInfo.fingerPrint);
            properties.put(OAT_DIR, sharePatchInfo.oatDir);
            object = null;
            try {
                object = new FileOutputStream(file, false);
                object2 = "from old version:" + sharePatchInfo.oldVersion + " to new version:" + sharePatchInfo.newVersion;
                properties.store((OutputStream)object, (String)object2);
            }
            catch (Exception exception) {
                object2 = exception;
                exception.printStackTrace();
            }
            finally {
                SharePatchFileUtil.closeQuietly((Closeable)object);
            }
            if (bl = (object2 = SharePatchInfo.readAndCheckProperty(file)) != null && ((SharePatchInfo)object2).oldVersion.equals(sharePatchInfo.oldVersion) && ((SharePatchInfo)object2).newVersion.equals(sharePatchInfo.newVersion)) continue;
            file.delete();
        }
        return bl;
    }
}

