/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class ShareElfFile
implements Closeable {
    public static final int FILE_TYPE_OTHERS = -1;
    public static final int FILE_TYPE_ODEX = 0;
    public static final int FILE_TYPE_ELF = 1;
    private final FileInputStream fis;
    private final Map<String, SectionHeader> sectionNameToHeaderMap = new HashMap<String, SectionHeader>();
    public ElfHeader elfHeader = null;
    public ProgramHeader[] programHeaders = null;
    public SectionHeader[] sectionHeaders = null;

    public ShareElfFile(File object) {
        int n;
        this.fis = new FileInputStream((File)object);
        object = this.fis.getChannel();
        this.elfHeader = new ElfHeader((FileChannel)object);
        SectionHeader[] sectionHeaderArray = ByteBuffer.allocate(128);
        sectionHeaderArray.limit(this.elfHeader.ePhEntSize);
        sectionHeaderArray.order(this.elfHeader.eIndent[5] == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        ((FileChannel)object).position(this.elfHeader.ePhOff);
        this.programHeaders = new ProgramHeader[this.elfHeader.ePhNum];
        for (n = 0; n < this.programHeaders.length; ++n) {
            ShareElfFile.readUntilLimit((FileChannel)object, (ByteBuffer)sectionHeaderArray, "failed to read phdr.");
            this.programHeaders[n] = new ProgramHeader((ByteBuffer)sectionHeaderArray, this.elfHeader.eIndent[4]);
        }
        ((FileChannel)object).position(this.elfHeader.eShOff);
        sectionHeaderArray.limit(this.elfHeader.eShEntSize);
        this.sectionHeaders = new SectionHeader[this.elfHeader.eShNum];
        for (n = 0; n < this.sectionHeaders.length; ++n) {
            ShareElfFile.readUntilLimit((FileChannel)object, (ByteBuffer)sectionHeaderArray, "failed to read shdr.");
            this.sectionHeaders[n] = new SectionHeader((ByteBuffer)sectionHeaderArray, this.elfHeader.eIndent[4]);
        }
        if (this.elfHeader.eShStrNdx > 0) {
            SectionHeader sectionHeader = this.sectionHeaders[this.elfHeader.eShStrNdx];
            object = this.getSection(sectionHeader);
            sectionHeaderArray = this.sectionHeaders;
            int n2 = this.sectionHeaders.length;
            for (int i = 0; i < n2; ++i) {
                SectionHeader sectionHeader2 = sectionHeaderArray[i];
                ((ByteBuffer)object).position(sectionHeader2.shName);
                sectionHeader2.shNameStr = ShareElfFile.readCString((ByteBuffer)object);
                this.sectionNameToHeaderMap.put(sectionHeader2.shNameStr, sectionHeader2);
            }
        }
    }

    private static void assertInRange(int n, int n2, int n3, String string) {
        if (n < n2 || n > n3) {
            throw new IOException(string);
        }
    }

    public static int getFileTypeByMagic(File file) {
        InputStream inputStream;
        block13: {
            byte[] byArray;
            block12: {
                inputStream = null;
                try {
                    byArray = new byte[4];
                    inputStream = new FileInputStream(file);
                    inputStream.read(byArray);
                    if (byArray[0] != 100 || byArray[1] != 101 || byArray[2] != 121 || byArray[3] != 10) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
                return 0;
            }
            if (byArray[0] != 127 || byArray[1] != 69 || byArray[2] != 76 || byArray[3] != 70) break block13;
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
            return 1;
        }
        try {
            inputStream.close();
        }
        catch (Throwable throwable) {}
        return -1;
    }

    public static void readUntilLimit(FileChannel fileChannel, ByteBuffer byteBuffer, String string) {
        byteBuffer.rewind();
        int n = fileChannel.read(byteBuffer);
        if (n != byteBuffer.limit()) {
            throw new IOException(string + " Rest bytes insufficient, expect to read " + byteBuffer.limit() + " bytes but only " + n + " bytes were read.");
        }
        byteBuffer.flip();
    }

    public static String readCString(ByteBuffer byteBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.position();
        while (byteBuffer.hasRemaining() && byArray[byteBuffer.position()] != 0) {
            byteBuffer.position(byteBuffer.position() + 1);
        }
        byteBuffer.position(byteBuffer.position() + 1);
        return new String(byArray, n, byteBuffer.position() - n - 1, Charset.forName("ASCII"));
    }

    public FileChannel getChannel() {
        return this.fis.getChannel();
    }

    public boolean is32BitElf() {
        return this.elfHeader.eIndent[4] == 1;
    }

    public ByteOrder getDataOrder() {
        if (this.elfHeader.eIndent[5] == 1) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        return ByteOrder.BIG_ENDIAN;
    }

    public SectionHeader getSectionHeaderByName(String string) {
        return this.sectionNameToHeaderMap.get(string);
    }

    public ByteBuffer getSection(SectionHeader sectionHeader) {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)sectionHeader.shSize);
        this.fis.getChannel().position(sectionHeader.shOffset);
        ShareElfFile.readUntilLimit(this.fis.getChannel(), byteBuffer, "failed to read section: " + sectionHeader.shNameStr);
        return byteBuffer;
    }

    public ByteBuffer getSegment(ProgramHeader programHeader) {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)programHeader.pFileSize);
        this.fis.getChannel().position(programHeader.pOffset);
        ShareElfFile.readUntilLimit(this.fis.getChannel(), byteBuffer, "failed to read segment (type: " + programHeader.pType + ").");
        return byteBuffer;
    }

    @Override
    public void close() {
        this.fis.close();
        this.sectionNameToHeaderMap.clear();
        this.programHeaders = null;
        this.sectionHeaders = null;
    }

    public static class SectionHeader {
        public static final int SHN_UNDEF = 0;
        public static final int SHN_LORESERVE = 65280;
        public static final int SHN_LOPROC = 65280;
        public static final int SHN_HIPROC = 65311;
        public static final int SHN_ABS = 65521;
        public static final int SHN_COMMON = 65522;
        public static final int SHN_HIRESERVE = 65535;
        public static final int SHT_NULL = 0;
        public static final int SHT_PROGBITS = 1;
        public static final int SHT_SYMTAB = 2;
        public static final int SHT_STRTAB = 3;
        public static final int SHT_RELA = 4;
        public static final int SHT_HASH = 5;
        public static final int SHT_DYNAMIC = 6;
        public static final int SHT_NOTE = 7;
        public static final int SHT_NOBITS = 8;
        public static final int SHT_REL = 9;
        public static final int SHT_SHLIB = 10;
        public static final int SHT_DYNSYM = 11;
        public static final int SHT_LOPROC = 0x70000000;
        public static final int SHT_HIPROC = Integer.MAX_VALUE;
        public static final int SHT_LOUSER = Integer.MIN_VALUE;
        public static final int SHT_HIUSER = -1;
        public static final int SHF_WRITE = 1;
        public static final int SHF_ALLOC = 2;
        public static final int SHF_EXECINSTR = 4;
        public static final int SHF_MASKPROC = -268435456;
        public final int shName;
        public final int shType;
        public final long shFlags;
        public final long shAddr;
        public final long shOffset;
        public final long shSize;
        public final int shLink;
        public final int shInfo;
        public final long shAddrAlign;
        public final long shEntSize;
        public String shNameStr;

        private SectionHeader(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 1: {
                    this.shName = byteBuffer.getInt();
                    this.shType = byteBuffer.getInt();
                    this.shFlags = byteBuffer.getInt();
                    this.shAddr = byteBuffer.getInt();
                    this.shOffset = byteBuffer.getInt();
                    this.shSize = byteBuffer.getInt();
                    this.shLink = byteBuffer.getInt();
                    this.shInfo = byteBuffer.getInt();
                    this.shAddrAlign = byteBuffer.getInt();
                    this.shEntSize = byteBuffer.getInt();
                    break;
                }
                case 2: {
                    this.shName = byteBuffer.getInt();
                    this.shType = byteBuffer.getInt();
                    this.shFlags = byteBuffer.getLong();
                    this.shAddr = byteBuffer.getLong();
                    this.shOffset = byteBuffer.getLong();
                    this.shSize = byteBuffer.getLong();
                    this.shLink = byteBuffer.getInt();
                    this.shInfo = byteBuffer.getInt();
                    this.shAddrAlign = byteBuffer.getLong();
                    this.shEntSize = byteBuffer.getLong();
                    break;
                }
                default: {
                    throw new IOException("Unexpected elf class: " + n);
                }
            }
            this.shNameStr = null;
        }
    }

    public static class ProgramHeader {
        public static final int PT_NULL = 0;
        public static final int PT_LOAD = 1;
        public static final int PT_DYNAMIC = 2;
        public static final int PT_INTERP = 3;
        public static final int PT_NOTE = 4;
        public static final int PT_SHLIB = 5;
        public static final int PT_PHDR = 6;
        public static final int PT_LOPROC = 0x70000000;
        public static final int PT_HIPROC = Integer.MAX_VALUE;
        public static final int PF_R = 4;
        public static final int PF_W = 2;
        public static final int PF_X = 1;
        public final int pType;
        public final int pFlags;
        public final long pOffset;
        public final long pVddr;
        public final long pPddr;
        public final long pFileSize;
        public final long pMemSize;
        public final long pAlign;

        private ProgramHeader(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 1: {
                    this.pType = byteBuffer.getInt();
                    this.pOffset = byteBuffer.getInt();
                    this.pVddr = byteBuffer.getInt();
                    this.pPddr = byteBuffer.getInt();
                    this.pFileSize = byteBuffer.getInt();
                    this.pMemSize = byteBuffer.getInt();
                    this.pFlags = byteBuffer.getInt();
                    this.pAlign = byteBuffer.getInt();
                    return;
                }
                case 2: {
                    this.pType = byteBuffer.getInt();
                    this.pFlags = byteBuffer.getInt();
                    this.pOffset = byteBuffer.getLong();
                    this.pVddr = byteBuffer.getLong();
                    this.pPddr = byteBuffer.getLong();
                    this.pFileSize = byteBuffer.getLong();
                    this.pMemSize = byteBuffer.getLong();
                    this.pAlign = byteBuffer.getLong();
                    return;
                }
            }
            throw new IOException("Unexpected elf class: " + n);
        }
    }

    public static class ElfHeader {
        public static final int EI_CLASS = 4;
        public static final int EI_DATA = 5;
        public static final int EI_VERSION = 6;
        public static final int ELFCLASS32 = 1;
        public static final int ELFCLASS64 = 2;
        public static final int ELFDATA2LSB = 1;
        public static final int ELFDATA2MSB = 2;
        public static final int ET_NONE = 0;
        public static final int ET_REL = 1;
        public static final int ET_EXEC = 2;
        public static final int ET_DYN = 3;
        public static final int ET_CORE = 4;
        public static final int ET_LOPROC = 65280;
        public static final int ET_HIPROC = 65535;
        public static final int EV_CURRENT = 1;
        private static final int EI_NINDENT = 16;
        public final byte[] eIndent = new byte[16];
        public final short eType;
        public final short eMachine;
        public final int eVersion;
        public final long eEntry;
        public final long ePhOff;
        public final long eShOff;
        public final int eFlags;
        public final short eEhSize;
        public final short ePhEntSize;
        public final short ePhNum;
        public final short eShEntSize;
        public final short eShNum;
        public final short eShStrNdx;

        private ElfHeader(FileChannel fileChannel) {
            fileChannel.position(0L);
            fileChannel.read(ByteBuffer.wrap(this.eIndent));
            if (this.eIndent[0] != 127 || this.eIndent[1] != 69 || this.eIndent[2] != 76 || this.eIndent[3] != 70) {
                throw new IOException(String.format("bad elf magic: %x %x %x %x.", this.eIndent[0], this.eIndent[1], this.eIndent[2], this.eIndent[3]));
            }
            ShareElfFile.assertInRange(this.eIndent[4], 1, 2, "bad elf class: " + this.eIndent[4]);
            ShareElfFile.assertInRange(this.eIndent[5], 1, 2, "bad elf data encoding: " + this.eIndent[5]);
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.eIndent[4] == 1 ? 36 : 48);
            byteBuffer.order(this.eIndent[5] == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            ShareElfFile.readUntilLimit(fileChannel, byteBuffer, "failed to read rest part of ehdr.");
            this.eType = byteBuffer.getShort();
            this.eMachine = byteBuffer.getShort();
            this.eVersion = byteBuffer.getInt();
            ShareElfFile.assertInRange(this.eVersion, 1, 1, "bad elf version: " + this.eVersion);
            switch (this.eIndent[4]) {
                case 1: {
                    this.eEntry = byteBuffer.getInt();
                    this.ePhOff = byteBuffer.getInt();
                    this.eShOff = byteBuffer.getInt();
                    break;
                }
                case 2: {
                    this.eEntry = byteBuffer.getLong();
                    this.ePhOff = byteBuffer.getLong();
                    this.eShOff = byteBuffer.getLong();
                    break;
                }
                default: {
                    throw new IOException("Unexpected elf class: " + this.eIndent[4]);
                }
            }
            this.eFlags = byteBuffer.getInt();
            this.eEhSize = byteBuffer.getShort();
            this.ePhEntSize = byteBuffer.getShort();
            this.ePhNum = byteBuffer.getShort();
            this.eShEntSize = byteBuffer.getShort();
            this.eShNum = byteBuffer.getShort();
            this.eShStrNdx = byteBuffer.getShort();
        }
    }
}

