/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class TinkerResourcePatcher {
    private static final String TAG = "Tinker.ResourcePatcher";
    private static final String TEST_ASSETS_VALUE = "only_use_to_test_tinker_resource.txt";
    private static Collection<WeakReference<Resources>> references = null;
    private static Object currentActivityThread = null;
    private static AssetManager newAssetManager = null;
    private static Method addAssetPathMethod = null;
    private static Method ensureStringBlocksMethod = null;
    private static Field assetsFiled = null;
    private static Field resourcesImplFiled = null;
    private static Field resDir = null;
    private static Field packagesFiled = null;
    private static Field resourcePackagesFiled = null;
    private static Field publicSourceDirField = null;

    TinkerResourcePatcher() {
    }

    public static void isResourceCanPatch(Context object) {
        AnnotatedElement annotatedElement;
        Object object2 = Class.forName("android.app.ActivityThread");
        currentActivityThread = ShareReflectUtil.getActivityThread((Context)object, object2);
        try {
            annotatedElement = Class.forName("android.app.LoadedApk");
        }
        catch (ClassNotFoundException classNotFoundException) {
            annotatedElement = Class.forName("android.app.ActivityThread$PackageInfo");
        }
        resDir = ((Class)annotatedElement).getDeclaredField("mResDir");
        resDir.setAccessible(true);
        packagesFiled = ((Class)object2).getDeclaredField("mPackages");
        packagesFiled.setAccessible(true);
        resourcePackagesFiled = ((Class)object2).getDeclaredField("mResourcePackages");
        resourcePackagesFiled.setAccessible(true);
        object = object.getAssets();
        if (object.getClass().getName().equals("android.content.res.BaiduAssetManager")) {
            object = Class.forName("android.content.res.BaiduAssetManager");
            newAssetManager = (AssetManager)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            newAssetManager = (AssetManager)AssetManager.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        addAssetPathMethod = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
        addAssetPathMethod.setAccessible(true);
        ensureStringBlocksMethod = AssetManager.class.getDeclaredMethod("ensureStringBlocks", new Class[0]);
        ensureStringBlocksMethod.setAccessible(true);
        if (Build.VERSION.SDK_INT >= 19) {
            object = Class.forName("android.app.ResourcesManager");
            object2 = ((Class)object).getDeclaredMethod("getInstance", new Class[0]);
            ((Method)object2).setAccessible(true);
            object2 = ((Method)object2).invoke(null, new Object[0]);
            try {
                annotatedElement = ((Class)object).getDeclaredField("mActiveResources");
                ((Field)annotatedElement).setAccessible(true);
                annotatedElement = (ArrayMap)((Field)annotatedElement).get(object2);
                references = annotatedElement.values();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                annotatedElement = ((Class)object).getDeclaredField("mResourceReferences");
                ((Field)annotatedElement).setAccessible(true);
                references = (Collection)((Field)annotatedElement).get(object2);
            }
        } else {
            object = ((Class)object2).getDeclaredField("mActiveResources");
            ((Field)object).setAccessible(true);
            object2 = (HashMap)((Field)object).get(currentActivityThread);
            references = ((HashMap)object2).values();
        }
        if (references == null) {
            throw new IllegalStateException("resource references is null");
        }
        try {
            assetsFiled = Resources.class.getDeclaredField("mAssets");
            assetsFiled.setAccessible(true);
        }
        catch (Throwable throwable) {
            resourcesImplFiled = Resources.class.getDeclaredField("mResourcesImpl");
            resourcesImplFiled.setAccessible(true);
        }
        try {
            publicSourceDirField = ShareReflectUtil.findField(ApplicationInfo.class, "publicSourceDir");
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void monkeyPatchExistingResources(Context context, String string) {
        void weakReference;
        if (string == null) {
            return;
        }
        Field[] fieldArray = new Field[]{packagesFiled, resourcePackagesFiled};
        boolean i = false;
        while (weakReference < 2) {
            Field field = fieldArray[weakReference];
            Object object = field.get(currentActivityThread);
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Object t = ((WeakReference)entry.getValue()).get();
                if (t == null || string == null) continue;
                resDir.set(t, string);
            }
            ++weakReference;
        }
        if ((Integer)addAssetPathMethod.invoke((Object)newAssetManager, string) == 0) {
            throw new IllegalStateException("Could not create new AssetManager");
        }
        ensureStringBlocksMethod.invoke((Object)newAssetManager, new Object[0]);
        for (WeakReference weakReference2 : references) {
            Resources resources = (Resources)weakReference2.get();
            if (resources == null) continue;
            try {
                assetsFiled.set(resources, newAssetManager);
            }
            catch (Throwable throwable) {
                Object object = resourcesImplFiled.get(resources);
                Field field = ShareReflectUtil.findField(object, "mAssets");
                field.setAccessible(true);
                field.set(object, newAssetManager);
            }
            TinkerResourcePatcher.clearPreloadTypedArrayIssue(resources);
            resources.updateConfiguration(resources.getConfiguration(), resources.getDisplayMetrics());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                if (publicSourceDirField != null) {
                    publicSourceDirField.set(context.getApplicationInfo(), string);
                }
            }
            catch (Throwable throwable) {}
        }
        if (!TinkerResourcePatcher.checkResUpdate(context)) {
            throw new TinkerRuntimeException("checkResInstall failed");
        }
    }

    private static void clearPreloadTypedArrayIssue(Resources resources) {
        Log.w((String)TAG, (String)"try to clear typedArray cache!");
        try {
            Field field = ShareReflectUtil.findField(Resources.class, "mTypedArrayPool");
            Object object = field.get(resources);
            Field field2 = ShareReflectUtil.findField(object, "mPool");
            Constructor<?> constructor = object.getClass().getConstructor(Integer.TYPE);
            constructor.setAccessible(true);
            int n = ((Object[])field2.get(object)).length;
            Object obj = constructor.newInstance(n);
            field.set(resources, obj);
            return;
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)("clearPreloadTypedArrayIssue failed, ignore error: " + throwable));
            return;
        }
    }

    private static boolean checkResUpdate(Context context) {
        try {
            Log.e((String)TAG, (String)"checkResUpdate success, found test resource assets file only_use_to_test_tinker_resource.txt");
            context.getAssets().open(TEST_ASSETS_VALUE);
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)("checkResUpdate failed, can't find test resource assets file only_use_to_test_tinker_resource.txt e:" + throwable.getMessage()));
            return false;
        }
        return true;
    }
}

