/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.util.Log;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public final class TinkerParallelDexOptimizer {
    private static final String TAG = "Tinker.ParallelDex";
    private static final int DEFAULT_THREAD_COUNT = 2;

    public static boolean optimizeAll(Collection<File> collection, File file, ResultCallback resultCallback) {
        return TinkerParallelDexOptimizer.optimizeAll(collection, file, false, null, resultCallback);
    }

    public static boolean optimizeAll(Collection<File> collection, File file, boolean bl, String string, ResultCallback resultCallback) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return TinkerParallelDexOptimizer.optimizeAllLocked(collection, file, bl, string, atomicInteger, resultCallback, 2);
    }

    private static synchronized boolean optimizeAllLocked(Collection<File> collection, File file, boolean bl, String string, AtomicInteger atomicInteger, ResultCallback resultCallback, int n) {
        CountDownLatch countDownLatch = new CountDownLatch(collection.size());
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        long l = System.nanoTime();
        Object object = new ArrayList<File>(collection);
        Collections.sort(object, new Comparator<File>(){

            @Override
            public final int compare(File file, File file2) {
                long l = file.length() - file2.length();
                if (l > 0L) {
                    return 1;
                }
                if (l == 0L) {
                    return 0;
                }
                return -1;
            }
        });
        Collections.reverse(object);
        Iterator<File> iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            object = new OptimizeWorker(file2, file, bl, string, atomicInteger, countDownLatch, resultCallback);
            executorService.submit((Runnable)object);
        }
        try {
            countDownLatch.await();
            long l2 = (System.nanoTime() - l) / 1000000L;
            if (atomicInteger.get() == collection.size()) {
                Log.i((String)TAG, (String)("All dexes are optimized successfully, cost: " + l2 + " ms."));
                return true;
            }
            Log.e((String)TAG, (String)"Dexes optimizing failed, some dexes are not optimized.");
            return false;
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)TAG, (String)"Dex optimizing was interrupted.", (Throwable)interruptedException);
            return false;
        }
        finally {
            executorService.shutdown();
        }
    }

    static class StreamConsumer {
        static final Executor STREAM_CONSUMER = Executors.newSingleThreadExecutor();

        private StreamConsumer() {
        }

        static void consumeInputStream(final InputStream inputStream) {
            STREAM_CONSUMER.execute(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public final void run() {
                    if (inputStream == null) {
                        return;
                    }
                    byte[] byArray = new byte[256];
                    try {
                        while (inputStream.read(byArray) > 0) {
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            inputStream.close();
                            return;
                        }
                        catch (Exception exception) {
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            });
        }
    }

    static class OptimizeWorker
    implements Runnable {
        private static String targetISA = null;
        private final File dexFile;
        private final File optimizedDir;
        private final boolean useInterpretMode;
        private final AtomicInteger successCount;
        private final CountDownLatch waitingLatch;
        private final ResultCallback callback;

        OptimizeWorker(File file, File file2, boolean bl, String string, AtomicInteger atomicInteger, CountDownLatch countDownLatch, ResultCallback resultCallback) {
            this.dexFile = file;
            this.optimizedDir = file2;
            this.useInterpretMode = bl;
            this.successCount = atomicInteger;
            this.waitingLatch = countDownLatch;
            this.callback = resultCallback;
            targetISA = string;
        }

        @Override
        public void run() {
            try {
                if (!SharePatchFileUtil.isLegalFile(this.dexFile) && this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, new IOException("dex file " + this.dexFile.getAbsolutePath() + " is not exist!"));
                }
                if (this.callback != null) {
                    this.callback.onStart(this.dexFile, this.optimizedDir);
                }
                String string = SharePatchFileUtil.optimizedPathFor(this.dexFile, this.optimizedDir);
                if (this.useInterpretMode) {
                    this.interpretDex2Oat(this.dexFile.getAbsolutePath(), string);
                } else {
                    DexFile.loadDex((String)this.dexFile.getAbsolutePath(), (String)string, (int)0);
                }
                this.successCount.incrementAndGet();
                if (this.callback != null) {
                    this.callback.onSuccess(this.dexFile, this.optimizedDir, new File(string));
                }
                return;
            }
            catch (Throwable throwable) {
                Log.e((String)TinkerParallelDexOptimizer.TAG, (String)("Failed to optimize dex: " + this.dexFile.getAbsolutePath()), (Throwable)throwable);
                if (this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, throwable);
                }
                return;
            }
            finally {
                this.waitingLatch.countDown();
            }
        }

        private void interpretDex2Oat(String object, String string) {
            Serializable serializable = new File(string);
            if (!((File)serializable).exists()) {
                ((File)serializable).getParentFile().mkdirs();
            }
            serializable = new ArrayList<String>();
            serializable.add("dex2oat");
            serializable.add("--dex-file=" + (String)object);
            serializable.add("--oat-file=" + string);
            serializable.add("--instruction-set=" + targetISA);
            serializable.add("--compiler-filter=interpret-only");
            object = new ProcessBuilder((List<String>)((Object)serializable));
            ((ProcessBuilder)object).redirectErrorStream(true);
            object = ((ProcessBuilder)object).start();
            StreamConsumer.consumeInputStream(((Process)object).getInputStream());
            StreamConsumer.consumeInputStream(((Process)object).getErrorStream());
            try {
                int n = ((Process)object).waitFor();
                if (n != 0) {
                    throw new IOException("dex2oat works unsuccessfully, exit code: " + n);
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("dex2oat is interrupted, msg: " + interruptedException.getMessage(), interruptedException);
            }
        }
    }

    public static interface ResultCallback {
        public void onStart(File var1, File var2);

        public void onSuccess(File var1, File var2, File var3);

        public void onFailed(File var1, File var2, Throwable var3);
    }
}

