/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.content.Intent;
import android.util.Log;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.TinkerParallelDexOptimizer;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareOatUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class TinkerDexLoader {
    private static final String TAG = "Tinker.TinkerDexLoader";
    private static final String DEX_MEAT_FILE = "assets/dex_meta.txt";
    private static final String DEX_PATH = "dex";
    private static final String DEFAULT_DEX_OPTIMIZE_PATH = "odex";
    private static final String INTERPRET_DEX_OPTIMIZE_PATH = "interpet";
    private static final ArrayList<ShareDexDiffPatchInfo> dexList = new ArrayList();
    private static File testOptDexFile;

    private TinkerDexLoader() {
    }

    @TargetApi(value=14)
    public static boolean loadTinkerJars(TinkerApplication tinkerApplication, String string, String string2, Intent intent, boolean bl) {
        Object object;
        Throwable[] throwableArray;
        if (dexList.isEmpty()) {
            Log.w((String)TAG, (String)"there is no dex to load");
            return true;
        }
        PathClassLoader pathClassLoader = (PathClassLoader)TinkerDexLoader.class.getClassLoader();
        if (pathClassLoader == null) {
            Log.e((String)TAG, (String)"classloader is null");
            ShareIntentUtil.setIntentReturnCode(intent, -12);
            return false;
        }
        Log.i((String)TAG, (String)("classloader: " + pathClassLoader.toString()));
        String string3 = string + "/dex" + "/";
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl2 = ShareTinkerInternals.isVmArt();
        for (ShareDexDiffPatchInfo throwable : dexList) {
            if (TinkerDexLoader.isJustArtSupportDex(throwable)) continue;
            throwableArray = string3 + throwable.realName;
            object = new File((String)throwableArray);
            if (tinkerApplication.isTinkerLoadVerifyFlag()) {
                String string4;
                long l = System.currentTimeMillis();
                String string5 = string4 = bl2 ? throwable.destMd5InArt : throwable.destMd5InDvm;
                if (!SharePatchFileUtil.verifyDexFileMd5((File)object, string4)) {
                    ShareIntentUtil.setIntentReturnCode(intent, -13);
                    intent.putExtra("intent_patch_mismatch_dex_path", ((File)object).getAbsolutePath());
                    return false;
                }
                Log.i((String)TAG, (String)("verify dex file:" + ((File)object).getPath() + " md5, use time: " + (System.currentTimeMillis() - l)));
            }
            arrayList.add((File)object);
        }
        Object object4 = new File(string + "/" + string2);
        if (bl) {
            final boolean[] blArray = new boolean[]{true};
            throwableArray = new Throwable[1];
            try {
                object = ShareOatUtil.getOatFileInstructionSet(testOptDexFile);
            }
            catch (Throwable throwable) {
                TinkerDexLoader.deleteOutOfDateOATFile(string);
                intent.putExtra("intent_patch_interpret_exception", (Serializable)throwable);
                ShareIntentUtil.setIntentReturnCode(intent, -15);
                return false;
            }
            TinkerDexLoader.deleteOutOfDateOATFile(string);
            Log.w((String)TAG, (String)("systemOTA, try parallel oat dexes, targetISA:" + (String)object));
            object4 = new File(string + "/interpet");
            TinkerParallelDexOptimizer.optimizeAll(arrayList, (File)object4, true, (String)object, new TinkerParallelDexOptimizer.ResultCallback(){
                long start;

                @Override
                public final void onStart(File file, File file2) {
                    this.start = System.currentTimeMillis();
                    Log.i((String)TinkerDexLoader.TAG, (String)("start to optimize dex:" + file.getPath()));
                }

                @Override
                public final void onSuccess(File file, File file2, File file3) {
                    Log.i((String)TinkerDexLoader.TAG, (String)("success to optimize dex " + file.getPath() + ", use time " + (System.currentTimeMillis() - this.start)));
                }

                @Override
                public final void onFailed(File file, File file2, Throwable throwable) {
                    blArray[0] = false;
                    throwableArray[0] = throwable;
                    Log.i((String)TinkerDexLoader.TAG, (String)("fail to optimize dex " + file.getPath() + ", use time " + (System.currentTimeMillis() - this.start)));
                }
            });
            if (!blArray[0]) {
                Log.e((String)TAG, (String)"parallel oat dexes failed");
                intent.putExtra("intent_patch_interpret_exception", (Serializable)throwableArray);
                ShareIntentUtil.setIntentReturnCode(intent, -16);
                return false;
            }
        }
        try {
            SystemClassLoaderAdder.installDexes(tinkerApplication, pathClassLoader, (File)object4, arrayList);
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"install dexes failed");
            intent.putExtra("intent_patch_exception", (Serializable)throwable);
            ShareIntentUtil.setIntentReturnCode(intent, -14);
            return false;
        }
        return true;
    }

    public static boolean checkComplete(String object, ShareSecurityCheck hashMap, String object2, Intent intent) {
        if ((hashMap = ((ShareSecurityCheck)((Object)hashMap)).getMetaContentMap().get(DEX_MEAT_FILE)) == null) {
            return true;
        }
        dexList.clear();
        ShareDexDiffPatchInfo.parseDexDiffPatchInfo((String)((Object)hashMap), dexList);
        if (dexList.isEmpty()) {
            return true;
        }
        hashMap = new HashMap<String, String>();
        for (ShareDexDiffPatchInfo object32 : dexList) {
            if (TinkerDexLoader.isJustArtSupportDex(object32)) continue;
            if (!ShareDexDiffPatchInfo.checkDexDiffPatchInfo(object32)) {
                intent.putExtra("intent_patch_package_patch_check", -3);
                ShareIntentUtil.setIntentReturnCode(intent, -8);
                return false;
            }
            hashMap.put(object32.realName, object32.destMd5InDvm);
        }
        String string = (String)object + "/dex" + "/";
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intent, -9);
            return false;
        }
        object = (String)object + "/" + (String)((Object)object2) + "/";
        object = new File((String)object);
        for (String string2 : hashMap.keySet()) {
            File file2 = new File((String)string + string2);
            if (!SharePatchFileUtil.isLegalFile(file2)) {
                intent.putExtra("intent_patch_missing_dex_path", file2.getAbsolutePath());
                ShareIntentUtil.setIntentReturnCode(intent, -10);
                return false;
            }
            File file3 = new File(SharePatchFileUtil.optimizedPathFor(file2, (File)object));
            if (!SharePatchFileUtil.isLegalFile(file3)) {
                intent.putExtra("intent_patch_missing_dex_path", file3.getAbsolutePath());
                ShareIntentUtil.setIntentReturnCode(intent, -11);
                return false;
            }
            if (!file3.getName().startsWith("test.dex")) continue;
            testOptDexFile = file3;
        }
        intent.putExtra("intent_patch_dexes_path", hashMap);
        return true;
    }

    private static void deleteOutOfDateOATFile(String string) {
        string = string + "/odex" + "/";
        SharePatchFileUtil.deleteDir(string);
    }

    private static boolean isJustArtSupportDex(ShareDexDiffPatchInfo object) {
        if (ShareTinkerInternals.isVmArt()) {
            return false;
        }
        object = ((ShareDexDiffPatchInfo)object).destMd5InDvm;
        return ((String)object).equals("0");
    }
}

