/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Build;
import android.util.Log;
import com.tencent.tinker.loader.AndroidNClassLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;

public class SystemClassLoaderAdder {
    public static final String CHECK_DEX_CLASS = "com.tencent.tinker.loader.TinkerTestDexLoad";
    public static final String CHECK_DEX_FIELD = "isPatch";
    private static final String TAG = "Tinker.ClassLoaderAdder";
    private static int sPatchDexCount = 0;

    @SuppressLint(value={"NewApi"})
    public static void installDexes(Application application, PathClassLoader pathClassLoader, File file, List<File> list) {
        Log.i((String)TAG, (String)("installDexes dexOptDir: " + file.getAbsolutePath() + ", dex size:" + list.size()));
        if (!list.isEmpty()) {
            PathClassLoader pathClassLoader2 = pathClassLoader;
            if (Build.VERSION.SDK_INT >= 24) {
                pathClassLoader2 = AndroidNClassLoader.inject(pathClassLoader, application);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                V23.install((ClassLoader)pathClassLoader2, list, file);
            } else if (Build.VERSION.SDK_INT >= 19) {
                V19.install((ClassLoader)pathClassLoader2, list, file);
            } else if (Build.VERSION.SDK_INT >= 14) {
                V14.install((ClassLoader)pathClassLoader2, list, file);
            } else {
                V4.install((ClassLoader)pathClassLoader2, list, file);
            }
            sPatchDexCount = list.size();
            Log.i((String)TAG, (String)("after loaded classloader: " + pathClassLoader2 + ", dex size:" + sPatchDexCount));
            if (!SystemClassLoaderAdder.checkDexInstall((ClassLoader)pathClassLoader2)) {
                SystemClassLoaderAdder.uninstallPatchDex((ClassLoader)pathClassLoader2);
                throw new TinkerRuntimeException("checkDexInstall failed");
            }
        }
    }

    public static void uninstallPatchDex(ClassLoader object) {
        if (sPatchDexCount <= 0) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            Field field = ShareReflectUtil.findField(object, "pathList");
            object = field.get(object);
            ShareReflectUtil.reduceFieldArray(object, "dexElements", sPatchDexCount);
            return;
        }
        ShareReflectUtil.reduceFieldArray(object, "mPaths", sPatchDexCount);
        ShareReflectUtil.reduceFieldArray(object, "mFiles", sPatchDexCount);
        ShareReflectUtil.reduceFieldArray(object, "mZips", sPatchDexCount);
        try {
            ShareReflectUtil.reduceFieldArray(object, "mDexs", sPatchDexCount);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static boolean checkDexInstall(ClassLoader object) {
        object = Class.forName(CHECK_DEX_CLASS, true, (ClassLoader)object);
        object = ShareReflectUtil.findField(object, CHECK_DEX_FIELD);
        boolean bl = (Boolean)((Field)object).get(null);
        Log.w((String)TAG, (String)("checkDexInstall result:" + bl));
        return bl;
    }

    static final class V4 {
        private V4() {
        }

        private static void install(ClassLoader classLoader, List<File> object, File file) {
            int n = object.size();
            Field field = ShareReflectUtil.findField(classLoader, "path");
            StringBuilder stringBuilder = new StringBuilder((String)field.get(classLoader));
            Object[] objectArray = new String[n];
            Object[] objectArray2 = new File[n];
            Object[] objectArray3 = new ZipFile[n];
            Object[] objectArray4 = new DexFile[n];
            object = object.listIterator();
            while (object.hasNext()) {
                Object object2 = (File)object.next();
                String string = ((File)object2).getAbsolutePath();
                stringBuilder.append(':').append(string);
                int n2 = object.previousIndex();
                objectArray[n2] = string;
                objectArray2[n2] = object2;
                objectArray3[n2] = new ZipFile((File)object2);
                object2 = SharePatchFileUtil.optimizedPathFor((File)object2, file);
                objectArray4[n2] = DexFile.loadDex((String)string, (String)object2, (int)0);
            }
            field.set(classLoader, stringBuilder.toString());
            ShareReflectUtil.expandFieldArray(classLoader, "mPaths", objectArray);
            ShareReflectUtil.expandFieldArray(classLoader, "mFiles", objectArray2);
            ShareReflectUtil.expandFieldArray(classLoader, "mZips", objectArray3);
            try {
                ShareReflectUtil.expandFieldArray(classLoader, "mDexs", objectArray4);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    static final class V14 {
        private V14() {
        }

        private static void install(ClassLoader object, List<File> list, File file) {
            Field field = ShareReflectUtil.findField(object, "pathList");
            object = field.get(object);
            ShareReflectUtil.expandFieldArray(object, "dexElements", V14.makeDexElements(object, new ArrayList<File>(list), file));
        }

        private static Object[] makeDexElements(Object object, ArrayList<File> arrayList, File file) {
            Method method = ShareReflectUtil.findMethod(object, "makeDexElements", ArrayList.class, File.class);
            return (Object[])method.invoke(object, arrayList, file);
        }
    }

    static final class V19 {
        private V19() {
        }

        private static void install(ClassLoader object, List<File> list, File file) {
            Object object2 = ShareReflectUtil.findField(object, "pathList");
            object = ((Field)object2).get(object);
            object2 = new ArrayList();
            ShareReflectUtil.expandFieldArray(object, "dexElements", V19.makeDexElements(object, new ArrayList<File>(list), file, (ArrayList<IOException>)object2));
            if (((ArrayList)object2).size() > 0 && (object = ((ArrayList)object2).iterator()).hasNext()) {
                object = (IOException)object.next();
                Log.w((String)SystemClassLoaderAdder.TAG, (String)"Exception in makeDexElement", (Throwable)object);
                throw object;
            }
        }

        private static Object[] makeDexElements(Object object, ArrayList<File> arrayList, File file, ArrayList<IOException> arrayList2) {
            Method method;
            try {
                method = ShareReflectUtil.findMethod(object, "makeDexElements", ArrayList.class, File.class, ArrayList.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makeDexElements(ArrayList,File,ArrayList) failure");
                try {
                    method = ShareReflectUtil.findMethod(object, "makeDexElements", List.class, File.class, List.class);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makeDexElements(List,File,List) failure");
                    throw noSuchMethodException2;
                }
            }
            return (Object[])method.invoke(object, arrayList, file, arrayList2);
        }
    }

    static final class V23 {
        private V23() {
        }

        private static void install(ClassLoader object, List<File> list, File file) {
            Object object2 = ShareReflectUtil.findField(object, "pathList");
            object = ((Field)object2).get(object);
            object2 = new ArrayList();
            ShareReflectUtil.expandFieldArray(object, "dexElements", V23.makePathElements(object, new ArrayList<File>(list), file, (ArrayList<IOException>)object2));
            if (((ArrayList)object2).size() > 0 && (object = ((ArrayList)object2).iterator()).hasNext()) {
                object = (IOException)object.next();
                Log.w((String)SystemClassLoaderAdder.TAG, (String)"Exception in makePathElement", (Throwable)object);
                throw object;
            }
        }

        private static Object[] makePathElements(Object object, ArrayList<File> arrayList, File file, ArrayList<IOException> arrayList2) {
            Method method;
            try {
                method = ShareReflectUtil.findMethod(object, "makePathElements", List.class, File.class, List.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makePathElements(List,File,List) failure");
                try {
                    method = ShareReflectUtil.findMethod(object, "makePathElements", ArrayList.class, File.class, ArrayList.class);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makeDexElements(ArrayList,File,ArrayList) failure");
                    try {
                        Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: try use v19 instead");
                        return V19.makeDexElements(object, arrayList, file, arrayList2);
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        Log.e((String)SystemClassLoaderAdder.TAG, (String)"NoSuchMethodException: makeDexElements(List,File,List) failure");
                        throw noSuchMethodException3;
                    }
                }
            }
            return (Object[])method.invoke(object, arrayList, file, arrayList2);
        }
    }
}

