/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=14)
class AndroidNClassLoader
extends PathClassLoader {
    private static final String TAG = "Tinker.NClassLoader";
    private static final String CHECK_CLASSLOADER_CLASS = "com.tencent.tinker.loader.TinkerTestAndroidNClassLoader";
    private static ArrayList<DexFile> oldDexFiles = new ArrayList();
    private final PathClassLoader originClassLoader;
    private String applicationClassName;

    private AndroidNClassLoader(String string, PathClassLoader pathClassLoader, Application application) {
        super(string, pathClassLoader.getParent());
        this.originClassLoader = pathClassLoader;
        string = application.getClass().getName();
        if (string != null && !string.equals("android.app.Application")) {
            this.applicationClassName = string;
        }
    }

    private static AndroidNClassLoader createAndroidNClassLoader(PathClassLoader object, Application application) {
        AndroidNClassLoader androidNClassLoader = new AndroidNClassLoader("", (PathClassLoader)object, application);
        Object object2 = ShareReflectUtil.findField(object, "pathList");
        object = ((Field)object2).get(object);
        object2 = ShareReflectUtil.findField(object, "definingContext");
        ((Field)object2).set(object, (Object)androidNClassLoader);
        object2 = ShareReflectUtil.findField((Object)androidNClassLoader, "pathList");
        ((Field)object2).set((Object)androidNClassLoader, object);
        object2 = new ArrayList();
        Field field = ShareReflectUtil.findField(object, "dexElements");
        Object[] objectArray = (Object[])field.get(object);
        Object object3 = objectArray;
        object3 = objectArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object4 = object3[i];
            if ((object4 = (DexFile)ShareReflectUtil.findField(object4, "dexFile").get(object4)) == null) continue;
            object2.add(new File(object4.getName()));
            oldDexFiles.add((DexFile)object4);
        }
        object3 = ShareReflectUtil.findMethod(object, "makePathElements", List.class, File.class, List.class);
        ArrayList arrayList = new ArrayList();
        Object[] objectArray2 = (Object[])((Method)object3).invoke(object, object2, null, arrayList);
        field.set(object, objectArray2);
        try {
            Class.forName(CHECK_CLASSLOADER_CLASS, true, (ClassLoader)((Object)androidNClassLoader));
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"load TinkerTestAndroidNClassLoader fail, try to fixDexElementsForProtectedApp");
            AndroidNClassLoader.fixDexElementsForProtectedApp(application, objectArray2);
        }
        return androidNClassLoader;
    }

    private static void reflectPackageInfoClassloader(Application object, ClassLoader classLoader) {
        Object object2 = "mBase";
        String string = "mPackageInfo";
        String string2 = "mClassLoader";
        object = (Context)ShareReflectUtil.findField(object, (String)object2).get(object);
        object = ShareReflectUtil.findField(object, string).get(object);
        object2 = ShareReflectUtil.findField(object, string2);
        Thread.currentThread().setContextClassLoader(classLoader);
        ((Field)object2).set(object, classLoader);
    }

    public static AndroidNClassLoader inject(PathClassLoader pathClassLoader, Application application) {
        pathClassLoader = AndroidNClassLoader.createAndroidNClassLoader(pathClassLoader, application);
        AndroidNClassLoader.reflectPackageInfoClassloader(application, (ClassLoader)pathClassLoader);
        return pathClassLoader;
    }

    private static void fixDexElementsForProtectedApp(Application application, Object[] objectArray) {
        Field field = null;
        Field field2 = null;
        Field field3 = ShareReflectUtil.findField(DexFile.class, "mFileName");
        Field field4 = ShareReflectUtil.findField(DexFile.class, "mCookie");
        Field field5 = ShareReflectUtil.findField(DexFile.class, "mInternalCookie");
        for (int i = 0; i < objectArray.length - 1; ++i) {
            Object object = objectArray[i];
            if (field == null && field2 == null) {
                field = ShareReflectUtil.findField(object, "zip");
                field2 = ShareReflectUtil.findField(object, "dexFile");
            }
            Object object2 = oldDexFiles.get(i);
            String string = (String)field3.get(object2);
            Object object3 = field4.get(object2);
            object2 = field5.get(object2);
            DexFile dexFile = DexFile.loadDex((String)application.getApplicationInfo().sourceDir, null, (int)0);
            field3.set(dexFile, string);
            field4.set(dexFile, object3);
            field5.set(dexFile, object2);
            field2.set(object, dexFile);
            object2 = (File)field.get(object);
            if ((object2 = object2 != null ? ((File)object2).getAbsolutePath() : null) == null || ((String)object2).endsWith(".zip") || ((String)object2).endsWith(".jar") || ((String)object2).endsWith(".apk")) continue;
            field.set(object, null);
        }
    }

    public Class<?> findClass(String string) {
        if (string != null && string.startsWith("com.tencent.tinker.loader.") && !string.equals("com.tencent.tinker.loader.TinkerTestDexLoad") && !string.equals(CHECK_CLASSLOADER_CLASS) || this.applicationClassName != null && TextUtils.equals((CharSequence)this.applicationClassName, (CharSequence)string)) {
            return this.originClassLoader.loadClass(string);
        }
        return super.findClass(string);
    }

    public String findLibrary(String string) {
        return super.findLibrary(string);
    }
}

