/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.util;

import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.lib.service.TinkerPatchService;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;

public class UpgradePatchRetry {
    private static final String TAG = "Tinker.UpgradePatchRetry";
    private static final String RETRY_INFO_NAME = "patch.retry";
    private static final String TEMP_PATCH_NAME = "temp.apk";
    private static final String RETRY_FILE_MD5_PROPERTY = "md5";
    private static final String RETRY_COUNT_PROPERTY = "times";
    private static final int RETRY_MAX_COUNT = 4;
    private static UpgradePatchRetry sInstance;
    private boolean isRetryEnable = true;
    private File retryInfoFile = null;
    private File tempPatchFile = null;
    private Context context = null;
    private int maxRetryCount = 4;

    public UpgradePatchRetry(Context context) {
        this.context = context;
        this.retryInfoFile = new File(SharePatchFileUtil.getPatchTempDirectory(context), RETRY_INFO_NAME);
        this.tempPatchFile = new File(SharePatchFileUtil.getPatchTempDirectory(context), TEMP_PATCH_NAME);
    }

    public static UpgradePatchRetry getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new UpgradePatchRetry(context);
        }
        return sInstance;
    }

    public void setRetryEnable(boolean bl) {
        this.isRetryEnable = bl;
    }

    public void setMaxRetryCount(int n) {
        if (n <= 0) {
            TinkerLog.e(TAG, "max count must large than 0", new Object[0]);
            return;
        }
        this.maxRetryCount = n;
    }

    public boolean onPatchRetryLoad() {
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchRetryLoad retry disabled, just return", new Object[0]);
            return false;
        }
        Object object = Tinker.with(this.context);
        if (!((Tinker)object).isMainProcess()) {
            TinkerLog.w(TAG, "onPatchRetryLoad retry is not main process, just return", new Object[0]);
            return false;
        }
        if (!this.retryInfoFile.exists()) {
            TinkerLog.w(TAG, "onPatchRetryLoad retry info not exist, just return", new Object[0]);
            return false;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning(this.context)) {
            TinkerLog.w(TAG, "onPatchRetryLoad tinker service is running, just return", new Object[0]);
            return false;
        }
        object = this.tempPatchFile.getAbsolutePath();
        if (object == null || !new File((String)object).exists()) {
            TinkerLog.w(TAG, "onPatchRetryLoad patch file: %s is not exist, just return", object);
            return false;
        }
        TinkerLog.w(TAG, "onPatchRetryLoad patch file: %s is exist, retry to patch", object);
        TinkerInstaller.onReceiveUpgradePatch(this.context, (String)object);
        return true;
    }

    public void onPatchServiceStart(Intent object) {
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchServiceStart retry disabled, just return", new Object[0]);
            return;
        }
        if (object == null) {
            TinkerLog.e(TAG, "onPatchServiceStart intent is null, just return", new Object[0]);
            return;
        }
        if ((object = TinkerPatchService.getPatchPathExtra(object)) == null) {
            TinkerLog.w(TAG, "onPatchServiceStart patch path is null, just return", new Object[0]);
            return;
        }
        File file = new File((String)object);
        String string = SharePatchFileUtil.getMD5(file);
        if (string == null) {
            TinkerLog.w(TAG, "onPatchServiceStart patch md5 is null, just return", new Object[0]);
            return;
        }
        if (this.retryInfoFile.exists()) {
            object = RetryInfo.readRetryProperty(this.retryInfoFile);
            if (object.md5 == null || object.times == null || !string.equals(object.md5)) {
                this.copyToTempFile(file);
                object.md5 = string;
                object.times = "1";
            } else {
                int n = Integer.parseInt(object.times);
                if (n >= this.maxRetryCount) {
                    SharePatchFileUtil.safeDeleteFile(this.tempPatchFile);
                    TinkerLog.w(TAG, "onPatchServiceStart retry more than max count, delete retry info file!", new Object[0]);
                    return;
                }
                object.times = String.valueOf(n + 1);
            }
        } else {
            this.copyToTempFile(file);
            object = new RetryInfo(string, "1");
        }
        RetryInfo.writeRetryProperty(this.retryInfoFile, (RetryInfo)object);
    }

    public boolean onPatchListenerCheck(String string) {
        int n;
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchListenerCheck retry disabled, just return", new Object[0]);
            return true;
        }
        if (!this.retryInfoFile.exists()) {
            TinkerLog.w(TAG, "onPatchListenerCheck retry file is not exist, just return", new Object[0]);
            return true;
        }
        if (string == null) {
            TinkerLog.w(TAG, "onPatchListenerCheck md5 is null, just return", new Object[0]);
            return true;
        }
        RetryInfo retryInfo = RetryInfo.readRetryProperty(this.retryInfoFile);
        if (string.equals(retryInfo.md5) && (n = Integer.parseInt(retryInfo.times)) >= this.maxRetryCount) {
            TinkerLog.w(TAG, "onPatchListenerCheck, retry count %d must exceed than max retry count", n);
            SharePatchFileUtil.safeDeleteFile(this.tempPatchFile);
            return false;
        }
        return true;
    }

    public void onPatchServiceResult() {
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchServiceResult retry disabled, just return", new Object[0]);
            return;
        }
        if (this.tempPatchFile.exists()) {
            SharePatchFileUtil.safeDeleteFile(this.tempPatchFile);
        }
    }

    private void copyToTempFile(File file) {
        if (file.getAbsolutePath().equals(this.tempPatchFile.getAbsolutePath())) {
            return;
        }
        TinkerLog.w(TAG, "try copy file: %s to %s", file.getAbsolutePath(), this.tempPatchFile.getAbsolutePath());
        try {
            SharePatchFileUtil.copyFileUsingStream(file, this.tempPatchFile);
            return;
        }
        catch (IOException iOException) {
            TinkerLog.e(TAG, "fail to copy file: %s to %s", file.getAbsolutePath(), this.tempPatchFile.getAbsolutePath());
            return;
        }
    }

    static class RetryInfo {
        String md5;
        String times;

        RetryInfo(String string, String string2) {
            this.md5 = string;
            this.times = string2;
        }

        static RetryInfo readRetryProperty(File file) {
            String string = null;
            String string2 = null;
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                string = properties.getProperty(UpgradePatchRetry.RETRY_FILE_MD5_PROPERTY);
                string2 = properties.getProperty(UpgradePatchRetry.RETRY_COUNT_PROPERTY);
            }
            catch (IOException iOException) {
                try {
                    TinkerLog.e(UpgradePatchRetry.TAG, "fail to readRetryProperty:" + iOException, new Object[0]);
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(fileInputStream);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(fileInputStream);
            }
            SharePatchFileUtil.closeQuietly(fileInputStream);
            return new RetryInfo(string, string2);
        }

        static void writeRetryProperty(File file, RetryInfo object) {
            if (object == null) {
                return;
            }
            Serializable serializable = file.getParentFile();
            if (!((File)serializable).exists()) {
                ((File)serializable).mkdirs();
            }
            serializable = new Properties();
            ((Properties)serializable).put(UpgradePatchRetry.RETRY_FILE_MD5_PROPERTY, ((RetryInfo)object).md5);
            ((Properties)serializable).put(UpgradePatchRetry.RETRY_COUNT_PROPERTY, ((RetryInfo)object).times);
            object = null;
            try {
                object = new FileOutputStream(file, false);
                ((Properties)serializable).store((OutputStream)object, null);
                return;
            }
            catch (Exception exception) {
                TinkerLog.printErrStackTrace(UpgradePatchRetry.TAG, exception, "retry write property fail", new Object[0]);
                return;
            }
            finally {
                SharePatchFileUtil.closeQuietly((Closeable)object);
            }
        }
    }
}

