/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.tinker;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.util.HashMap;

public class TinkerLoadResult {
    private static final String TAG = "Tinker.TinkerLoadResult";
    public SharePatchInfo patchInfo;
    public String currentVersion;
    public String oatDir;
    public boolean versionChanged;
    public boolean useInterpretMode;
    public boolean systemOTA;
    public File patchVersionDirectory;
    public File patchVersionFile;
    public File dexDirectory;
    public File libraryDirectory;
    public File resourceDirectory;
    public File resourceFile;
    public HashMap<String, String> dexes;
    public HashMap<String, String> libs;
    public HashMap<String, String> packageConfig;
    public int loadCode;
    public long costTime;

    public boolean parseTinkerResult(Context object, Intent intent) {
        Object object2;
        Tinker tinker = Tinker.with((Context)object);
        this.loadCode = ShareIntentUtil.getIntentReturnCode(intent);
        this.costTime = ShareIntentUtil.getIntentPatchCostTime(intent);
        this.systemOTA = ShareIntentUtil.getBooleanExtra(intent, "intent_patch_system_ota", false);
        this.oatDir = ShareIntentUtil.getStringExtra(intent, "intent_patch_oat_dir");
        this.useInterpretMode = "interpet".equals(this.oatDir);
        boolean bl = tinker.isMainProcess();
        TinkerLog.i(TAG, "parseTinkerResult loadCode:%d, process name:%s, main process:%b, systemOTA:%b, oatDir:%s, useInterpretMode:%b", this.loadCode, ShareTinkerInternals.getProcessName((Context)object), bl, this.systemOTA, this.oatDir, this.useInterpretMode);
        object = ShareIntentUtil.getStringExtra(intent, "intent_patch_old_version");
        String string = ShareIntentUtil.getStringExtra(intent, "intent_patch_new_version");
        File file = tinker.getPatchDirectory();
        File file2 = tinker.getPatchInfoFile();
        if (object != null && string != null) {
            this.currentVersion = bl ? string : object;
            TinkerLog.i(TAG, "parseTinkerResult oldVersion:%s, newVersion:%s, current:%s", object, string, this.currentVersion);
            object2 = SharePatchFileUtil.getPatchVersionDirectory(this.currentVersion);
            if (!ShareTinkerInternals.isNullOrNil((String)object2)) {
                this.patchVersionDirectory = new File(file.getAbsolutePath() + "/" + (String)object2);
                this.patchVersionFile = new File(this.patchVersionDirectory.getAbsolutePath(), SharePatchFileUtil.getPatchVersionFile(this.currentVersion));
                this.dexDirectory = new File(this.patchVersionDirectory, "dex");
                this.libraryDirectory = new File(this.patchVersionDirectory, "lib");
                this.resourceDirectory = new File(this.patchVersionDirectory, "res");
                this.resourceFile = new File(this.resourceDirectory, "resources.apk");
            }
            this.patchInfo = new SharePatchInfo((String)object, string, Build.FINGERPRINT, this.oatDir);
            boolean bl2 = this.versionChanged = !((String)object).equals(string);
        }
        if ((object2 = ShareIntentUtil.getIntentPatchException(intent)) != null) {
            TinkerLog.i(TAG, "Tinker load have exception loadCode:%d", this.loadCode);
            int n = -1;
            switch (this.loadCode) {
                case -20: {
                    n = -1;
                    break;
                }
                case -14: {
                    n = -2;
                    break;
                }
                case -23: {
                    n = -3;
                    break;
                }
                case -25: {
                    n = -4;
                }
            }
            tinker.getLoadReporter().onLoadException((Throwable)object2, n);
            return false;
        }
        switch (this.loadCode) {
            case -10000: {
                TinkerLog.e(TAG, "can't get the right intent return code", new Object[0]);
                throw new TinkerRuntimeException("can't get the right intent return code");
            }
            case -1: {
                TinkerLog.w(TAG, "tinker is disable, just return", new Object[0]);
                break;
            }
            case -3: 
            case -2: {
                TinkerLog.w(TAG, "can't find patch file, is ok, just return", new Object[0]);
                break;
            }
            case -4: {
                TinkerLog.e(TAG, "path info corrupted", new Object[0]);
                tinker.getLoadReporter().onLoadPatchInfoCorrupted((String)object, string, file2);
                break;
            }
            case -5: {
                TinkerLog.e(TAG, "path info blank, wait main process to restart", new Object[0]);
                break;
            }
            case -6: {
                TinkerLog.e(TAG, "patch version directory not found, current version:%s", this.currentVersion);
                tinker.getLoadReporter().onLoadFileNotFound(this.patchVersionDirectory, 1, true);
                break;
            }
            case -7: {
                TinkerLog.e(TAG, "patch version file not found, current version:%s", this.currentVersion);
                if (this.patchVersionFile == null) {
                    throw new TinkerRuntimeException("error load patch version file not exist, but file is null");
                }
                tinker.getLoadReporter().onLoadFileNotFound(this.patchVersionFile, 1, false);
                break;
            }
            case -8: {
                TinkerLog.i(TAG, "patch package check fail", new Object[0]);
                if (this.patchVersionFile == null) {
                    throw new TinkerRuntimeException("error patch package check fail , but file is null");
                }
                int n = intent.getIntExtra("intent_patch_package_patch_check", -10000);
                tinker.getLoadReporter().onLoadPackageCheckFail(this.patchVersionFile, n);
                break;
            }
            case -9: {
                if (this.dexDirectory != null) {
                    TinkerLog.e(TAG, "patch dex file directory not found:%s", this.dexDirectory.getAbsolutePath());
                    tinker.getLoadReporter().onLoadFileNotFound(this.dexDirectory, 3, true);
                    break;
                }
                TinkerLog.e(TAG, "patch dex file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex file directory not found, warning why the path is null!!!!");
            }
            case -10: {
                object = ShareIntentUtil.getStringExtra(intent, "intent_patch_missing_dex_path");
                if (object != null) {
                    TinkerLog.e(TAG, "patch dex file not found:%s", object);
                    tinker.getLoadReporter().onLoadFileNotFound(new File((String)object), 3, false);
                    break;
                }
                TinkerLog.e(TAG, "patch dex file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex file not found, but path is null!!!!");
            }
            case -11: {
                object = ShareIntentUtil.getStringExtra(intent, "intent_patch_missing_dex_path");
                if (object != null) {
                    TinkerLog.e(TAG, "patch dex opt file not found:%s", object);
                    tinker.getLoadReporter().onLoadFileNotFound(new File((String)object), 4, false);
                    break;
                }
                TinkerLog.e(TAG, "patch dex opt file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex opt file not found, but path is null!!!!");
            }
            case -17: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch lib file directory not found:%s", this.libraryDirectory.getAbsolutePath());
                    tinker.getLoadReporter().onLoadFileNotFound(this.libraryDirectory, 5, true);
                    break;
                }
                TinkerLog.e(TAG, "patch lib file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch lib file directory not found, warning why the path is null!!!!");
            }
            case -18: {
                object = ShareIntentUtil.getStringExtra(intent, "intent_patch_missing_lib_path");
                if (object != null) {
                    TinkerLog.e(TAG, "patch lib file not found:%s", object);
                    tinker.getLoadReporter().onLoadFileNotFound(new File((String)object), 5, false);
                    break;
                }
                TinkerLog.e(TAG, "patch lib file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch lib file not found, but path is null!!!!");
            }
            case -12: {
                TinkerLog.e(TAG, "patch dex load fail, classloader is null", new Object[0]);
                break;
            }
            case -13: {
                object = ShareIntentUtil.getStringExtra(intent, "intent_patch_mismatch_dex_path");
                if (object == null) {
                    TinkerLog.e(TAG, "patch dex file md5 is mismatch, but path is null!!!!", new Object[0]);
                    throw new TinkerRuntimeException("patch dex file md5 is mismatch, but path is null!!!!");
                }
                TinkerLog.e(TAG, "patch dex file md5 is mismatch: %s", object);
                tinker.getLoadReporter().onLoadFileMd5Mismatch(new File((String)object), 3);
                break;
            }
            case -19: {
                TinkerLog.i(TAG, "rewrite patch info file corrupted", new Object[0]);
                tinker.getLoadReporter().onLoadPatchInfoCorrupted((String)object, string, file2);
                break;
            }
            case -21: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch resource file directory not found:%s", this.resourceDirectory.getAbsolutePath());
                    tinker.getLoadReporter().onLoadFileNotFound(this.resourceDirectory, 6, true);
                    break;
                }
                TinkerLog.e(TAG, "patch resource file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch resource file directory not found, warning why the path is null!!!!");
            }
            case -22: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch resource file not found:%s", this.resourceFile.getAbsolutePath());
                    tinker.getLoadReporter().onLoadFileNotFound(this.resourceFile, 6, false);
                    break;
                }
                TinkerLog.e(TAG, "patch resource file not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch resource file not found, warning why the path is null!!!!");
            }
            case -24: {
                if (this.resourceFile == null) {
                    TinkerLog.e(TAG, "resource file md5 mismatch, but patch resource file not found!", new Object[0]);
                    throw new TinkerRuntimeException("resource file md5 mismatch, but patch resource file not found!");
                }
                TinkerLog.e(TAG, "patch resource file md5 is mismatch: %s", this.resourceFile.getAbsolutePath());
                tinker.getLoadReporter().onLoadFileMd5Mismatch(this.resourceFile, 6);
                break;
            }
            case -15: {
                tinker.getLoadReporter().onLoadInterpret(1, ShareIntentUtil.getIntentInterpretException(intent));
                break;
            }
            case -16: {
                tinker.getLoadReporter().onLoadInterpret(2, ShareIntentUtil.getIntentInterpretException(intent));
                break;
            }
            case 0: {
                TinkerLog.i(TAG, "oh yeah, tinker load all success", new Object[0]);
                tinker.setTinkerLoaded(true);
                this.dexes = ShareIntentUtil.getIntentPatchDexPaths(intent);
                this.libs = ShareIntentUtil.getIntentPatchLibsPaths(intent);
                this.packageConfig = ShareIntentUtil.getIntentPackageConfig(intent);
                if (this.useInterpretMode) {
                    tinker.getLoadReporter().onLoadInterpret(0, null);
                }
                if (bl && this.versionChanged) {
                    tinker.getLoadReporter().onLoadPatchVersionChanged((String)object, string, file, this.patchVersionDirectory.getName());
                }
                return true;
            }
        }
        return false;
    }

    public String getPackageConfigByName(String string) {
        if (this.packageConfig != null) {
            return this.packageConfig.get(string);
        }
        return null;
    }
}

