/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.reporter;

import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.lib.reporter.PatchReporter;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.UpgradePatchRetry;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.util.List;

public class DefaultPatchReporter
implements PatchReporter {
    private static final String TAG = "Tinker.DefaultPatchReporter";
    private static boolean shouldRetry = false;
    protected final Context context;

    public DefaultPatchReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onPatchServiceStart(Intent intent) {
        TinkerLog.i(TAG, "patchReporter onPatchServiceStart: patch service start", new Object[0]);
        shouldRetry = false;
        UpgradePatchRetry.getInstance(this.context).onPatchServiceStart(intent);
    }

    @Override
    public void onPatchPackageCheckFail(File file, int n) {
        TinkerLog.i(TAG, "patchReporter onPatchPackageCheckFail: package check failed. path: %s, code: %d", file.getAbsolutePath(), n);
        if (n == -3 || n == -4 || n == -8) {
            Tinker.with(this.context).cleanPatchByVersion(file);
        }
    }

    @Override
    public void onPatchVersionCheckFail(File file, SharePatchInfo sharePatchInfo, String string) {
        TinkerLog.i(TAG, "patchReporter onPatchVersionCheckFail: patch version exist. path: %s, version: %s", file.getAbsolutePath(), string);
    }

    @Override
    public void onPatchTypeExtractFail(File file, File file2, String string, int n) {
        TinkerLog.i(TAG, "patchReporter onPatchTypeExtractFail: file extract fail type: %s, path: %s, extractTo: %s, filename: %s", ShareTinkerInternals.getTypeString(n), file.getPath(), file2.getPath(), string);
        Tinker.with(this.context).cleanPatchByVersion(file);
    }

    @Override
    public void onPatchDexOptFail(File file, List<File> list, Throwable throwable) {
        TinkerLog.i(TAG, "patchReporter onPatchDexOptFail: dex opt fail path: %s, dex size: %d", file.getAbsolutePath(), list.size());
        TinkerLog.printErrStackTrace(TAG, throwable, "onPatchDexOptFail:", new Object[0]);
        if (throwable.getMessage().contains("checkDexOptExist failed") || throwable.getMessage().contains("checkDexOptFormat failed")) {
            shouldRetry = true;
            this.deleteOptFiles(list);
            return;
        }
        Tinker.with(this.context).cleanPatchByVersion(file);
    }

    @Override
    public void onPatchResult(File file, boolean bl, long l) {
        TinkerLog.i(TAG, "patchReporter onPatchResult: patch all result path: %s, success: %b, cost: %d", file.getAbsolutePath(), bl, l);
        if (!shouldRetry) {
            UpgradePatchRetry.getInstance(this.context).onPatchServiceResult();
        }
    }

    @Override
    public void onPatchInfoCorrupted(File file, String string, String string2) {
        TinkerLog.i(TAG, "patchReporter onPatchInfoCorrupted: patch info is corrupted. old: %s, new: %s", string, string2);
        Tinker.with(this.context).cleanPatch();
    }

    @Override
    public void onPatchException(File file, Throwable throwable) {
        TinkerLog.i(TAG, "patchReporter onPatchException: patch exception path: %s, throwable: %s", file.getAbsolutePath(), throwable.getMessage());
        TinkerLog.e(TAG, "tinker patch exception, welcome to submit issue to us: https://github.com/Tencent/tinker/issues", new Object[0]);
        TinkerLog.printErrStackTrace(TAG, throwable, "tinker patch exception", new Object[0]);
        Tinker.with(this.context).setTinkerDisable();
        Tinker.with(this.context).cleanPatchByVersion(file);
    }

    private void deleteOptFiles(List<File> object) {
        object = object.iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            SharePatchFileUtil.safeDeleteFile(file);
        }
    }
}

