/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.Build;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.patch.BsDiffPatchInternal;
import com.tencent.tinker.lib.patch.DexDiffPatchInternal;
import com.tencent.tinker.lib.patch.ResDiffPatchInternal;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.IOException;

public class UpgradePatch
extends AbstractPatch {
    private static final String TAG = "Tinker.UpgradePatch";

    @Override
    public boolean tryPatch(Context context, String object, PatchResult object2) {
        Object object3;
        object2 = Tinker.with(context);
        object = new File((String)object);
        if (!((Tinker)object2).isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences(context)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch is disabled, just return", new Object[0]);
            return false;
        }
        if (!SharePatchFileUtil.isLegalFile((File)object)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch file is not found, just return", new Object[0]);
            return false;
        }
        ShareSecurityCheck shareSecurityCheck = new ShareSecurityCheck(context);
        int n = ShareTinkerInternals.checkTinkerPackage(context, ((Tinker)object2).getTinkerFlags(), (File)object, shareSecurityCheck);
        if (n != 0) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchPackageCheckFail", new Object[0]);
            ((Tinker)object2).getPatchReporter().onPatchPackageCheckFail((File)object, n);
            return false;
        }
        String string = SharePatchFileUtil.getMD5((File)object);
        if (string == null) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch md5 is null, just return", new Object[0]);
            return false;
        }
        TinkerLog.i(TAG, "UpgradePatch tryPatch:patchMd5:%s", string);
        String string2 = ((Tinker)object2).getPatchDirectory().getAbsolutePath();
        File file = SharePatchFileUtil.getPatchInfoLockFile(string2);
        File file2 = SharePatchFileUtil.getPatchInfoFile(string2);
        SharePatchInfo sharePatchInfo = SharePatchInfo.readAndCheckPropertyWithLock(file2, file);
        if (sharePatchInfo != null) {
            if (sharePatchInfo.oldVersion == null || sharePatchInfo.newVersion == null || sharePatchInfo.oatDir == null) {
                TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchInfoCorrupted", new Object[0]);
                ((Tinker)object2).getPatchReporter().onPatchInfoCorrupted((File)object, sharePatchInfo.oldVersion, sharePatchInfo.newVersion);
                return false;
            }
            if (!SharePatchFileUtil.checkIfMd5Valid(string)) {
                TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchVersionCheckFail md5 %s is valid", string);
                ((Tinker)object2).getPatchReporter().onPatchVersionCheckFail((File)object, sharePatchInfo, string);
                return false;
            }
            object3 = sharePatchInfo.oatDir.equals("interpet") ? "changing" : sharePatchInfo.oatDir;
            sharePatchInfo = new SharePatchInfo(sharePatchInfo.oldVersion, string, Build.FINGERPRINT, (String)object3);
        } else {
            sharePatchInfo = new SharePatchInfo("", string, Build.FINGERPRINT, "odex");
        }
        object3 = SharePatchFileUtil.getPatchVersionDirectory(string);
        string2 = string2 + "/" + (String)object3;
        TinkerLog.i(TAG, "UpgradePatch tryPatch:patchVersionDirectory:%s", string2);
        object3 = new File(string2 + "/" + SharePatchFileUtil.getPatchVersionFile(string));
        try {
            if (!string.equals(SharePatchFileUtil.getMD5((File)object3))) {
                SharePatchFileUtil.copyFileUsingStream((File)object, (File)object3);
                TinkerLog.w(TAG, "UpgradePatch copy patch file, src file: %s size: %d, dest file: %s size:%d", ((File)object).getAbsolutePath(), ((File)object).length(), ((File)object3).getAbsolutePath(), ((File)object3).length());
            }
        }
        catch (IOException iOException) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:copy patch file fail from %s to %s", ((File)object).getPath(), ((File)object3).getPath());
            ((Tinker)object2).getPatchReporter().onPatchTypeExtractFail((File)object, (File)object3, ((File)object).getName(), 1);
            return false;
        }
        if (!DexDiffPatchInternal.tryRecoverDexFiles((Tinker)object2, shareSecurityCheck, context, string2, (File)object3)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch dex failed", new Object[0]);
            return false;
        }
        if (!BsDiffPatchInternal.tryRecoverLibraryFiles((Tinker)object2, shareSecurityCheck, context, string2, (File)object3)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch library failed", new Object[0]);
            return false;
        }
        if (!ResDiffPatchInternal.tryRecoverResourceFiles((Tinker)object2, shareSecurityCheck, context, string2, (File)object3)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch resource failed", new Object[0]);
            return false;
        }
        if (!DexDiffPatchInternal.waitAndCheckDexOptFile((File)object, (Tinker)object2)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, check dex opt file failed", new Object[0]);
            return false;
        }
        if (!SharePatchInfo.rewritePatchInfoFileWithLock(file2, sharePatchInfo, file)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, rewrite patch info failed", new Object[0]);
            ((Tinker)object2).getPatchReporter().onPatchInfoCorrupted((File)object, sharePatchInfo.oldVersion, sharePatchInfo.newVersion);
            return false;
        }
        TinkerLog.w(TAG, "UpgradePatch tryPatch: done, it is ok", new Object[0]);
        return true;
    }
}

