/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import com.tencent.tinker.commons.dexpatcher.DexPatchApplier;
import com.tencent.tinker.lib.patch.BasePatchInternal;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerParallelDexOptimizer;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareElfFile;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.DexFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DexDiffPatchInternal
extends BasePatchInternal {
    protected static final String TAG = "Tinker.DexDiffPatchInternal";
    protected static final int WAIT_ASYN_OAT_TIME = 10000;
    protected static final int MAX_WAIT_COUNT = 30;
    private static ArrayList<File> optFiles = new ArrayList();

    protected static boolean tryRecoverDexFiles(Tinker object, ShareSecurityCheck shareSecurityCheck, Context context, String string, File file) {
        if (!((Tinker)object).isEnabledForDex()) {
            TinkerLog.w(TAG, "patch recover, dex is not enabled", new Object[0]);
            return true;
        }
        object = shareSecurityCheck.getMetaContentMap().get("assets/dex_meta.txt");
        if (object == null) {
            TinkerLog.w(TAG, "patch recover, dex is not contained", new Object[0]);
            return true;
        }
        long l = SystemClock.elapsedRealtime();
        boolean bl = DexDiffPatchInternal.patchDexExtractViaDexDiff(context, string, (String)object, file);
        long l2 = SystemClock.elapsedRealtime() - l;
        TinkerLog.i(TAG, "recover dex result:%b, cost:%d", bl, l2);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean waitAndCheckDexOptFile(File file, Tinker tinker) {
        if (optFiles.isEmpty()) {
            return true;
        }
        int n = optFiles.size() * 6;
        if (n > 30) {
            n = 30;
        }
        TinkerLog.i(TAG, "dex count: %d, final wait time: %d", optFiles.size(), n);
        for (int i = 0; i < n; ++i) {
            if (DexDiffPatchInternal.checkAllDexOptFile(optFiles, i + 1)) continue;
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                TinkerLog.e(TAG, "thread sleep InterruptedException e:" + interruptedException, new Object[0]);
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : optFiles) {
            TinkerLog.i(TAG, "check dex optimizer file exist: %s, size %d", file2.getName(), file2.length());
            if (SharePatchFileUtil.isLegalFile(file2)) continue;
            TinkerLog.e(TAG, "final parallel dex optimizer file %s is not exist, return false", file2.getName());
            arrayList.add(file2);
        }
        if (!arrayList.isEmpty()) {
            tinker.getPatchReporter().onPatchDexOptFail(file, arrayList, new TinkerRuntimeException("checkDexOptExist failed"));
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Object object = null;
            for (File file3 : optFiles) {
                ShareElfFile shareElfFile;
                int n2;
                TinkerLog.i(TAG, "check dex optimizer file format: %s, size %d", file3.getName(), file3.length());
                try {
                    n2 = ShareElfFile.getFileTypeByMagic(file3);
                }
                catch (IOException iOException) {
                    continue;
                }
                if (n2 != 1) continue;
                try {
                    shareElfFile = new ShareElfFile(file3);
                }
                catch (Throwable throwable) {
                    TinkerLog.e(TAG, "final parallel dex optimizer file %s is not elf format, return false", file3.getName());
                    arrayList.add(file3);
                    object = throwable;
                    continue;
                }
                try {
                    shareElfFile.close();
                }
                catch (IOException iOException) {}
            }
            if (!arrayList.isEmpty()) {
                TinkerRuntimeException tinkerRuntimeException = object == null ? new TinkerRuntimeException("checkDexOptFormat failed") : new TinkerRuntimeException("checkDexOptFormat failed", (Throwable)object);
                tinker.getPatchReporter().onPatchDexOptFail(file, arrayList, tinkerRuntimeException);
                return false;
            }
        }
        return true;
    }

    private static boolean patchDexExtractViaDexDiff(Context object, String string, String fileArray, File file) {
        Object object2 = string + "/dex" + "/";
        if (!DexDiffPatchInternal.extractDexDiffInternals((Context)object, (String)object2, (String)fileArray, file, 3)) {
            TinkerLog.w(TAG, "patch recover, extractDiffInternals fail", new Object[0]);
            return false;
        }
        object = Tinker.with((Context)object);
        fileArray = new File((String)object2);
        fileArray = fileArray.listFiles();
        optFiles.clear();
        if (fileArray != null) {
            String string2;
            File file2;
            int n;
            object2 = new File(string = string + "/odex" + "/");
            if (!((File)object2).exists() && !((File)object2).mkdirs()) {
                TinkerLog.w(TAG, "patch recover, make optimizeDexDirectoryFile fail", new Object[0]);
                return false;
            }
            Object object3 = fileArray;
            int n2 = fileArray.length;
            for (n = 0; n < n2; ++n) {
                file2 = object3[n];
                string2 = SharePatchFileUtil.optimizedPathFor(file2, (File)object2);
                optFiles.add(new File(string2));
            }
            TinkerLog.i(TAG, "patch recover, try to optimize dex file count:%d, optimizeDexDirectory:%s", fileArray.length, string);
            if (ShareTinkerInternals.isVmArt()) {
                object3 = new Vector();
                Throwable[] throwableArray = new Throwable[1];
                TinkerParallelDexOptimizer.optimizeAll(Arrays.asList(fileArray), (File)object2, new TinkerParallelDexOptimizer.ResultCallback((List)object3, throwableArray){
                    long startTime;
                    final /* synthetic */ List val$failOptDexFile;
                    final /* synthetic */ Throwable[] val$throwable;
                    {
                        this.val$failOptDexFile = list;
                        this.val$throwable = throwableArray;
                    }

                    @Override
                    public final void onStart(File file, File file2) {
                        this.startTime = System.currentTimeMillis();
                        TinkerLog.i(DexDiffPatchInternal.TAG, "start to parallel optimize dex %s, size: %d", file.getPath(), file.length());
                    }

                    @Override
                    public final void onSuccess(File file, File file2, File file3) {
                        TinkerLog.i(DexDiffPatchInternal.TAG, "success to parallel optimize dex %s, opt file size: %d, use time %d", file.getPath(), file3.length(), System.currentTimeMillis() - this.startTime);
                    }

                    @Override
                    public final void onFailed(File file, File file2, Throwable throwable) {
                        TinkerLog.i(DexDiffPatchInternal.TAG, "fail to parallel optimize dex %s use time %d", file.getPath(), System.currentTimeMillis() - this.startTime);
                        this.val$failOptDexFile.add(file);
                        this.val$throwable[0] = throwable;
                    }
                });
                if (!object3.isEmpty()) {
                    ((Tinker)object).getPatchReporter().onPatchDexOptFail(file, (List<File>)object3, throwableArray[0]);
                    return false;
                }
            } else {
                object3 = fileArray;
                n2 = fileArray.length;
                for (n = 0; n < n2; ++n) {
                    file2 = object3[n];
                    try {
                        string2 = SharePatchFileUtil.optimizedPathFor(file2, (File)object2);
                        long l = System.currentTimeMillis();
                        DexFile.loadDex((String)file2.getAbsolutePath(), (String)string2, (int)0);
                        TinkerLog.i(TAG, "success single dex optimize file, path: %s, opt file size: %d, use time: %d", file2.getPath(), new File(string2).length(), System.currentTimeMillis() - l);
                        continue;
                    }
                    catch (Throwable throwable) {
                        TinkerLog.e(TAG, "single dex optimize or load failed, path:" + file2.getPath(), new Object[0]);
                        ArrayList<File> arrayList = new ArrayList<File>();
                        arrayList.add(file2);
                        ((Tinker)object).getPatchReporter().onPatchDexOptFail(file, arrayList, throwable);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean checkAllDexOptFile(ArrayList<File> object, int n) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            if (SharePatchFileUtil.isLegalFile(file)) continue;
            TinkerLog.e(TAG, "parallel dex optimizer file %s is not exist, just wait %d times", file.getName(), n);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private static boolean extractDexDiffInternals(Context var0, String var1_3, String var2_4, File var3_5, int var4_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean extractDexToJar(ZipFile zipFile, ZipEntry zipEntry, File file, String string) {
        int n = 0;
        boolean bl = false;
        while (n < 2 && !bl) {
            ++n;
            Object object = new FileOutputStream(file);
            Object object2 = zipFile.getInputStream(zipEntry);
            ZipOutputStream zipOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            TinkerLog.i(TAG, "try Extracting " + file.getPath(), new Object[0]);
            try {
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)object));
                bufferedInputStream = new BufferedInputStream((InputStream)object2);
                object = new byte[16384];
                object2 = new ZipEntry("classes.dex");
                zipOutputStream.putNextEntry((ZipEntry)object2);
                int n2 = bufferedInputStream.read((byte[])object);
                while (n2 != -1) {
                    zipOutputStream.write((byte[])object, 0, n2);
                    n2 = bufferedInputStream.read((byte[])object);
                }
                zipOutputStream.closeEntry();
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(bufferedInputStream);
                SharePatchFileUtil.closeQuietly(zipOutputStream);
                throw throwable;
            }
            SharePatchFileUtil.closeQuietly(bufferedInputStream);
            SharePatchFileUtil.closeQuietly(zipOutputStream);
            bl = SharePatchFileUtil.verifyDexFileMd5(file, string);
            TinkerLog.i(TAG, "isExtractionSuccessful: %b", bl);
            if (bl) continue;
            file.delete();
            if (!file.exists()) continue;
            TinkerLog.e(TAG, "Failed to delete corrupted dex " + file.getPath(), new Object[0]);
        }
        return bl;
    }

    private static boolean extractDexFile(ZipFile zipFile, ZipEntry zipEntry, File file, ShareDexDiffPatchInfo shareDexDiffPatchInfo) {
        String string = ShareTinkerInternals.isVmArt() ? shareDexDiffPatchInfo.destMd5InArt : shareDexDiffPatchInfo.destMd5InDvm;
        String string2 = shareDexDiffPatchInfo.rawName;
        boolean bl = shareDexDiffPatchInfo.isJarMode;
        if (SharePatchFileUtil.isRawDexFile(string2) && bl) {
            return DexDiffPatchInternal.extractDexToJar(zipFile, zipEntry, file, string);
        }
        return DexDiffPatchInternal.extract(zipFile, zipEntry, file, string, true);
    }

    private static void patchDexFile(ZipFile zipFile, ZipFile closeable, ZipEntry zipEntry, ZipEntry zipEntry2, ShareDexDiffPatchInfo shareDexDiffPatchInfo, File file) {
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2;
        block9: {
            bufferedInputStream2 = null;
            bufferedInputStream = null;
            try {
                block10: {
                    bufferedInputStream2 = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    bufferedInputStream = zipEntry2 != null ? new BufferedInputStream(((ZipFile)closeable).getInputStream(zipEntry2)) : null;
                    boolean bl = SharePatchFileUtil.isRawDexFile(shareDexDiffPatchInfo.rawName);
                    if (bl && !shareDexDiffPatchInfo.isJarMode) break block10;
                    closeable = null;
                    try {
                        block12: {
                            block11: {
                                closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                                ((ZipOutputStream)closeable).putNextEntry(new ZipEntry("classes.dex"));
                                if (bl) break block11;
                                ZipInputStream zipInputStream = null;
                                try {
                                    zipInputStream = new ZipInputStream(bufferedInputStream2);
                                    while ((zipEntry = zipInputStream.getNextEntry()) != null && !"classes.dex".equals(zipEntry.getName())) {
                                    }
                                    if (zipEntry == null) {
                                        throw new TinkerRuntimeException("can't recognize zip dex format file:" + file.getAbsolutePath());
                                    }
                                    new DexPatchApplier((InputStream)zipInputStream, (InputStream)bufferedInputStream).executeAndSaveTo((OutputStream)closeable);
                                }
                                catch (Throwable throwable) {
                                    SharePatchFileUtil.closeQuietly(zipInputStream);
                                    throw throwable;
                                }
                                SharePatchFileUtil.closeQuietly(zipInputStream);
                                break block12;
                            }
                            new DexPatchApplier((InputStream)bufferedInputStream2, (InputStream)bufferedInputStream).executeAndSaveTo((OutputStream)closeable);
                        }
                        ((ZipOutputStream)closeable).closeEntry();
                        break block9;
                    }
                    finally {
                        SharePatchFileUtil.closeQuietly(closeable);
                    }
                }
                new DexPatchApplier((InputStream)bufferedInputStream2, (InputStream)bufferedInputStream).executeAndSaveTo(file);
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(bufferedInputStream2);
                SharePatchFileUtil.closeQuietly(bufferedInputStream);
                throw throwable;
            }
        }
        SharePatchFileUtil.closeQuietly(bufferedInputStream2);
        SharePatchFileUtil.closeQuietly(bufferedInputStream);
    }
}

